/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.TableFilter;
import org.opengion.hayabusa.resource.ResourceManager;

public abstract class AbstractTableFilter
implements TableFilter {
    private DBTableModel table = null;
    private String modifyType = null;
    private int[] rowNo = null;
    private boolean useDebug = false;
    private Transaction tran = null;
    private String sql = null;
    private String dbid = null;
    private ResourceManager resource = null;
    private int errCode = 0;
    private ErrorMessage errMessage = null;
    private final Map<String, String> keysVals = new HashMap<String, String>();
    protected final Map<String, String> keysMap = new LinkedHashMap<String, String>();
    protected static final String XML_START_TAG = "<?xml version='1.0' encoding='UTF-8'?>" + CR + "<ROWSET tableName='xxx'>";
    protected static final String XML_END_TAG = "</ROWSET>";
    protected static final String EXEC_START_TAG = "<EXEC_SQL>";
    protected static final String EXEC_END_TAG = "</EXEC_SQL>";
    protected boolean isXml = false;
    protected String execEndTag = null;

    public AbstractTableFilter() {
        this.init(this.keysMap);
    }

    protected void init(Map<String, String> map) {
    }

    @Override
    public void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public void setModifyType(String string) {
        this.modifyType = string;
    }

    @Override
    public String getModifyType() {
        return this.modifyType;
    }

    @Override
    public void setKeysVals(String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setKeyVal(stringArray[i], stringArray2[i]);
            }
        }
    }

    private void setKeyVal(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        String string3 = string.toUpperCase(Locale.JAPAN);
        if (!this.keysMap.containsKey(string3)) {
            String string4 = "<br />" + CR;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string4).append("\u6307\u5b9a\u306e\u30ad\u30fc\u306f\u3001\u3053\u306e tableFilter \u3067\u306f\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002").append(string4).append("  class=[").append(this.getClass().getName()).append(']').append(string4).append("  key  =[").append(string).append(']').append(string4).append("  ======== usage keys ======== ").append(string4);
            for (Map.Entry<String, String> entry : this.keysMap.entrySet()) {
                stringBuilder.append(' ').append(entry.getKey()).append(':').append(entry.getValue()).append(string4);
            }
            stringBuilder.append("  ============================ ").append(string4);
            throw new HybsSystemException(stringBuilder.toString());
        }
        this.keysVals.put(string3, string2);
    }

    @Override
    public void setParameterRows(int[] nArray) {
        if (nArray != null) {
            int n = nArray.length;
            this.rowNo = new int[n];
            System.arraycopy(nArray, 0, this.rowNo, 0, n);
        }
    }

    @Override
    public int[] getParameterRows() {
        return this.rowNo != null ? (int[])this.rowNo.clone() : new int[]{};
    }

    @Override
    public void setTransaction(Transaction transaction) {
        this.tran = transaction;
    }

    @Override
    public Transaction getTransaction() {
        return this.tran;
    }

    @Override
    public void setDbid(String string) {
        this.dbid = string;
    }

    @Override
    public String getDbid() {
        return this.dbid;
    }

    @Override
    public void setSql(String string) {
        this.sql = string;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public void setParamMap(Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.setKeyVal(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void setResource(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    @Override
    public ResourceManager getResource() {
        return this.resource;
    }

    @Override
    public void setDebug(boolean bl) {
        this.useDebug = bl;
    }

    @Override
    public boolean isDebug() {
        return this.useDebug;
    }

    @Override
    public int getErrorCode() {
        return this.errCode;
    }

    @Override
    public ErrorMessage getErrorMessage() {
        return this.errMessage;
    }

    protected ErrorMessage makeErrorMessage(String string, int n) {
        if (this.errMessage == null) {
            this.errMessage = new ErrorMessage(string);
        }
        if (this.errCode < n) {
            this.errCode = n;
        }
        return this.errMessage;
    }

    protected int[] getTableColumnNo(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.table.getColumnNo(stringArray[i]);
        }
        return nArray;
    }

    protected String getValue(String string) {
        return this.keysVals.get(string);
    }
}

