/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.TableWriter;

public abstract class AbstractTableWriter
implements TableWriter {
    private static final String VERSION = "6.0.2.0 (2014/09/19)";
    public static final int STRING = 0;
    public static final int NVAR = 1;
    public static final int NUMBER = 2;
    protected DBTableModel table = null;
    protected DBColumn[] dbColumn = null;
    protected int numberOfColumns = -1;
    protected int[] clmNo = null;
    protected int[] dbType = null;
    private String separator = "\t";
    private String headerSequence = HybsSystem.sys("WRITER_HEADER_SEQUENCE");
    private boolean append = false;
    private String lang = null;
    private String columns = null;
    private String encode = null;
    private boolean useNumber = true;
    private boolean useRenderer = false;

    @Override
    public abstract void writeDBTable();

    @Override
    public abstract void writeDBTable(PrintWriter var1);

    protected boolean createDBColumn() {
        if (this.numberOfColumns >= 0) {
            return true;
        }
        boolean bl = false;
        if (this.lang != null && this.table != null) {
            if (this.columns != null) {
                String[] stringArray = StringUtil.csv2Array((String)this.columns);
                this.numberOfColumns = stringArray.length;
                this.clmNo = new int[this.numberOfColumns];
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    int n;
                    this.clmNo[i] = n = this.table.getColumnNo(stringArray[i], false);
                }
            } else {
                this.numberOfColumns = this.table.getColumnCount();
                this.clmNo = new int[this.numberOfColumns];
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    this.clmNo[i] = i;
                }
            }
            this.dbColumn = this.table.getDBColumns();
            bl = this.numberOfColumns > 0;
            this.dbType = new int[this.numberOfColumns];
            for (int i = 0; i < this.numberOfColumns; ++i) {
                if (this.clmNo[i] < 0) continue;
                String string = this.dbColumn[this.clmNo[i]].getDbType();
                this.dbType[i] = "NVAR".equals(string) ? 1 : ("S9".equals(string) || "R".equals(string) ? 2 : 0);
            }
        }
        return bl;
    }

    protected void writeHeader(PrintWriter printWriter) {
    }

    protected void writeLabel(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Label");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            printWriter.print(this.dbColumn[n].getLabel());
        }
        printWriter.println();
    }

    protected void writeName(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Name");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            printWriter.print(dBTableModel.getColumnName(n));
        }
        printWriter.println();
    }

    protected void writeSize(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Size");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            printWriter.print(this.dbColumn[n].getTotalSize());
        }
        printWriter.println();
    }

    protected void writeClass(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Class");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            printWriter.print(this.dbColumn[n].getClassName());
        }
        printWriter.println();
    }

    protected void writeSeparator(DBTableModel dBTableModel, PrintWriter printWriter) {
        String string = "----";
        if (this.useNumber) {
            printWriter.print("#----");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i != 0) {
                printWriter.print(this.separator);
            }
            printWriter.print(string);
        }
        printWriter.println();
    }

    protected abstract void writeData(DBTableModel var1, PrintWriter var2);

    @Override
    public void setDBTableModel(DBTableModel dBTableModel, String string) {
        this.table = dBTableModel;
        this.lang = string;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public void setHeaderSequence(String string) {
        if (string != null) {
            this.headerSequence = string;
        }
    }

    @Override
    public String getHeaderSequence() {
        return this.headerSequence;
    }

    @Override
    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public void setAppend(boolean bl) {
        this.append = bl;
    }

    @Override
    public boolean isAppend() {
        return this.append;
    }

    @Override
    public void setSheetName(String string) {
        String string2 = "sheetName \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setRefSheetName(String string) {
        String string2 = "refSheetName \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public boolean isExcel() {
        return false;
    }

    @Override
    public void setFilename(String string, String string2) {
        String string3 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string3);
    }

    @Override
    public void setRefFilename(String string) {
        String string2 = "refFilename \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setFontName(String string) {
        String string2 = "fontName \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setFontPoint(short s) {
        String string = "fontPoint \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + s + "]";
        System.err.println(string);
    }

    @Override
    public void setEncode(String string) {
        this.encode = string;
    }

    protected String getEncode() {
        return this.encode;
    }

    @Override
    public void setUseNumber(boolean bl) {
        this.useNumber = bl;
    }

    protected boolean isUseNumber() {
        return this.useNumber;
    }

    @Override
    public void setParam(List<HybsEntry> list) {
        String string = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001XML\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void setColumns(String string) {
        this.columns = string;
    }

    @Override
    public void setSkipRowCount(int n) {
        if (n != 0) {
            String string = "skipRowCount \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + n + "]";
            System.err.println(string);
        }
    }

    @Override
    public void setUseCellStyle(boolean bl) {
        String string = "useCellStyle \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + bl + "]";
        System.err.println(string);
    }

    @Override
    public void setUseAutoCellSize(boolean bl) {
        String string = "useAutoCellSize \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + bl + "]";
        System.err.println(string);
    }

    @Override
    public void setUseActiveWorkbook(boolean bl) {
        String string = "useActiveWorkbook \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + bl + "]";
        System.err.println(string);
    }

    @Override
    public void setPageBreakColumn(String string) {
        String string2 = "pageBreakColumn \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setFileBreakColumn(String string) {
        String string2 = "fileBreakColumn \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setHyperLinkColumn(String string) {
        String string2 = "hyperLinkColumn \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setAddTitleSheet(String string) {
        String string2 = "addTitleSheet \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setUseRenderer(boolean bl) {
        this.useRenderer = bl;
    }

    protected boolean isUseRenderer() {
        return this.useRenderer;
    }

    protected String quotation(String string) {
        return "\"" + StringUtil.replace((String)string, (String)"\"", (String)"\"\"") + "\"";
    }

    protected String quotation2(String string) {
        String string2 = StringUtil.replace((String)string, (String)"\"", (String)"\"\"");
        if (string2 != null && string2.indexOf(HybsSystem.CR) >= 0) {
            string2 = "\"" + string2 + "\"";
        }
        return string2;
    }

    protected void checkParam(String string, Map<String, String> map) {
        if (string == null || map == null) {
            return;
        }
        String string2 = string.toUpperCase(Locale.JAPAN);
        if (!map.containsKey(string2)) {
            String string3 = "<br />" + HybsSystem.CR;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string3).append("\u6307\u5b9a\u306e\u30ad\u30fc\u306f\u3001\u3053\u306e tableWriter \u3067\u306f\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002").append(string3).append("  class=[").append(this.getClass().getName()).append(']').append(string3).append("  key  =[").append(string).append(']').append(string3).append("  ======== usage keys ======== ").append(string3);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuilder.append(' ').append(entry.getKey()).append(':').append(entry.getValue()).append(string3);
            }
            stringBuilder.append("  ============================ ").append(string3);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }
}

