/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.Options;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;

public final class XHTMLTag {
    private static final HybsCryptography HYBS_CRYPTOGRAPHY = new HybsCryptography();
    private static final String[] BUTTON_KEY = new String[]{"type", "name", "value", "onClick", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled", "tabindex", "accesskey", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "autofocus"};
    private static final String[] INPUT_KEY = new String[]{"type", "size", "maxlength", "checked", "src", "alt", "accept", "usemap", "ismap", "id", "class", "lang", "dir", "title", "style", "xml:lang", "readonly", "disabled", "tabindex", "accesskey", "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autocomplete", "autofocus", "pattern", "placeholder", "list", "min", "max", "step", "required"};
    private static final String[] TEXTAREA_KEY = new String[]{"name", "rows", "cols", "id", "class", "lang", "dir", "title", "style", "xml:lang", "readonly", "disabled", "tabindex", "accesskey", "onClick", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autofocus", "placeholder"};
    private static final String[] LINK_KEY = new String[]{"type", "name", "hreflang", "rel", "rev", "charset", "target", "shape", "coords", "onClick", "id", "class", "lang", "dir", "title", "style", "xml:lang", "tabindex", "accesskey", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver"};
    private static final String[] SELECT_KEY = new String[]{"size", "multiple", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled", "tabindex", "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autofocus"};
    private static final String[] OPTION_KEY = new String[]{"value", "label", "selected", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled"};
    private static final String[] FRAME_KEY = new String[]{"name", "longdesc", "marginwidth", "marginheight", "noresize", "scrolling", "frameborder", "id", "class", "title", "style"};
    private static final String[] IMAGE_KEY = new String[]{"src", "alt", "longdesc", "width", "height", "usemap", "ismap", "name", "onClick", "align", "border", "hspace", "vspace", "id", "class", "title", "style", "lang", "dir", "xml:lang", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver"};
    private static final String[] FORM_KEY = new String[]{"action", "method", "enctype", "accept-charset", "accept", "name", "target", "id", "class", "title", "style", "lang", "dir", "xml:lang"};
    private static final String[] SPAN_KEY = new String[]{"id", "class", "title", "style", "lang", "dir", "xml:lang"};
    private static final String[] PRE_KEY = new String[]{"id", "class", "title", "style", "lang", "dir", "xml:lang"};

    private XHTMLTag() {
    }

    public static String button(Attributes attributes) {
        String string = attributes.get("type");
        if ("|submit|reset|button|".indexOf("|" + string + "|") < 0) {
            String string2 = "button \u30bf\u30a4\u30d7\u8a2d\u5b9a\u30a8\u30e9\u30fc [" + string + "]";
            throw new RuntimeException(string2);
        }
        String string3 = attributes.get("body");
        if (string3 == null) {
            string3 = "";
        }
        return new TagBuffer("button").add(attributes.getAttribute(BUTTON_KEY)).addBody(string3).makeTag();
    }

    public static String input(Attributes attributes) {
        String string = attributes.get("name");
        String string2 = attributes.get("value");
        String string3 = attributes.get("optionAttributes");
        return XHTMLTag.input(attributes, string, string2, string3);
    }

    public static String input(Attributes attributes, String string, String string2, String string3) {
        return new TagBuffer("input").add("name", string).add("value", string2).add(attributes.getAttribute(INPUT_KEY)).add(string3).makeTag();
    }

    public static String inputAttri(Attributes attributes) {
        return attributes.getAttribute(INPUT_KEY);
    }

    public static String textareaAttri(Attributes attributes) {
        return attributes.getAttribute(TEXTAREA_KEY);
    }

    public static String selectAttri(Attributes attributes) {
        return attributes.getAttribute(SELECT_KEY);
    }

    public static String hidden(String string, String string2) {
        return XHTMLTag.hidden(string, string2, string);
    }

    public static String hidden(String string, String string2, String string3) {
        return new TagBuffer("input").add("type", "hidden").add("name", string).add("value", string2).add("id", string3).makeTag();
    }

    public static String textarea(Attributes attributes) {
        String string = attributes.get("body");
        if (string == null) {
            string = "";
        }
        return new TagBuffer("textarea").add(attributes.getAttribute(TEXTAREA_KEY)).addBody(string).makeTag();
    }

    public static String link(Attributes attributes) {
        return XHTMLTag.link(attributes, "");
    }

    public static String link(Attributes attributes, String string) {
        String string2 = attributes.get("href");
        String string3 = XHTMLTag.addUrlEncode(string2, string);
        String string4 = StringUtil.nval(attributes.get("body"), string2);
        return new TagBuffer("a").add("href", string3).add(attributes.getAttribute(LINK_KEY)).addBody(string4).makeTag();
    }

    public static String xlink(Attributes attributes, String string) {
        String string2 = attributes.get("href");
        String string3 = XHTMLTag.addUrlEncode(string2, string, "&amp;");
        String string4 = StringUtil.nval(attributes.get("body"), string2);
        return new TagBuffer("a").add("xlink:href", string3).add(attributes.getAttribute(LINK_KEY)).addBody(string4).makeTag();
    }

    public static String select(Attributes attributes, Options options) {
        String string = attributes.get("name");
        String string2 = attributes.get("optionAttributes");
        return XHTMLTag.select(attributes, options, string, string2);
    }

    public static String select(Attributes attributes, Options options, String string, String string2) {
        return new TagBuffer("select").add("name", string).add(attributes.getAttribute(SELECT_KEY)).add(string2).addBody(options.getOption()).makeTag();
    }

    public static String option(Attributes attributes) {
        String string = StringUtil.nval(attributes.get("body"), " ");
        return new TagBuffer("option").add(attributes.getAttribute(OPTION_KEY)).addBody(string).makeTag();
    }

    public static String option(Attributes attributes, String string) {
        if (string != null) {
            String string2 = attributes.get("value");
            String string3 = attributes.get("label");
            String string4 = "label";
            if (string3 == null) {
                string3 = attributes.get("body");
                string4 = "body";
            }
            if (string2 != null && string3 != null) {
                boolean bl = "true".equalsIgnoreCase(string);
                boolean bl2 = string3.startsWith(string2 + ':');
                if (bl && !bl2) {
                    attributes.set(string4, string2 + ':' + string3);
                } else if (!bl && bl2) {
                    attributes.set(string4, string3.substring((string2 + ':').length()));
                }
            }
        }
        return XHTMLTag.option(attributes);
    }

    public static String frame(Attributes attributes) {
        return XHTMLTag.frame(attributes, "");
    }

    public static String frame(Attributes attributes, String string) {
        return new TagBuffer("frame").add("src", XHTMLTag.addUrlEncode(attributes.get("src"), string)).add(attributes.getAttribute(FRAME_KEY)).makeTag();
    }

    public static String urlEncode(String string, String string2) {
        return XHTMLTag.urlEncode(string, string2, "&");
    }

    public static String urlEncode(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return "";
        }
        String[] stringArray = StringUtil.csv2Array(string);
        String[] stringArray2 = StringUtil.csv2Array(string2);
        return XHTMLTag.urlEncode(stringArray, stringArray2, string3);
    }

    public static String urlEncode(String[] stringArray, String[] stringArray2) {
        return XHTMLTag.urlEncode(stringArray, stringArray2, "&");
    }

    public static String urlEncode(String[] stringArray, String[] stringArray2, String string) {
        if (stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0) {
            return "";
        }
        if (stringArray.length != stringArray2.length) {
            String string2 = "urlEncode \u306e\u30ad\u30fc\u3068\u30d0\u30ea\u30e5\u30fc\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + "key.length=[" + stringArray.length + "]  val.length=[" + stringArray2.length + "]";
            throw new RuntimeException(string2);
        }
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray[i] == null || stringArray[i].isEmpty()) {
                return "";
            }
            stringArray3[i] = stringArray2[i] == null || stringArray2[i].isEmpty() ? "" : (stringArray2[i].charAt(0) == '[' ? stringArray2[i] : StringUtil.urlEncode(stringArray2[i]));
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(stringArray[0]).append('=').append(stringArray3[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]).append('=').append(stringArray3[i]);
        }
        return stringBuilder.toString();
    }

    public static String addUrlEncode(String string, String string2) {
        return XHTMLTag.addUrlEncode(string, string2, "&");
    }

    public static String addUrlEncode(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string == null ? "" : string;
        if (string2 == null || string2.isEmpty()) {
            return string4;
        }
        String string6 = string4.indexOf(63) < 0 ? (string2.startsWith(string3) ? string4 + "?" + string2.substring(string3.length()) : string4 + "?" + string2) : (string2.startsWith(string3) ? string4 + string2 : string4 + string3 + string2);
        return string6;
    }

    public static String img(Attributes attributes) {
        return new TagBuffer("img").add(attributes.getAttribute(IMAGE_KEY)).makeTag();
    }

    public static String form(Attributes attributes) {
        String string = attributes.get("body");
        if (string == null) {
            string = "";
        }
        return new TagBuffer("form").add(attributes.getAttribute(FORM_KEY)).addBody(string).makeTag();
    }

    public static String span(Attributes attributes) {
        String string = attributes.get("body");
        if (string == null) {
            string = "";
        }
        return new TagBuffer("span").add(attributes.getAttribute(SPAN_KEY)).add(attributes.get("optionAttributes")).addBody(string).makeTag();
    }

    public static String pre(Attributes attributes) {
        String string = attributes.get("body");
        if (string == null) {
            string = "";
        }
        return new TagBuffer("pre").add(attributes.getAttribute(PRE_KEY)).add(attributes.get("optionAttributes")).addBody(string).makeTag();
    }

    public static String addURLCheckKey(String string, String string2, String string3, long l) {
        String string4 = string2 + "=" + HYBS_CRYPTOGRAPHY.encrypt(string.replace("../", "") + ",time=" + l + ",userid=" + string3);
        return XHTMLTag.addUrlEncode(string, string4);
    }

    public static String embedURLCheckKey(String string, String string2, String string3, long l) {
        int n;
        String string4 = string;
        int n2 = string4.indexOf("href=\"");
        if (n2 >= 0 && (n = string4.indexOf(34, n2 + 6)) >= 0) {
            String string5 = string4.substring(n2 + 6, n);
            string5 = XHTMLTag.addURLCheckKey(string5, string2, string3, l);
            string4 = string4.substring(0, n2) + "href=\"" + string5 + string4.substring(n);
        }
        return string4;
    }
}

