/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.LoggerProcess;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;

public class Process_Logger
extends AbstractProcess
implements LoggerProcess {
    private String logFile;
    private String dispFile;
    private PrintWriter logWriter;
    private PrintWriter dispWriter;
    public static final String DEFAULT_CHARSET = "ISO-2022-JP";
    private String host = "mail.opengion.org";
    private String from = "DUMMY@DUMMY";
    private String to;
    private String subject;
    private boolean useErrMail;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty = new LinkedHashMap<String, String>();

    public Process_Logger() {
        super("org.opengion.fukurou.process.Process_Logger", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.logFile = argument.getProparty("logFile");
        this.dispFile = argument.getProparty("dispFile");
        if (this.logWriter == null && this.logFile != null) {
            this.logWriter = FileUtil.getLogWriter(this.logFile);
        }
        if (this.dispWriter == null && this.dispFile != null) {
            this.dispWriter = FileUtil.getLogWriter(this.dispFile);
        }
        this.host = argument.getProparty("host", this.host);
        this.from = argument.getProparty("from", this.from);
        this.to = argument.getProparty("to", this.to);
        this.subject = argument.getProparty("subject");
        this.useErrMail = this.host != null && this.from != null && this.to != null;
    }

    @Override
    public void end(boolean bl) {
        if (this.logWriter != null) {
            this.logWriter.flush();
            Closer.ioClose(this.logWriter);
        }
        if (this.dispWriter != null) {
            this.dispWriter.flush();
            Closer.ioClose(this.dispWriter);
        }
    }

    @Override
    public void logging(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    @Override
    public void println(String string) {
        if (this.dispWriter != null) {
            this.dispWriter.println(string);
        }
    }

    @Override
    public void errLog(String string, Throwable throwable) {
        String string2 = string;
        if (this.logWriter != null) {
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.append(string).append(CR);
                throwable.printStackTrace(new PrintWriter(stringWriter));
                string2 = stringWriter.toString();
            }
            this.logWriter.println(string2);
        }
        this.println(string2);
        if (this.useErrMail) {
            this.sendmail(string2);
        }
    }

    private void sendmail(String string) {
        Argument argument = this.getArgument();
        String string2 = argument.getProparty("charset", DEFAULT_CHARSET);
        MailTX mailTX = new MailTX(this.host, string2);
        mailTX.setFrom(this.from);
        mailTX.setTo(StringUtil.csv2Array(this.to));
        mailTX.setSubject(this.subject);
        String string3 = argument.getFileProparty("message", "msgFile", false);
        mailTX.setMessage(argument.changeParam(string3) + CR + string);
        mailTX.sendmail();
    }

    @Override
    public void setLoggingWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public void setDisplayWriter(PrintWriter printWriter) {
        this.dispWriter = printWriter;
    }

    @Override
    public String report() {
        return "[" + this.getClass().getName() + "]" + CR + '\t' + "Subject      : " + this.subject + CR + '\t' + "Log     File : " + this.logFile + CR + '\t' + "Display File : " + this.dispFile;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(500).append("Process_Logger \u306f\u3001\u753b\u9762\u51fa\u529b\u3001\u30d5\u30a1\u30a4\u30eb\u30ed\u30b0\u3001\u30a8\u30e9\u30fc\u30e1\u30fc\u30eb\u3092\u7ba1\u7406\u3059\u308b\u3001").append(CR).append("\u30ed\u30ae\u30f3\u30b0\u95a2\u4fc2\u306e LoggerProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append(CR).append("MainProcess \u3067\u4f7f\u7528\u3055\u308c\u308b\u30ed\u30b0\u3068\u3001\u5404\u7a2e Process \u3067\u4f7f\u7528\u3055\u308c\u308b\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4\u3092").append(CR).append("\u7ba1\u7406\u3057\u307e\u3059\u3002\u307e\u305f\u3001\u30a8\u30e9\u30fc\u767a\u751f\u6642\u306e\u3001\u30e1\u30fc\u30eb\u9001\u4fe1\u6a5f\u80fd\u3082\u3001\u3053\u3053\u3067\u7528\u610f\u3057\u307e\u3059\u3002").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_Logger().usage());
    }

    static {
        usableProparty.put("logFile", "\u30ed\u30b0\u51fa\u529b\u5148\u6307\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:null)" + CR + "\u300eSystem.out\u300f,\u300eSystem.err\u300f\u306f\u7279\u6b8a\u306a\u540d\u79f0\u3067\u3059\u3002");
        usableProparty.put("dispFile", "\u753b\u9762\u51fa\u529b\u5148\u6307\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:null)" + CR + "\u300eSystem.out\u300f,\u300eSystem.err\u300f\u306f\u7279\u6b8a\u306a\u540d\u79f0\u3067\u3059\u3002");
        usableProparty.put("host", "\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u30fc");
        usableProparty.put("from", "\u9001\u4fe1\u5143\u30a2\u30c9\u30ec\u30b9");
        usableProparty.put("to", "\u9001\u4fe1\u5148\u30a2\u30c9\u30ec\u30b9\u3092CSV\u5f62\u5f0f\u3067\u4e26\u3079\u308b");
        usableProparty.put("charset", "\u30e1\u30fc\u30eb\u9001\u4fe1\u6642\u306e\u30ad\u30e3\u30e9\u30af\u30bf\u30bb\u30c3\u30c8 [ISO-2022-JP / Windows-31J]");
        usableProparty.put("subject", "\u30bf\u30a4\u30c8\u30eb");
        usableProparty.put("message", "\u672c\u6587\u96db\u5f62\u6587\u7ae0");
        usableProparty.put("msgFile", "\u672c\u6587\u96db\u5f62\u3092\u683c\u7d0d\u3057\u3066\u3044\u308b\u30d5\u30a1\u30a4\u30eb\u306e\u30a2\u30c9\u30ec\u30b9");
        usableProparty.put("{@", "{@XXXX}=YYYY \u6c4e\u7528\u6587\u5b57\u5909\u63db" + CR + "\u30e1\u30c3\u30bb\u30fc\u30b8\u672c\u6587\u306e {@XXXX} \u6587\u5b57\u5217\u3092\u3001YYYY \u6587\u5b57\u5217\u306b\u5909\u63db\u3057\u307e\u3059\u3002");
        usableProparty.put("{@ARG.", "{@ARG.XXX} \u4e88\u7d04\u6587\u5b57\u5909\u63db \u4e0a\u8a18\u5f15\u6570\u3092\u5272\u308a\u5f53\u3066\u307e\u3059\u3002");
        usableProparty.put("{@DATE.", "{@DATE.XXX} \u4e88\u7d04\u6587\u5b57\u5909\u63db \u306e\u6587\u5b57\u3092\u5909\u63db\u3057\u307e\u3059\u3002" + CR + "(SimpleDateFormat \u5f62\u5f0f\u306e\u65e5\u4ed8\u3001\u6642\u523b\u7b49)");
        usableProparty.put("{@ENV.", "{@ENV.XXX} \u4e88\u7d04\u6587\u5b57\u5909\u63db \uff7c\uff7d\uff83\uff91\uff8c\uff9f\uff9b\uff8a\uff9f\uff83\uff68\uff70\u306e\u6587\u5b57\u3092\u5909\u63db\u3057\u307e\u3059\u3002" + CR + "(java -Dkey=value \u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u5f15\u304d\u6e21\u3057\u307e\u3059\u3002)");
    }
}

