/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.db.SelectionFactory;
import org.opengion.hayabusa.resource.CodeData;

public class Renderer_BITBOX
extends AbstractRenderer {
    private static final String VERSION = "6.2.2.4 (2015/04/24)";
    private final Selection selection;
    private final boolean useLabel;
    private final boolean useKeyLabel;
    private String errMsg;

    public Renderer_BITBOX() {
        this.selection = null;
        this.useLabel = false;
        this.useKeyLabel = true;
    }

    private Renderer_BITBOX(DBColumn dBColumn) {
        this.useKeyLabel = "true".equalsIgnoreCase(dBColumn.getAddKeyLabel());
        String string = dBColumn.getAddKeyLabel();
        this.selection = SelectionFactory.newSelection((String)"BITBOX", (CodeData)dBColumn.getCodeData(), (String)string);
        if (this.selection == null) {
            this.errMsg = "codeData \u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002 name=" + dBColumn.getName() + " label=" + dBColumn.getLabel() + " rendType=" + dBColumn.getRenderer();
            System.out.println(this.errMsg);
        }
        this.useLabel = "useLabel".equalsIgnoreCase(dBColumn.getEditorParam());
    }

    public CellRenderer newInstance(DBColumn dBColumn) {
        return new Renderer_BITBOX(dBColumn);
    }

    public String getValue(String string) {
        if (this.selection == null) {
            return "<span class=\"error\">" + this.errMsg + " value=" + string + "</span>";
        }
        return "<pre class=\"BITBOX\">" + this.selection.getValueLabel(string, true) + "</pre>";
    }

    public String getValue(int n, String string) {
        if (this.selection == null) {
            return "<span class=\"error\">" + this.errMsg + " value=" + string + " row=" + n + "</span>";
        }
        return "<pre class=\"BITBOX\">" + this.selection.getValueLabel(string, this.useLabel) + "</pre>";
    }

    public String getWriteValue(String string) {
        if (this.selection == null) {
            return string;
        }
        if (this.useKeyLabel) {
            return string + ':' + this.selection.getValueLabel(string, this.useLabel);
        }
        return this.selection.getValueLabel(string, this.useLabel);
    }
}

