<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:仕様書DB"
	pgid	= "GF2200"
	title	= "画面項目定義テーブル登録"
	date	= "2009/07/08"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select
			 A1.SYSTEM_ID
			,A1.PGID
			,A1.NMSYORI
			,A1.SEQ
			,A1.CLM
			,A1.CLM AS CLM_NAME
			,A1.KBACCS
			,A1.MUST
			,A1.DEFAULT_VAL
			,A1.TABLE_NAME
			,A1.ZOKUSEI
			,A1.SETU
			,C1.NMSYS
			,C1.NMPG
			,C1.HPGID
			,A1.USE_ORDER
			,A1.AS_CLM
			,B1.JOINTYPE
			,A1.AS_TABLE
			,A1.CLS_NAME
			,A1.FGJ
			,A1.UNIQ
		from ( GF92 A1 inner join GF91 B1
				on     A1.SYSTEM_ID  = B1.SYSTEM_ID
				and    A1.PGID       = B1.PGID
				and    A1.TABLE_NAME = B1.TABLE_NAME ) inner join GF90 C1
						on     A1.SYSTEM_ID  = C1.SYSTEM_ID
						and    A1.PGID       = C1.PGID
	<og:where>
		<og:and value = "A1.SYSTEM_ID	=		'{@SYSTEM_ID}'"		/>
		<og:and value = "A1.PGID		LIKE	'{@PGID}'"			/>
		<og:and value = "A1.NMSYORI		=		'{@NMSYORI}'"		/>
		<og:and value = "A1.CLM			LIKE	'{@CLM}'"			/>
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "A1.SYSTEM_ID,A1.PGID,A1.SEQ" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。-->
<og:columnEditor columns="SYSTEM_ID,PGID,NMSYORI,SEQ,CLM" must="true" />

<og:columnEditor column="TABLE_NAME" editor="DBMENU" >
		select TABLE_NAME,TABLE_NAME || ':' || NAME_JA
		from GF02
	 	where FGJ    in   ('0','1') 
		and SYSTEM_ID  =  '{@SYSTEM_ID}' 
		and TBLSYU   =    'D' 
		order by SYSTEM_ID,TABLE_NAME,TBLSYU
</og:columnEditor>

<og:tableFilter classId="LABEL" keys="CLM,LBL" vals="CLM,CLM_NAME" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit value="update" command="COPY"   lbl="COPY"   accesskey="C"  
			keys="lblKey,noWritable" vals='"MSG0045","NMSYS,NMPG,HPGID,CLM_NAME,UNIQ,FGJ"' />
	<og:submit value="update" command="MODIFY" lbl="MODIFY" accesskey="M" 
			keys="noWritable" vals='"NMSYS,NMPG,HPGID,CLM_NAME,UNIQ"' />
	<og:submit  value="update" command="DELETE" lbl="DELETE" accesskey="Z" />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GF92" /></strong></legend>
		<og:submit  value="insertGF92" lbl="INSERT" command="INSERT" />
	</fieldset>
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="COPY_ROW" /></strong></legend>
		<og:submit  value="copyRow" lbl="COPY" command="COPY" />
		<og:select name="NEW_NMSYORI" lbl="NMSYORI" >
			<og:option lbl="" value="" />
			<og:option lbl="GROUP_BY"  value="GROUP_BY" />
		</og:select>
	</fieldset>
	<og:hidden name="SYSTEM_ID" value="{@SYSTEM_ID}" />
	<og:hidden name="PGID"		value="{@PGID}" />
	<og:hidden name="NMSYORI"	value="{@NMSYORI}" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- サンプルではポップアップを使用するためviewFormTypeはHTMLCustomTableを使用します-->
<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ,FGJ"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
