/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.fukurou.util.Attributes;

/**
 * カラムのデータをHIDDENで編集する場合に使用するエディタークラスです。
 *
 * つまり、編集して欲しくないが、データは、飛ばしたい場合に使用します。
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 3.3.3.3 (2003/08/06) 新規作成
 * @og.group データ編集
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_HIDDEN extends AbstractEditor {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.1.7.0 (2010/06/01)" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
//	public Editor_HIDDEN() {}
	public Editor_HIDDEN() { super(); }			// PMD:Document empty constructor 対策

	/**
	 * コンストラクター。
	 *
	 * @og.rev 3.5.5.7 (2004/05/17) attributes.clear() を追加
	 * @og.rev 3.5.6.0 (2004/06/18) XHTMLTag の 内部配列 INPUT_KEY を隠蔽します。
	 * @og.rev 4.3.6.0 (2009/04/01) eventColumn対応
	 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_HIDDEN( final DBColumn clm ) {
	//	super( clm );
		name  = clm.getName();
//		eventColumn = clm.getEventColumn(); // 4.3.6.0 (2009/04/01)
//		eventURL	= clm.getEventURL();	// 4.3.6.0 (2009/04/01)
//		editor		= clm.getEditor();		// 4.3.6.0 (2009/04/01)

		// 6.1.1.0 (2015/01/17) Attributesの連結記述
		attributes = new Attributes()
			.set( "type" ,"hidden" );

//		attributes = new Attributes();
//		attributes.set( "type" ,"hidden" );

//		optAttr = null;
		tagBuffer.add( XHTMLTag.inputAttri( attributes ) );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_HIDDEN( clm );
	}
}
