/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.io;

// import java.io.BufferedReader;
import java.io.File;										// 6.2.0.0 (2015/02/27)

import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.model.POIUtil;					// 6.1.0.0 (2014/12/26) イベント方式
import org.opengion.fukurou.model.TableModelHelper;			// 6.2.0.0 (2015/02/27) クラス名変更
//import org.opengion.fukurou.model.HybsOverflowException;	// 6.2.0.0 (2015/02/27)

// import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
// import org.opengion.hayabusa.db.DBTableModelUtil;		// 6.2.1.0 (2015/03/13)
import org.opengion.hayabusa.io.AbstractTableReader;		// 6.2.0.0 (2015/02/27)

import static org.opengion.fukurou.util.HybsConst.CR ;		// 6.2.2.0 (2015/03/27)

/**
 * POI による、EXCELバイナリファイルを読み取る実装クラスです。
 *
 * ファイル名、シート名を指定して、データを読み取ることが可能です。
 * 第一カラムが # で始まる行は、コメント行なので、読み飛ばします。
 * カラム名の指定行で、カラム名が null の場合は、その列は読み飛ばします。
 *
 * 入力形式は、openXML形式にも対応しています。
 * ファイルの内容に応じて、.xlsと.xlsxのどちらで読み取るかは、内部的に
 * 自動判定されます。
 *
 * @og.rev 3.5.4.8 (2004/02/23) 新規作成
 * @og.rev 4.3.6.7 (2009/05/22) ooxml形式対応
 * @og.group ファイル入力
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
// public class TableReader_Excel extends TableReader_Default {
public class TableReader_Excel extends AbstractTableReader {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.2.3.0 (2015/05/01)" ;

//	6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)。廃止
//	private String  filename		;		// 3.5.4.3 (2004/01/05)

//	private String  sheetName		;		// 3.5.4.2 (2003/12/15)
//	private String  sheetNos		;		// 5.5.7.2 (2012/10/09)

//	private String  constKeys		;		// 5.5.8.2 (2012/11/09) 固定値となるカラム名(CSV形式)
//	private String  constAdrs		;		// 5.5.8.2 (2012/11/09) 固定値となるアドレス(行-列,行-列,・・・)
//	private String	nullBreakClm	;		// 5.5.8.2 (2012/11/09) 取込み条件/Sheet BREAK条件

	/**
	 * DBTableModel から 各形式のデータを作成して,BufferedReader より読み取ります。
	 * コメント/空行を除き、最初の行は、必ず項目名が必要です。
	 * それ以降は、コメント/空行を除き、データとして読み込んでいきます。
	 * このメソッドは、EXCEL 読み込み時に使用します。
	 *
	 * @og.rev 4.0.0.0 (2006/09/31) 新規追加
	 * @og.rev 5.1.6.0 (2010/05/01) columns 処理 追加
	 * @og.rev 5.1.6.0 (2010/05/01) skipRowCountの追加
	 * @og.rev 5.1.8.0 (2010/07/01) Exception をきちっと記述(InvalidFormatException)
	 * @og.rev 5.2.1.0 (2010/10/01) setTableColumnValues メソッドを経由して、テーブルにデータをセットする。
	 * @og.rev 5.5.1.2 (2012/04/06) HeaderData を try の上にだし、エラーメッセージを取得できるようにする。
	 * @og.rev 5.5.7.2 (2012/10/09) sheetNos 追加による複数シートのマージ読み取りサポート
	 * @og.rev 5.5.8.2 (2012/11/09) HeaderData に デバッグフラグを渡します。
	 * @og.rev 6.0.2.5 (2014/10/31) debug=true 時に、進捗が見えるようにします。
	 * @og.rev 6.1.0.0 (2014/12/26) Excel関係改善
	 * @og.rev 6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)。新規
	 * @og.rev 6.2.1.0 (2015/03/13) TableReaderModel を外部からセットします。
	 * @og.rev 6.2.3.0 (2015/05/01) 行読み飛ばし nullSkipClm追加
	 *
	 * @param   file 読み取り元ファイル名
	 * @param   enc ファイルのエンコード文字列(未使用)
	 */
	@Override
//	public void readDBTable() {
	public void readDBTable( final File file , final String enc ) {
		final boolean isDebug = isDebug();			// 5.5.7.2 (2012/10/09) デバッグ情報

	//	if( isDebug ) { System.out.println( " Filename=" + file ) ; }

//		table = DBTableModelUtil.newDBTable();		// 6.2.1.0 (2015/03/13)

//		final TableListener event = new TableListener() {
		final TableModelHelper helper = new TableModelHelper() {
//			private int[] sheets ;					// 6.0.2.0 (2014/09/19) シート番号の配列
			private boolean[] useShtNo ;			// 6.1.0.0 (2014/12/26) 読み取り対象のシート管理
//			private int nullBreakClmAdrs = -1;		// 5.5.8.2 (2012/11/09) nullBreakClm の DBTableModel上のアドレス。-1 は、未使用

			/**
			 * シートの数のイベントが発生します。
			 *
			 * 処理の開始前に、シートの数のイベントが発生します。
			 * これを元に、処理するシート番号の選別が可能です。
			 * 初期実装は、されていません。
			 *
			 * @og.rev 6.1.0.0 (2014/12/26) Excel関係改善
			 *
			 * @param   size  シートの数
			 */
			@Override
			public void sheetSize( final int size ) {
				if( isDebug ) { System.out.println( " sheetSize=" + size ) ; }
				// 5.5.7.2 (2012/10/09) 複数シートのマージ読み取り。 sheetNos の指定が優先される。
				useShtNo = new boolean[size];			// シート数だけ、配列を作成する。
				if( sheetNos != null && sheetNos.length() > 0 ) {
					String[] sheetList = StringUtil.csv2ArrayExt( sheetNos , size-1 );	// 最大シート番号は、シート数-1
//					sheets = new int[sheetList.length];
					for( int i=0; i<sheetList.length; i++ ) {
//						sheets[i] = Integer.parseInt( sheetList[i] );
						int shtNo = Integer.parseInt( sheetList[i] );
						useShtNo[shtNo] = true;			// 読み取り対象のシート番号のみ、ture にセット
					}
				}
				else {
//					sheets = new int[] { 0 };			// 一番目のシート
					useShtNo[0] = true;					// 一番目のシート
				}
			}

			/**
			 * シートの読み取り開始時にイベントが発生します。
			 *
			 * 新しいシートの読み取り開始毎に、１回呼ばれます。
			 * 戻り値が、true の場合は、そのシートの読み取りを継続します。
			 * false の場合は、そのシートの読み取りは行わず、次のシートまで
			 * イベントは発行されません。
			 *
			 * @og.rev 6.0.3.0 (2014/11/13) 新規作成
			 *
			 * @param   shtNm  シート名
			 * @param   shtNo  シート番号(0～)
			 * @return  true:シートの読み取り処理を継続します/false:このシートは読み取りません。
			 */
			@Override
			public boolean startSheet( final String shtNm,final int shtNo ) {
	//			if( isDebug ) { System.out.println( " Sheet[" + shtNo + "]=" + shtNm ) ; }
				super.startSheet( shtNm , shtNo );		// cnstData の呼び出しの為。無しで動くようにしなければ…

				return  ( useShtNo != null && useShtNo[shtNo] ) ||
						( sheetName != null && sheetName.equalsIgnoreCase( shtNm ) ) ;

//				// シート名が指定されている場合は、一致した場合のみ処理する。
//				if( sheetName != null && sheetName.length() > 0 ) {
//					return sheetName.equalsIgnoreCase( shtNm );
//				}
//				else {
//					for( int i=0; i<sheets.length; i++ ) {
//						if(      shtNo == sheets[i] ) { return true;  }
//						else if( shtNo <  sheets[i] ) { return false; }		// 探している配列にない
//					}
//					return false;
//				}
			}

			/**
			 * カラム名配列がそろった段階で、イベントが発生します。
			 *
			 * openGion での標準的な処理は、colNo==0 の時に、val の先頭が、#NAME
			 * で始まるレコードを、名前配列として認識します。
			 * #value( String,int,int ) で、この #NAME だけは、継続処理されます。
			 * その上で、#NAME レコードが終了した時点で、カラム名配列が完成するので
			 * そこで初めて、このメソッドが呼ばれます。
			 *
			 * @og.rev 6.0.3.0 (2014/11/13) 新規作成
			 * @og.rev 6.1.0.0 (2014/12/26) omitNames 属性を追加
			 *
			 * @param   names  カラム名配列(可変長引数)
			 * @see		#value( String,int,int )
			 */
			@Override
			public void columnNames( final String[] names ) {
//				table.init( names.length );
				setTableDBColumn( names ) ;
//				if( nullBreakClm != null ) {
//					// names の並び順、個数は、valsの並び順、個数と一致しているという前提。
//					nullBreakClmAdrs = table.getColumnNo( nullBreakClm, false );	// 5.5.8.2 (2012/11/09) 存在しなければ -1 を返す。
////					for( int i=0; i<names.length; i++ ) {
////						if( nullBreakClm.equalsIgnoreCase( names[i] ) ) {
////							nullBreakClmAdrs = i ;
////							break;
////						}
////					}
//				}
			}

			/**
			 * row にあるセルのオブジェクト値がそろった段階で、イベントが発生します。
			 *
			 * @og.rev 6.0.3.0 (2014/11/13) 新規作成
			 * @og.rev 6.2.1.0 (2015/03/13) setTableColumnValuesに、行番号を引数に追加
			 *
			 * @param   vals    文字列値の１行分の配列
			 * @param   rowNo   行番号(0～)
			 */
			@Override
			public void values( final String[] vals,final int rowNo ) {
//				if( nullBreakClmAdrs >= 0 && ( vals[nullBreakClmAdrs] == null || vals[nullBreakClmAdrs].isEmpty() ) ) {
//					setReadBreak( true );		// nullBreakClm が null の場合は、そのSheet処理を中止する。
//					return ;
//				}
	//			if( isDebug && rowNo % 100 == 0 ) { System.out.println( "   rowNo=" + rowNo ) ; }
//				setTableColumnValues( vals );
				setTableColumnValues( vals,rowNo );		// 6.2.1.0 (2015/03/13)
			}
		};

		helper.setDebug( isDebug );							// 6.2.0.0 (2015/02/27)
		helper.setConstData( constKeys , constAdrs );		// 6.1.0.0 (2014/12/26) 外部から固定値情報を指定。
		helper.setNames( columns , isUseNumber() );			// 6.1.0.0 (2014/12/26) 外部からカラム名配列を指定。
		helper.setSkipRowCount( getSkipRowCount() );		// 6.1.0.0 (2014/12/26) 外部からスキップ行数を指定。
//		helper.setMaxRowCount( getMaxRowCount() );			// 6.2.0.0 (2015/02/27) 外部から最大件数を指定。
		helper.setNullBreakClm( nullBreakClm );				// 6.2.0.0 (2015/02/27) 外部からnullBreakClmを指定。
		helper.setNullSkipClm( nullSkipClm );				// 6.2.3.0 (2015/05/01) 外部からnullSkipClmを指定。

//		try {
//			POIUtil.excelReader( file , helper );
			POIUtil.textReader( file , helper );			// 6.2.3.0 (2015/05/01) extractor → textReader に変更
//		}
//		catch( HybsOverflowException ex ) {					// 6.2.0.0 (2015/02/27) 読み取り件数オーバーフロー
//			table.setOverflow( true );
//		}

		// 最後まで、#NAME が見つから無かった場合
		if( !helper.isNameSet() ) {
			final String errMsg = "最後まで、#NAME が見つかりませんでした。"
							+ CR
							+ "ファイル形式が異なるか、もしくは損傷している可能性があります。"
							+ "Class=[Excel], File=[" + file + "]"
							+ CR ;
			throw new HybsSystemException( errMsg );
		}

		if( isDebug ) { System.out.println( "  TableReader End." ) ; }
	}

//	/**
//	 * DBTableModel から 各形式のデータを作成して,BufferedReader より読み取ります。
//	 * コメント/空行を除き、最初の行は、必ず項目名が必要です。
//	 * それ以降は、コメント/空行を除き、データとして読み込んでいきます。
//	 *
//	 * @og.rev 3.5.4.3 (2004/01/05) 引数に、BufferedReader を受け取る要に変更します。
//	 * @og.rev 4.0.0.0 (2006/09/31) UnsupportedOperationException を発行します。
//	 * @og.rev 6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)。廃止
//	 *
//	 * @param   reader 各形式のデータ(使用していません)
//	 */
//	@Override
//	public void readDBTable( final BufferedReader reader ) {
//		final String errMsg = "このクラスでは実装されていません。";
//		throw new UnsupportedOperationException( errMsg );
//	}

//	/**
//	 * DBTableModelのデータとしてEXCELファイルを読み込むときのシート名を設定します。
//	 * これにより、複数の形式の異なるデータを順次読み込むことや、シートを指定して
//	 * 読み取ることが可能になります。
//	 * sheetNos と sheetName が同時に指定された場合は、sheetNos が優先されます。エラーにはならないのでご注意ください。
//	 * のでご注意ください。
//	 *
//	 * @og.rev 3.5.4.2 (2003/12/15) 新規追加
//	 * @og.rev 6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)。廃止
//	 *
//	 * @param   sheetName シート名
//	 */
//	@Override
//	public void setSheetName( final String sheetName ) {
//		this.sheetName = sheetName;
//	}

//	/**
//	 * EXCELファイルを読み込むときのシート番号を指定します(初期値:0)。
//	 *
//	 * EXCEL読み込み時に複数シートをマージして取り込みます。
//	 * シート番号は、0 から始まる数字で表します。
//	 * ヘッダーは、最初のシートのカラム位置に合わせます。（ヘッダータイトルの自動認識はありません。）
//	 * よって、指定するシートは、すべて同一レイアウトでないと取り込み時にカラムのずれが発生します。
//	 * 
//	 * シート番号の指定は、CSV形式で、複数指定できます。また、N-M の様にハイフンで繋げることで、
//	 * N 番から、M 番のシート範囲を一括指定可能です。また、"*" による、全シート指定が可能です。
//	 * これらの組み合わせも可能です。（ 0,1,3,5-8,10-* ）
//	 * ただし、"*" に関しては例外的に、一文字だけで、すべてのシートを表すか、N-* を最後に指定するかの
//	 * どちらかです。途中には、"*" は、現れません。
//	 * シート番号は、重複(1,1,2,2)、逆転(3,2,1) での指定が可能です。これは、その指定順で、読み込まれます。
//	 * sheetNos と sheetName が同時に指定された場合は、sheetNos が優先されます。エラーにはならないのでご注意ください。
//	 * このメソッドは、isExcel() == true の場合のみ利用されます。
//	 * 
//	 * 初期値は、0（第一シート） です。
//	 *
//	 * ※ このクラスでは実装されていません。
//	 *
//	 * @og.rev 5.5.7.2 (2012/10/09) 新規追加
//	 * @og.rev 6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)。廃止
//	 *
//	 * @param   sheetNos EXCELファイルのシート番号（0から始まる）
//	 * @see		#setSheetName( String ) 
//	 */
//	@Override
//	public void setSheetNos( final String sheetNos ) {
//		this.sheetNos = sheetNos;
//	}

//	/**
//	 * 固定値となるカラム名(CSV形式)と、constAdrs 固定値となるアドレス(行-列,行-列,・・・)を設定します。
//	 *
//	 * アドレスは、EXCEL上の行-列をCSV形式で指定します。
//	 * 行列は、EXCELオブジェクトに準拠するため、０から始まる整数です。
//	 * 0-0 ⇒ A1 , 1-0 ⇒ A2 , 0-1 ⇒ B1 になります。
//	 * これにより、シートの一か所に書かれている情報を、DBTableModel のカラムに固定値として
//	 * 設定することができます。
//	 * 例として、DB定義書で、テーブル名をシートの全レコードに設定したい場合などに使います。
//	 * このメソッドは、isExcel() == true の場合のみ利用されます。
//	 *
//	 * 5.7.6.3 (2014/05/23) より、
//	 *   ①EXCEL表記に準拠した、A1,A2,B1 の記述も処理できるように対応します。
//	 *     なお、A1,A2,B1 の記述は、必ず、英字1文字＋数字 にしてください。(A～Zまで)
//	 *   ②処理中のEXCELシート名をカラムに割り当てるために、"SHEET" という記号に対応します。
//	 * 例えば、sheetConstKeys="CLM,LANG,NAME" とし、sheetConstAdrs="0-0,A2,SHEET" とすると、
//	 * NAMEカラムには、シート名を読み込むことができます。
//	 * これは、内部処理の簡素化のためです。
//	 *
//	 * 例として、DB定義書で、テーブル名をシートの全レコードに設定したい場合などに使います。
//	 * このメソッドは、isExcel() == true の場合のみ利用されます。
//	 *
//	 * @og.rev 5.5.8.2 (2012/11/09) 新規追加
//	 * @og.rev 6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)。廃止
//	 *
//	 * @param   constKeys 固定値となるカラム名(CSV形式)
//	 * @param   constAdrs 固定値となるアドレス(行-列,行-列,・・・)
//	 */
//	@Override
//	public void setSheetConstData( final String constKeys,final String constAdrs ) {
//		this.constKeys = constKeys;
//		this.constAdrs = constAdrs;
//	}

//	/**
//	 * ここに指定されたカラム列に NULL が現れた時点で読み取りを中止します。
//	 *
//	 * これは、指定のカラムは必須という事を条件に、そのレコードだけを読み取る処理を行います。
//	 * 複数Sheetの場合は、次のSheetを読みます。
//	 * 現時点では、Excel の場合のみ有効です。
//	 *
//	 * @og.rev 5.5.8.2 (2012/11/09) 新規追加
//	 * @og.rev 6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)
//	 *
//	 * @param   clm カラム列
//	 */
//	@Override
//	public void setNullBreakClm( final String clm ) {
//		nullBreakClm = clm;
//	}

//	/**
//	 * このクラスが、EXCEL対応機能を持っているかどうかを返します。
//	 *
//	 * EXCEL対応機能とは、シート名のセット、読み込み元ファイルの
//	 * Fileオブジェクト取得などの、特殊機能です。
//	 * 本来は、インターフェースを分けるべきと考えますが、taglib クラス等の
//	 * 関係があり、問い合わせによる条件分岐で対応します。
//	 *
//	 * @og.rev 3.5.4.3 (2004/01/05) 新規追加
//	 * @og.rev 6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)。廃止
//	 *
//	 * @return	EXCEL対応機能を持っているかどうか(常にtrue)
//	 */
//	@Override
//	public boolean isExcel() {
//		return true;
//	}

//	/**
//	 * 読み取り元ファイル名をセットします。(DIR + Filename)
//	 * これは、EXCEL追加機能として実装されています。
//	 *
//	 * @og.rev 3.5.4.3 (2004/01/05) 新規作成
//	 * @og.rev 6.2.0.0 (2015/02/27) TableReader クラスの呼び出し元メソッドの共通化(EXCEL,TEXT)。廃止
//	 *
//	 * @param   filename 読み取り元ファイル名
//	 */
//	@Override
//	public void setFilename( final String filename ) {
//		this.filename = filename;
//		if( filename == null ) {
//			final String errMsg = "ファイル名が指定されていません。" ;
//			throw new HybsSystemException( errMsg );
//		}
//	}
}
