/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.FormatterType;

public class TableFormatter {
    public static final String HYBS_ITD_MARKER = "h_itd_marker";
    private static final Pattern ptnKey = Pattern.compile("[ \t]+</td");
    private FormatterType formatType;
    private int[] location;
    private String[] format;
    private String formatTag;
    private String rowspan = " rowspan=\"2\"";
    private String trTag;
    private boolean noClass;
    private char[] type;
    private String usableKey;
    private int usableKeyNo = -1;
    private String usableList = "1";
    private String keyBreakClm;
    private int breakClmNo = -1;
    private String breakVal;
    private String itdBody = "";
    private Formatter formatter;

    public void setFormat(String string, boolean bl) {
        int n = string.indexOf("<table");
        int n2 = string.indexOf("<tr");
        if (n2 >= 0 && (n < 0 || n2 < n) && bl) {
            int n3 = string.indexOf(62, n2);
            this.formatTag = string.substring(n3 + 1);
            this.trTag = string.substring(0, n3 + 1);
        } else {
            this.formatTag = string;
            this.trTag = null;
        }
        Matcher matcher = ptnKey.matcher(this.formatTag);
        this.formatTag = matcher.replaceAll("</td");
    }

    public void setFormat(String string) {
        this.setFormat(string, true);
    }

    public String getFormat() {
        if (this.trTag != null) {
            return this.decodeSanitizedStr(this.trTag + this.formatTag);
        }
        return this.decodeSanitizedStr(this.formatTag);
    }

    public void makeFormat(DBTableModel dBTableModel) {
        this.formatter = new Formatter((DataModel)dBTableModel);
        this.formatter.setFormat(this.formatTag);
        this.location = this.formatter.getClmNos();
        this.format = this.formatter.getFormat();
        for (int i = 0; i < this.format.length; ++i) {
            this.format[i] = this.decodeSanitizedStr(this.format[i]);
        }
        this.type = this.formatter.getType();
        if (this.usableKey != null) {
            this.usableKeyNo = dBTableModel.getColumnNo(this.usableKey);
        }
        if (this.keyBreakClm != null) {
            this.breakClmNo = dBTableModel.getColumnNo(this.keyBreakClm);
            this.breakVal = null;
        }
    }

    public void setFormatType(FormatterType formatterType) {
        this.formatType = formatterType;
    }

    public FormatterType getFormatType() {
        return this.formatType;
    }

    public void setRowspan(String string) {
        this.rowspan = string == null || string.isEmpty() || string.equals("1") ? "" : " rowspan=\"" + string + "\"";
    }

    public String getRowspan() {
        return this.rowspan;
    }

    public int getLocationSize() {
        return this.location.length;
    }

    public int getLocation(int n) {
        return this.location[n];
    }

    protected void setNoDisplay(int n) {
        int n2;
        this.location[n] = -9;
        int n3 = n2 = this.format[n] == null ? -1 : this.format[n].indexOf("<td");
        if (n2 >= 0) {
            int n4 = this.format[n].indexOf("style=\"");
            this.format[n] = n4 >= 0 ? this.format[n].substring(0, n4 += "style=\"".length()) + "display:none;" + this.format[n].substring(n4) : this.format[n].substring(0, n2 += "<td".length()) + " style=\"display:none;\"" + this.format[n].substring(n2);
        }
    }

    public String getFormat(int n) {
        return this.format[n];
    }

    public String getSystemFormat(int n, int n2) {
        if (n2 == -1) {
            return String.valueOf(n);
        }
        if (n2 == -2) {
            return this.formatter.getJson(n);
        }
        if (n2 == -9) {
            return "";
        }
        String string = "\u30b7\u30b9\u30c6\u30e0\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u306f\u3001\u4e0b\u8a18\u306e\u5f62\u5f0f\u3057\u304b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + n2 + "]" + HybsConst.CR + "  : [KEY.\u30ab\u30e9\u30e0\u540d] : \u884c\u756a\u53f7\u4ed8\u304d\u30ab\u30e9\u30e0\u540d" + HybsConst.CR + "  : [I]            : \u884c\u756a\u53f7" + HybsConst.CR + "  : [ROW.ID]       : \u884c\u6bce\u306e\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9\u306eID" + HybsConst.CR + "  : [ROW.JSON]     : \u884c\u6bce\u306e\u5168\u30c7\u30fc\u30bf\u306eJavaScript\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u5f62\u5f0f";
        throw new HybsSystemException(string);
    }

    public char getType(int n) {
        return this.type[n];
    }

    public String getTrTag() {
        if (this.trTag == null) {
            return "";
        }
        return this.decodeSanitizedStr(this.trTag);
    }

    public void setNoClass(String string) {
        this.noClass = StringUtil.nval((String)string, (boolean)this.noClass);
    }

    public boolean isNoClass() {
        return this.noClass;
    }

    public void setUsableKey(String string) {
        this.usableKey = string;
    }

    public void setUsableList(String string) {
        if (string != null) {
            this.usableList = string;
        }
    }

    public void setKeyBreakClm(String string) {
        this.keyBreakClm = string;
    }

    public boolean isUse(int n, DBTableModel dBTableModel) {
        String string;
        if (this.usableKeyNo < 0 && this.breakClmNo < 0) {
            return true;
        }
        if (this.usableKeyNo >= 0 && this.usableList.indexOf(string = ((String)dBTableModel.getValue(n, this.usableKeyNo)).trim()) >= 0) {
            return true;
        }
        if (this.breakClmNo >= 0 && !(string = ((String)dBTableModel.getValue(n, this.breakClmNo)).trim()).equals(this.breakVal)) {
            this.breakVal = string;
            return true;
        }
        return false;
    }

    public void setItdBody(String string) {
        if (string != null) {
            this.itdBody = string;
        }
    }

    public String getItdBody() {
        return this.itdBody;
    }

    private String decodeSanitizedStr(String string) {
        if (string != null && string.indexOf("\\]\\") >= 0) {
            return string.replace("\\]\\", "[");
        }
        return string;
    }
}

