/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.util.ArrayList;
import org.opengion.fukurou.model.DataModel;

public class Formatter {
    public static final String JOINT_STRING = "__";
    public static final String ROW_ID_KEY = "cb";
    public static final int SYS_ROWNUM = -1;
    public static final int SYS_JSON = -2;
    public static final int NO_DISPLAY = -9;
    private final DataModel<?> model;
    private int[] clmNos;
    private String[] format;
    private String[] clmKeys;
    private char[] type;

    public Formatter(DataModel<?> dataModel) {
        this.model = dataModel;
    }

    public void setFormat(String string) {
        this.makeFormatList(string);
        this.advanceFormat();
    }

    private void makeFormatList(String string) {
        int n = 0;
        int n2 = string.indexOf(91);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (n2 >= 0) {
            int n3 = string.indexOf(93, n2);
            if (n3 < 0) {
                String string2 = "[ \u3068 ] \u3068\u306e\u5bfe\u5fdc\u95a2\u4fc2\u304c\u305a\u308c\u3066\u3044\u307e\u3059\u3002format=[" + string + "] : index=" + n2;
                throw new RuntimeException(string2);
            }
            if (n2 > 0) {
                arrayList2.add(string.substring(n, n2));
            } else {
                arrayList2.add("");
            }
            arrayList.add(string.substring(n2 + 1, n3));
            n = n3 + 1;
            n2 = string.indexOf(91, n);
        }
        arrayList2.add(string.substring(n));
        this.format = arrayList2.toArray(new String[arrayList2.size()]);
        this.clmKeys = arrayList.toArray(new String[arrayList.size()]);
    }

    private void advanceFormat() {
        int n = this.clmKeys.length;
        this.clmNos = new int[n];
        this.type = new char[n];
        for (int i = 0; i < n; ++i) {
            String string = this.clmKeys[i];
            char c = string.charAt(0);
            if (c == '#' || c == '$' || c == '!') {
                this.type[i] = c;
                this.clmKeys[i] = string = string.substring(1);
                this.clmNos[i] = this.model.getColumnNo(string);
                continue;
            }
            if (string.startsWith("KEY.")) {
                this.clmNos[i] = -1;
                this.format[i] = this.format[i] + string.substring(4) + JOINT_STRING;
                continue;
            }
            if ("I".equals(string)) {
                this.clmNos[i] = -1;
                continue;
            }
            if ("ROW.ID".equals(string)) {
                this.clmNos[i] = -1;
                this.format[i] = this.format[i] + ROW_ID_KEY;
                continue;
            }
            this.clmNos[i] = "ROW.JSON".equals(string) ? -2 : this.model.getColumnNo(string);
        }
    }

    public String getValue(int n, int n2) {
        String string;
        if (n2 >= 0) {
            string = String.valueOf(this.model.getValue(n, n2));
        } else if (n2 == -1) {
            string = String.valueOf(n);
        } else if (n2 == -2) {
            string = this.getJson(n);
        } else {
            String string2 = "\u6307\u5b9a\u306e\u30ab\u30e9\u30e0\u756a\u53f7\u306b\u8a72\u5f53\u3059\u308b\u51e6\u7406\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002clm=[" + n2 + "]";
            throw new RuntimeException(string2);
        }
        return string;
    }

    public String getFormatString(int n) {
        return this.getFormatString(n, null);
    }

    public String getFormatString(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n2 = this.clmNos.length;
        block4: for (int i = 0; i < n2; ++i) {
            stringBuilder.append(this.format[i]);
            if (this.clmNos[i] == -1) {
                stringBuilder.append(n);
                continue;
            }
            if (this.clmNos[i] == -2) {
                stringBuilder.append(this.getJson(n));
                continue;
            }
            if (string == null || string.isEmpty()) {
                stringBuilder.append(this.model.getValue(n, this.clmNos[i]));
                continue;
            }
            switch (this.model.getNativeType(this.clmNos[i])) {
                case INT: 
                case LONG: 
                case DOUBLE: {
                    stringBuilder.append(this.model.getValue(n, this.clmNos[i]));
                    continue block4;
                }
                case STRING: 
                case CALENDAR: {
                    stringBuilder.append(string).append(this.model.getValue(n, this.clmNos[i])).append(string);
                    continue block4;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected enumrated value! " + (Object)((Object)this.model.getNativeType(this.clmNos[i]))));
                }
            }
        }
        stringBuilder.append(this.format[n2]);
        return stringBuilder.toString();
    }

    public String getQueryFormatString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = this.clmKeys.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.format[i]).append('?');
        }
        stringBuilder.append(this.format[n]);
        return stringBuilder.toString();
    }

    public String[] getClmKeys() {
        return (String[])this.clmKeys.clone();
    }

    public int[] getClmNos() {
        return (int[])this.clmNos.clone();
    }

    public String[] getFormat() {
        return (String[])this.format.clone();
    }

    public char[] getType() {
        return (char[])this.type.clone();
    }

    public String getJson(int n) {
        String[] stringArray = this.model.getNames();
        ?[] objArray = this.model.getValues(n);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("{'I':'").append(n).append('\'');
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(",'").append(stringArray[i]).append("':'");
            stringBuilder.append(objArray[i]).append('\'');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

