/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;

public class TableWriter_JSON
extends TableWriter_Default {
    private static final String VERSION = "6.0.1.2 (2014/08/08)";
    private static final Map<String, String> keysMap = new LinkedHashMap<String, String>();
    private String jsonName;
    private boolean toLowerCase;

    @Override
    public void writeDBTable(PrintWriter printWriter) {
        super.setHeaderSequence("D");
        super.writeDBTable(printWriter);
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = dBTableModel.getRowCount();
        String[] stringArray = dBTableModel.getNames();
        if (this.toLowerCase) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].toLowerCase(Locale.JAPAN);
            }
        }
        if (this.jsonName != null) {
            printWriter.println("{");
            printWriter.print("\"");
            printWriter.print(this.jsonName);
            printWriter.print("\":");
        }
        printWriter.println("[");
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                printWriter.print(",");
            }
            printWriter.print("{");
            for (int j = 0; j < this.numberOfColumns; ++j) {
                int n2;
                if (j > 0) {
                    printWriter.print(",");
                }
                if ((n2 = this.clmNo[j]) < 0) continue;
                String string = (String)dBTableModel.getValue(i, n2);
                if (string.contains("\\") || string.contains("\"")) {
                    stringBuilder.setLength(0);
                    for (int k = 0; k < string.length(); ++k) {
                        char c = string.charAt(k);
                        if (c == '\\' || c == '\"') {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                    }
                    string = stringBuilder.toString();
                }
                printWriter.print('\"');
                printWriter.print(stringArray[n2]);
                printWriter.print("\":\"");
                printWriter.print(string);
                printWriter.print('\"');
            }
            printWriter.println("}");
        }
        printWriter.println("]");
        if (this.jsonName != null) {
            printWriter.println("}");
        }
    }

    public void setParam(List<HybsEntry> list) {
        if (list != null && !list.isEmpty()) {
            for (HybsEntry hybsEntry : list) {
                String string = hybsEntry.getKey();
                this.checkParam(string, keysMap);
                String string2 = hybsEntry.getValue();
                if (string2 == null || string2.length() <= 0) continue;
                if ("JsonName".equalsIgnoreCase(string)) {
                    this.jsonName = string2;
                    continue;
                }
                if (!"LowerCase".equalsIgnoreCase(string)) continue;
                this.toLowerCase = Boolean.parseBoolean(string2);
            }
        }
    }

    static {
        keysMap.put("JSONNAME", "JSON\u5f62\u5f0f\u3067\u3001\u914d\u5217\u3092\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3068\u3057\u3066\u307e\u3068\u3081\u308b\u5834\u5408\u306b\u4f7f\u3046");
        keysMap.put("LOWERCASE", "\u30ab\u30e9\u30e0\u540d(=\u30d1\u30e9\u30e1\u30fc\u30bf\u540d)\u3092\u5c0f\u6587\u5b57\u306b\u3059\u308b\u5834\u5408\u3001true \u3092\u30bb\u30c3\u30c8(\u521d\u671f\u5024:false)");
    }
}

