/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.report;

import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.report.AbstractCSVPrintPointService;

public class CSVPrintPointService_RFW
extends AbstractCSVPrintPointService {
    private final StringBuilder strCSV = new StringBuilder(200);
    private static final String csvEncode = HybsSystem.sys((String)"REPORT_CSV_TEXT_ENCODE");
    private static final String RFW_CSV_OUTPUTDIR = HybsSystem.sys((String)"RFW_CSV_OUTPUTDIR");

    public boolean execute() {
        System.out.print("CSV create ... ");
        PrintWriter printWriter = null;
        try {
            this.makeheader();
            this.makebody();
            String string = this.dmngrp != null && this.dmngrp.contains("BIG") ? RFW_CSV_OUTPUTDIR + "_BIG" : RFW_CSV_OUTPUTDIR;
            String string2 = this.listid + "_" + this.grpid + "_" + this.ykno + ".csv";
            printWriter = FileUtil.getPrintWriter((File)new File(string, string2), (String)csvEncode);
            printWriter.write(this.strCSV.toString());
            printWriter.flush();
        }
        catch (Throwable throwable) {
            try {
                this.errMsg.append("CSV Print Request Execution Error. ").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.systemId).append("] , ").append("YKNO=[").append(this.ykno).append("] , ").append(throwable.toString()).append(HybsConst.CR);
                throw new RuntimeException(this.errMsg.toString(), throwable);
            }
            catch (Throwable throwable2) {
                Closer.ioClose(printWriter);
                throw throwable2;
            }
        }
        Closer.ioClose((Closeable)printWriter);
        return true;
    }

    private void makeheader() {
        int n;
        this.strCSV.append("<rdstart>").append(HybsConst.CR).append("RDSetForm=\"").append(this.modelname).append('\"').append(HybsConst.CR);
        if ("I".equals(this.fgrun)) {
            this.strCSV.append("RDSetOutputMode=PDF").append(HybsConst.CR).append("RDSetOutputFileName=\"").append(this.outdir).append('\"').append(HybsConst.CR);
        } else if ("H".equals(this.fgrun)) {
            this.strCSV.append("RDSetOutputMode=XLS").append(HybsConst.CR).append("RDSetOutputFileName=\"").append(this.outdir).append('\"').append(HybsConst.CR);
        } else {
            this.strCSV.append("RDSetOutputMode=SPOOL").append(HybsConst.CR).append("RDSetOutputPrinter=\"").append(this.prtid).append('\"').append(HybsConst.CR);
        }
        if (this.option != null && this.option.length() > 0) {
            this.strCSV.append(this.option).append(HybsConst.CR);
        }
        this.strCSV.append("<rdend>").append(HybsConst.CR);
        for (n = 0; n < this.table.getColumnCount(); ++n) {
            if (n > 0) {
                this.strCSV.append(',');
            }
            this.strCSV.append(this.table.getColumnName(n));
        }
        if (this.tableH != null) {
            for (n = 0; n < this.tableH.getColumnCount(); ++n) {
                this.strCSV.append(",H_").append(this.tableH.getColumnName(n));
            }
        }
        if (this.tableF != null) {
            for (n = 0; n < this.tableF.getColumnCount(); ++n) {
                this.strCSV.append(",F_").append(this.tableF.getColumnName(n));
            }
        }
        this.strCSV.append(HybsConst.CR);
    }

    private void makebody() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int n;
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                if (j > 0) {
                    this.strCSV.append(',');
                }
                this.strCSV.append('\"').append(StringUtil.replace((String)StringUtil.getReplaceEscape((String)((String)this.table.getValue(i, j))), (String)"\"", (String)"\"\"")).append('\"');
            }
            if (this.tableH != null) {
                for (n = 0; n < this.tableH.getColumnCount(); ++n) {
                    this.strCSV.append(",\"").append(StringUtil.replace((String)StringUtil.getReplaceEscape((String)((String)this.tableH.getValue(0, n))), (String)"\"", (String)"\"\"")).append('\"');
                }
            }
            if (this.tableF != null) {
                for (n = 0; n < this.tableF.getColumnCount(); ++n) {
                    this.strCSV.append(",\"").append(StringUtil.replace((String)StringUtil.getReplaceEscape((String)((String)this.tableF.getValue(0, n))), (String)"\"", (String)"\"\"")).append('\"');
                }
            }
            this.strCSV.append(HybsConst.CR);
        }
    }
}

