/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.opengion.fukurou.util.ColorMap;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.ChartFactory;
import org.opengion.hayabusa.io.HybsCategoryDataset;
import org.opengion.hayabusa.io.HybsDrawItem;
import org.opengion.hayabusa.io.HybsLineRenderer;
import org.opengion.hayabusa.io.HybsNumberAxis;
import org.opengion.hayabusa.io.HybsStackedBarRenderer;
import org.opengion.hayabusa.io.ShapeList;
import org.opengion.hayabusa.io.TypeRenderer;
import org.opengion.hayabusa.io.ValueMarkOverColors;

public class ChartDataset {
    private Dataset dataset;
    private String query;
    private String chartType;
    private String needleType;
    private boolean baseLegend = true;
    private String valueLabel;
    private double[] markValues;
    private Color[] markColors = new Color[]{Color.RED};
    private Color[] markOverColors;
    private boolean useMarkAnchor = true;
    private int dynamicOCNo = -1;
    private int dynamicOCadrs = -1;
    private String lowerBound;
    private String upperBound;
    private String tickSize;
    private boolean useGradient;
    private boolean shapesVisible = true;
    private Color[] shapeColors;
    private String shapeScale;
    private boolean useDottedLine;
    private Color[] seriesColors;
    private String[] seriesLabels;
    private boolean isLabelsVisible = true;
    private boolean isMarksVisible = true;
    private boolean isItemValVisible;
    private boolean isItemLastVisible;
    private boolean useItemLabelSep = true;
    private String barWidth;
    private String maxBarWidth;
    private String itemMargin;
    private String visibleLimit;
    private String valueInset;
    private double domainMargin;
    private String timeFormatType;
    private boolean useVerticalLabels;
    private boolean useCategoryColor;

    public void makeDataset(Connection connection, String string) throws SQLException {
        this.dataset = ChartFactory.newDataset(connection, string, this.chartType, this.seriesLabels, this.useCategoryColor);
        this.query = string;
        if (this.dataset instanceof DefaultValueDataset) {
            if (this.markValues != null && this.markValues.length > 0) {
                ((DefaultValueDataset)this.dataset).setValue((Number)this.markValues[0]);
            } else {
                throw new HybsSystemException("markValues \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
        }
    }

    public void makeDataset(DBTableModel dBTableModel) {
        this.dataset = ChartFactory.newDataset(dBTableModel, this.chartType, this.seriesLabels, this.useCategoryColor);
        if (this.dataset instanceof DefaultValueDataset) {
            if (this.markValues != null && this.markValues.length > 0) {
                ((DefaultValueDataset)this.dataset).setValue((Number)this.markValues[0]);
            } else {
                throw new HybsSystemException("markValues \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
        }
    }

    protected NumberAxis makeNumberAxis() {
        Range range;
        double d;
        HybsNumberAxis hybsNumberAxis = new HybsNumberAxis(this.valueLabel);
        if (this.lowerBound != null) {
            d = Double.parseDouble(this.lowerBound);
            hybsNumberAxis.setLowerBound(d);
        }
        if (this.upperBound != null) {
            hybsNumberAxis.setUpperBound(Double.parseDouble(this.upperBound));
        } else if (this.dataset instanceof HybsCategoryDataset && (range = ((HybsCategoryDataset)this.dataset).getRange()) != null) {
            double d2 = range.getUpperBound() * 1.1;
            hybsNumberAxis.setUpperBound(d2);
        }
        if (this.tickSize != null) {
            hybsNumberAxis.setTickUnit(new NumberTickUnit(Double.parseDouble(this.tickSize)));
        }
        hybsNumberAxis.setTickLabelsVisible(this.isLabelsVisible);
        hybsNumberAxis.setTickMarksVisible(this.isMarksVisible);
        hybsNumberAxis.setAxisLineVisible(this.isMarksVisible);
        if (this.valueInset != null) {
            d = Double.parseDouble(this.valueInset);
            RectangleInsets rectangleInsets = hybsNumberAxis.getTickLabelInsets();
            RectangleInsets rectangleInsets2 = new RectangleInsets(rectangleInsets.getUnitType(), rectangleInsets.getTop(), rectangleInsets.getLeft(), rectangleInsets.getBottom(), rectangleInsets.getRight() + d);
            hybsNumberAxis.setTickLabelInsets(rectangleInsets2);
        }
        if (this.timeFormatType != null) {
            hybsNumberAxis.setNumberFormatOverride(new HybsTimeFormat(this.timeFormatType));
        }
        if (this.useVerticalLabels) {
            hybsNumberAxis.setVerticalTickLabels(true);
        }
        return hybsNumberAxis;
    }

    public String getQuery() {
        return this.query;
    }

    protected Dataset getDataset() {
        return this.dataset;
    }

    public void setChartType(String string) {
        if (string != null && string.length() > 0) {
            this.chartType = string;
        }
    }

    public void setNeedleType(String string) {
        if (string != null && string.length() > 0) {
            this.needleType = string;
        }
    }

    protected String getChartType() {
        return this.chartType;
    }

    public void setBaseLegend(boolean bl) {
        this.baseLegend = bl;
    }

    protected CategoryItemRenderer getRenderer(int n, CategoryURLGenerator categoryURLGenerator) {
        ShapeList shapeList;
        Object object;
        TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(this.chartType);
        CategoryItemRenderer categoryItemRenderer = (CategoryItemRenderer)typeRenderer.getRenderer();
        if (categoryItemRenderer instanceof LineAndShapeRenderer) {
            object = (LineAndShapeRenderer)categoryItemRenderer;
            object.setBaseShapesVisible(this.shapesVisible);
            if (n >= 0) {
                object.setSeriesShapesVisible(n, true);
            }
            shapeList = new ShapeList();
            for (int i = 0; i < shapeList.size(); ++i) {
                object.setSeriesShape(i, shapeList.getShape(i));
            }
        }
        if (categoryItemRenderer instanceof HybsLineRenderer) {
            object = (HybsLineRenderer)categoryItemRenderer;
            if (this.shapeColors != null) {
                ((HybsLineRenderer)object).setShapeColors(this.shapeColors);
            }
            ((HybsLineRenderer)object).setShapeScale(this.shapeScale);
            if (this.markOverColors != null) {
                ((HybsLineRenderer)object).setValueMarkOverColors(this.getValueMarkOverColors(), this.dynamicOCNo);
            }
            if (this.visibleLimit != null) {
                ((HybsLineRenderer)object).setVisibleLimit(Double.valueOf(this.visibleLimit));
            }
        }
        if (categoryItemRenderer instanceof BarRenderer) {
            object = (BarRenderer)categoryItemRenderer;
            if (this.itemMargin != null) {
                double d = Double.parseDouble(this.itemMargin);
                object.setItemMargin(d);
            }
            if (this.maxBarWidth != null) {
                object.setMaximumBarWidth(Double.parseDouble(this.maxBarWidth));
            }
        }
        if (categoryItemRenderer instanceof HybsStackedBarRenderer) {
            object = (HybsStackedBarRenderer)categoryItemRenderer;
            ((HybsStackedBarRenderer)((Object)object)).setDomainMargin(this.domainMargin);
        }
        categoryItemRenderer.setBaseSeriesVisibleInLegend(this.baseLegend);
        if (this.isItemValVisible) {
            object = NumberFormat.getInstance();
            ((NumberFormat)object).setGroupingUsed(this.useItemLabelSep);
            shapeList = new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)object);
            categoryItemRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)shapeList);
            if (n >= 0) {
                categoryItemRenderer.setSeriesItemLabelsVisible(n, true);
            } else {
                categoryItemRenderer.setBaseItemLabelsVisible(true);
            }
            if (this.dynamicOCNo >= 0) {
                categoryItemRenderer.setSeriesItemLabelsVisible(this.dynamicOCNo, false);
            }
            if (this.isItemLastVisible && categoryItemRenderer instanceof HybsDrawItem) {
                ((HybsDrawItem)categoryItemRenderer).setItemLabelLastVisible(true);
            }
            categoryItemRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER), false);
        }
        if (categoryURLGenerator != null) {
            if (n >= 0) {
                categoryItemRenderer.setSeriesItemURLGenerator(n, categoryURLGenerator);
            } else {
                categoryItemRenderer.setBaseItemURLGenerator(categoryURLGenerator);
            }
        }
        return categoryItemRenderer;
    }

    public void setValueLabel(String string) {
        if (string != null && string.length() > 0) {
            this.valueLabel = string;
        }
    }

    protected String getValueLabel() {
        return this.valueLabel;
    }

    public void setMarkValues(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.markValues = new double[n];
            for (int i = 0; i < n; ++i) {
                if ("G".equals(stringArray[i])) {
                    this.dynamicOCadrs = i;
                    this.markValues[i] = 0.0;
                    continue;
                }
                this.markValues[i] = Double.parseDouble(stringArray[i]);
            }
        }
    }

    public void setMarkColors(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.markColors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.markColors[i] = ColorMap.getColorInstance((String)stringArray[i]);
            }
        }
    }

    public void setUseMarkAnchor(boolean bl) {
        this.useMarkAnchor = bl;
    }

    public void setMarkOverColors(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.markOverColors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.markOverColors[i] = ColorMap.getColorInstance((String)stringArray[i]);
            }
        }
    }

    private ValueMarkOverColors getValueMarkOverColors() {
        ValueMarkOverColors valueMarkOverColors = null;
        if (this.markValues != null && this.markOverColors != null && this.markValues.length + 1 == this.markOverColors.length && this.markValues.length >= 1) {
            int n = this.dynamicOCadrs >= 0 ? this.dynamicOCadrs : 0;
            valueMarkOverColors = new ValueMarkOverColors(this.markValues, this.markOverColors, this.markColors[n], this.dynamicOCadrs);
        }
        return valueMarkOverColors;
    }

    public void setDynamicOCNo(int n) {
        this.dynamicOCNo = n;
    }

    protected ValueMarker[] getValueMarkers() {
        ArrayList<ValueMarker> arrayList = new ArrayList<ValueMarker>();
        int n = this.markValues == null ? 0 : this.markValues.length;
        for (int i = 0; i < n; ++i) {
            if (i == this.dynamicOCadrs) continue;
            ValueMarker valueMarker = new ValueMarker(this.markValues[i]);
            valueMarker.setPaint((Paint)this.markColors[i]);
            if (this.useMarkAnchor) {
                valueMarker.setLabel(String.valueOf(this.markValues[i]));
                valueMarker.setLabelTextAnchor(TextAnchor.BASELINE_LEFT);
            }
            arrayList.add(valueMarker);
        }
        return arrayList.toArray(new ValueMarker[arrayList.size()]);
    }

    public void setLowerBound(String string) {
        if (string != null && string.length() > 0) {
            this.lowerBound = string;
        }
    }

    public void setUpperBound(String string) {
        if (string != null && string.length() > 0) {
            this.upperBound = string;
        }
    }

    public void setTickSize(String string) {
        if (string != null && string.length() > 0) {
            this.tickSize = string;
        }
    }

    public void setUseGradient(boolean bl) {
        this.useGradient = bl;
    }

    protected boolean isUseGradient() {
        return this.useGradient;
    }

    public void setShapesVisible(boolean bl) {
        this.shapesVisible = bl;
    }

    protected boolean isShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapeColors(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.shapeColors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.shapeColors[i] = ColorMap.getColorInstance((String)stringArray[i]);
            }
        }
    }

    public void setShapeScale(String string) {
        this.shapeScale = string;
    }

    public void setUseDottedLine(boolean bl) {
        this.useDottedLine = bl;
    }

    protected boolean isUseDottedLine() {
        return this.useDottedLine;
    }

    public void setSeriesColors(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.seriesColors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.seriesColors[i] = ColorMap.getColorInstance((String)stringArray[i]);
            }
        }
    }

    protected Color[] getSeriesColors() {
        return this.seriesColors;
    }

    public void setSeriesLabels(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.seriesLabels = (String[])stringArray.clone();
        }
    }

    public void setValueLabelsVisible(boolean bl) {
        this.isLabelsVisible = bl;
    }

    public void setValueMarksVisible(boolean bl) {
        this.isMarksVisible = bl;
    }

    public void setItemLabelVisible(String string) {
        if ("true".equalsIgnoreCase(string)) {
            this.isItemValVisible = true;
        } else if ("last".equalsIgnoreCase(string)) {
            this.isItemValVisible = true;
            this.isItemLastVisible = true;
        } else if (string != null && !"false".equalsIgnoreCase(string)) {
            String string2 = "itemLabelVisible \u306f\u3001\u300ctrue,false,last\u300d\u304b\u3089\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002[" + string + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setUseItemLabelSep(boolean bl) {
        this.useItemLabelSep = bl;
    }

    public void setValueInset(String string) {
        this.valueInset = string;
    }

    public void setBarWidth(String string) {
        this.barWidth = string;
    }

    protected String getBarWidth() {
        return this.barWidth;
    }

    public void setBarMaxWidth(String string) {
        this.maxBarWidth = string;
    }

    public void setBarItemMargin(String string) {
        this.itemMargin = string;
    }

    public void setVisibleLimit(String string) {
        this.visibleLimit = string;
    }

    public void setDomainMargin(double d) {
        this.domainMargin = d;
    }

    public void setTimeFormatType(String string) {
        this.timeFormatType = string;
    }

    public void setUseVerticalLabels(boolean bl) {
        this.useVerticalLabels = bl;
    }

    public void setUseCategoryColor(boolean bl) {
        this.useCategoryColor = bl;
    }

    protected Plot makeMeterPlot() {
        BasicStroke basicStroke;
        MeterPlot meterPlot = new MeterPlot();
        double d = this.lowerBound == null ? 0.0 : Double.parseDouble(this.lowerBound);
        double d2 = this.upperBound == null ? 100.0 : Double.parseDouble(this.upperBound);
        meterPlot.setRange(new Range(d, d2));
        if (this.markValues != null && this.markValues.length > 1) {
            int n = this.markValues.length;
            if (this.markOverColors != null && n == this.markOverColors.length) {
                basicStroke = new BasicStroke(2.0f);
                String[] stringArray = StringUtil.csv2Array((String)this.valueLabel);
                int n2 = stringArray.length;
                int n3 = 0;
                double d3 = d;
                for (int i = 1; i <= n; ++i) {
                    double d4 = i < n ? this.markValues[i] : d2;
                    Color color = this.markOverColors[i - 1];
                    Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
                    String string = n3 < n2 ? stringArray[n3++] : "";
                    meterPlot.addInterval(new MeterInterval(string, new Range(d3, d4), (Paint)color, (Stroke)basicStroke, (Paint)color2));
                    d3 = d4;
                }
            } else {
                String string = "Meter \u3067\u3001markValues \u3092\u8907\u6570\u6307\u5b9a\u3059\u308b\u5834\u5408\u306f\u3001\u540c\u3058\u6570\u306emarkOverColors\u306e\u6307\u5b9a\u304c\u5fc5\u8981\u3067\u3059\u3002" + HybsConst.CR;
                throw new HybsSystemException(string);
            }
        }
        if (this.tickSize != null) {
            meterPlot.setTickSize(Double.parseDouble(this.tickSize));
        }
        Color[] colorArray = new Color[]{Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, new Color(255, 255, 255, 0), Color.BLACK};
        if (this.shapeColors != null && this.shapeColors.length > 0) {
            System.arraycopy(this.shapeColors, 0, colorArray, 0, this.shapeColors.length);
        }
        meterPlot.setNeedlePaint((Paint)colorArray[0]);
        meterPlot.setValuePaint((Paint)colorArray[1]);
        meterPlot.setTickPaint((Paint)colorArray[2]);
        meterPlot.setTickLabelPaint((Paint)colorArray[3]);
        meterPlot.setDialBackgroundPaint((Paint)colorArray[4]);
        meterPlot.setDialOutlinePaint((Paint)colorArray[5]);
        basicStroke = DialShape.CIRCLE;
        if (this.needleType != null) {
            if ("CHORD".equalsIgnoreCase(this.needleType)) {
                basicStroke = DialShape.CHORD;
            } else if ("CIRCLE".equalsIgnoreCase(this.needleType)) {
                basicStroke = DialShape.CIRCLE;
            } else if ("PIE".equalsIgnoreCase(this.needleType)) {
                basicStroke = DialShape.PIE;
            }
        }
        meterPlot.setDialShape((DialShape)basicStroke);
        if (this.shapeScale != null) {
            meterPlot.setMeterAngle(Integer.parseInt(this.shapeScale));
        }
        meterPlot.setTickLabelsVisible(this.isLabelsVisible);
        meterPlot.setDataset((ValueDataset)this.dataset);
        return meterPlot;
    }

    protected Plot makeThermometerPlot() {
        ThermometerPlot thermometerPlot = new ThermometerPlot();
        double d = this.lowerBound == null ? 0.0 : Double.parseDouble(this.lowerBound);
        double d2 = this.upperBound == null ? 100.0 : Double.parseDouble(this.upperBound);
        thermometerPlot.setRange(d, d2);
        if (this.markValues != null && this.markValues.length > 1) {
            boolean bl;
            int n = this.markValues.length;
            boolean bl2 = bl = this.markOverColors != null && n == this.markOverColors.length;
            if (bl || this.markOverColors == null || this.markOverColors.length == 0) {
                double d3 = d;
                for (int i = 1; i <= n; ++i) {
                    double d4 = i < n ? this.markValues[i] : d2;
                    thermometerPlot.setSubrange(i - 1, d3, d4);
                    if (bl) {
                        Color color = this.markOverColors[i - 1];
                        thermometerPlot.setSubrangePaint(i - 1, (Paint)color);
                    }
                    d3 = d4;
                }
            } else {
                String string = "Meter \u3067\u3001markValues \u3092\u8907\u6570\u6307\u5b9a\u3059\u308b\u5834\u5408\u306f\u3001\u540c\u3058\u6570\u306emarkOverColors\u306e\u6307\u5b9a\u304c\u5fc5\u8981\u3067\u3059\u3002" + HybsConst.CR;
                throw new HybsSystemException(string);
            }
        }
        Color[] colorArray = new Color[]{Color.BLACK, Color.BLACK, Color.GRAY};
        if (this.shapeColors != null && this.shapeColors.length > 0) {
            System.arraycopy(this.shapeColors, 0, colorArray, 0, this.shapeColors.length);
        }
        thermometerPlot.setValuePaint((Paint)colorArray[0]);
        thermometerPlot.setThermometerPaint((Paint)colorArray[1]);
        thermometerPlot.setMercuryPaint((Paint)colorArray[2]);
        thermometerPlot.setDataset((ValueDataset)this.dataset);
        return thermometerPlot;
    }

    protected Plot makeCompassPlot() {
        CompassPlot compassPlot = new CompassPlot();
        int n = 5;
        if (this.needleType != null) {
            if ("Arrow".equalsIgnoreCase(this.needleType)) {
                n = 0;
            } else if ("Line".equalsIgnoreCase(this.needleType)) {
                n = 1;
            } else if ("Long".equalsIgnoreCase(this.needleType)) {
                n = 2;
            } else if ("Pin".equalsIgnoreCase(this.needleType)) {
                n = 3;
            } else if ("Plum".equalsIgnoreCase(this.needleType)) {
                n = 4;
            } else if ("Pointer".equalsIgnoreCase(this.needleType)) {
                n = 5;
            } else if ("Ship".equalsIgnoreCase(this.needleType)) {
                n = 6;
            } else if ("Wind".equalsIgnoreCase(this.needleType)) {
                n = 7;
            } else if ("Arrow".equalsIgnoreCase(this.needleType)) {
                n = 8;
            } else if ("MiddlePin".equalsIgnoreCase(this.needleType)) {
                n = 9;
            }
        }
        compassPlot.setSeriesNeedle(0, n);
        Color[] colorArray = new Color[]{Color.RED, Color.BLACK, Color.WHITE, Color.BLACK, Color.YELLOW};
        if (this.shapeColors != null && this.shapeColors.length > 0) {
            System.arraycopy(this.shapeColors, 0, colorArray, 0, this.shapeColors.length);
        }
        compassPlot.setSeriesPaint(0, (Paint)colorArray[0]);
        compassPlot.setSeriesOutlinePaint(0, (Paint)colorArray[1]);
        compassPlot.setRoseCenterPaint((Paint)colorArray[2]);
        compassPlot.setRoseHighlightPaint((Paint)colorArray[3]);
        compassPlot.setRosePaint((Paint)colorArray[4]);
        compassPlot.addDataset((ValueDataset)this.dataset);
        return compassPlot;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append('[').append(this.getClass().getName()).append(']').append(HybsConst.CR).append("chartType     [").append(this.chartType).append(']').append(HybsConst.CR).append("valueLabel    [").append(this.valueLabel).append(']').append(HybsConst.CR).append("markValues    [").append(Arrays.toString(this.markValues)).append(']').append(HybsConst.CR).append("markColors    [").append(Arrays.toString(this.markColors)).append(']').append(HybsConst.CR).append("lowerBound    [").append(this.lowerBound).append(']').append(HybsConst.CR).append("upperBound    [").append(this.upperBound).append(']').append(HybsConst.CR).append("useGradient   [").append(this.useGradient).append(']').append(HybsConst.CR).append("shapesVisible [").append(this.shapesVisible).append(']').append(HybsConst.CR).append("useDottedLine [").append(this.useDottedLine).append(']').append(HybsConst.CR);
        return stringBuilder.toString();
    }

    private static final class HybsTimeFormat
    extends DecimalFormat {
        private static final long serialVersionUID = 201205075512L;
        private final boolean is24repeat;
        private final boolean useDay;
        private final int hsCode;

        public HybsTimeFormat(String string) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            if ("E1".equals(string)) {
                this.applyPattern("#0.00");
                decimalFormatSymbols.setDecimalSeparator(':');
                this.is24repeat = false;
                this.useDay = false;
            } else if ("E2".equals(string)) {
                this.applyPattern("#0.00");
                decimalFormatSymbols.setDecimalSeparator(':');
                this.is24repeat = true;
                this.useDay = false;
            } else if ("E3".equals(string)) {
                this.applyPattern("#,#0.00");
                decimalFormatSymbols.setDecimalSeparator(':');
                decimalFormatSymbols.setGroupingSeparator(' ');
                this.is24repeat = true;
                this.useDay = true;
            } else if ("H1".equals(string)) {
                this.applyPattern("#0.00\u5206");
                decimalFormatSymbols.setDecimalSeparator('\u6642');
                this.is24repeat = false;
                this.useDay = false;
            } else if ("H2".equals(string)) {
                this.applyPattern("#0.00\u5206");
                decimalFormatSymbols.setDecimalSeparator('\u6642');
                this.is24repeat = true;
                this.useDay = false;
            } else if ("H3".equals(string)) {
                this.applyPattern("#,#0.00\u5206");
                decimalFormatSymbols.setDecimalSeparator('\u6642');
                decimalFormatSymbols.setGroupingSeparator('\u65e5');
                this.is24repeat = true;
                this.useDay = true;
            } else {
                String string2 = "timeFormatType \u306f\u3001(E1/E2/E3/H1/H2/H3) \u304b\u3089\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002timeFormatType=[" + string + "]";
                throw new HybsSystemException(string2);
            }
            this.setDecimalFormatSymbols(decimalFormatSymbols);
            this.hsCode = super.hashCode() + Boolean.valueOf(this.is24repeat).hashCode() + Boolean.valueOf(this.useDay).hashCode();
        }

        @Override
        public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            int n = (int)(d / 100.0);
            if (this.is24repeat) {
                n %= 24;
            }
            int n2 = (int)(d % 100.0 * 0.6);
            double d2 = (double)n + (double)n2 / 100.0;
            if (this.useDay) {
                d2 += (double)((int)(d / 24.0));
            }
            return super.format(d2, stringBuffer, fieldPosition);
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        public int hashCode() {
            return this.hsCode;
        }
    }
}

