/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.report.DBTableReport;
import org.opengion.hayabusa.resource.ResourceManager;

public abstract class AbstractDBTableReport
implements DBTableReport {
    private static final String ENCODE = "UTF-8";
    private static final String PAGEBREAK = "PAGEBREAK";
    protected String[] headerKeys;
    protected String[] headerVals;
    protected String[] footerKeys;
    protected String[] footerVals;
    protected boolean pageEndCut;
    protected int maxRowCount;
    protected int pageRowCount;
    protected int lineCopyCnt;
    protected ResourceManager resource;
    protected PrintWriter writer;
    protected BufferedReader reader;
    protected File templateFile;
    protected File firstTemplateFile;
    protected String htmlDir;
    protected String htmlFileKey;
    protected String ykno;
    protected DBTableModel table;
    protected int pageCount;
    protected int maxPageCount = 1000;
    protected boolean rowOver;
    protected boolean dataOver;
    protected String listId;
    private boolean formatErr;
    private int pbClmNo = -1;
    private boolean pageBreak;
    private int tableSize;

    @Override
    public void writeReport() {
        String string;
        this.setHeaderFooter();
        this.initReader();
        this.initWriter();
        while ((string = this.readLine()) != null) {
            this.println(this.changeData(string));
        }
        this.close();
    }

    protected abstract String readLine();

    protected abstract String changeData(String var1);

    protected abstract void println(String var1);

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    @Override
    public void setListId(String string) {
        this.listId = string;
    }

    @Override
    public void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
        this.tableSize = dBTableModel.getRowCount();
        this.pbClmNo = dBTableModel.getColumnNo(PAGEBREAK, false);
    }

    @Override
    public void setTemplateFile(File file) {
        this.templateFile = file;
    }

    @Override
    public void setFirstTemplateFile(File file) {
        this.firstTemplateFile = file;
    }

    @Override
    public void setOutputDir(String string) {
        this.htmlDir = string;
        File file = new File(this.htmlDir);
        if (!file.exists() && !file.mkdirs()) {
            String string2 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + this.htmlDir + "]";
            throw new HybsSystemException(string2);
        }
    }

    @Override
    public void setOutputFileKey(String string) {
        this.htmlFileKey = string;
    }

    @Override
    public void setYkno(String string) {
        this.ykno = string;
    }

    @Override
    public void setHeaderKeys(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.headerKeys = new String[n];
            System.arraycopy(stringArray, 0, this.headerKeys, 0, n);
        } else {
            this.headerKeys = null;
        }
    }

    @Override
    public void setHeaderVals(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.headerVals = new String[n];
            System.arraycopy(stringArray, 0, this.headerVals, 0, n);
        } else {
            this.headerVals = null;
        }
    }

    protected int getRealRow(int n) {
        int n2 = this.pageRowCount + n + this.lineCopyCnt;
        if (this.maxRowCount <= n2) {
            this.maxRowCount = n2 + 1;
        }
        if (n2 >= this.tableSize - 1) {
            this.rowOver = true;
            if (n2 >= this.tableSize) {
                n2 = -1;
                this.dataOver = true;
            }
        }
        return n2;
    }

    protected String getValue(String string) {
        if (this.pageBreak) {
            return "";
        }
        int n = string.lastIndexOf(95);
        if (n >= 0) {
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                int n3 = this.getRealRow(n2);
                if (n3 >= 0 && this.table != null) {
                    this.formatErr = false;
                    int n4 = this.table.getColumnNo(string.substring(0, n), false);
                    if (n4 < 0) {
                        if ("I".equals(string.substring(0, n))) {
                            return String.valueOf(n3 + 1);
                        }
                        String string2 = "\u30ab\u30e9\u30e0\u540d\u304c\u5b58\u5728\u3057\u307e\u305b\u3093:[" + string + "]";
                        System.out.println(string2);
                        LogWriter.log((String)string2);
                        return "";
                    }
                    String string3 = (String)this.table.getValue(n3, n4);
                    if (this.pbClmNo == n4) {
                        if (!this.rowOver) {
                            String string4 = (String)this.table.getValue(n3 + 1, this.pbClmNo);
                            if (string3 != null && !string3.equals(string4)) {
                                this.pageBreak = true;
                            }
                        }
                        return "";
                    }
                    string3 = StringUtil.htmlFilter((String)string3);
                    string3 = StringUtil.replace((String)string3, (String)"&lt;br&gt;", (String)"<br>");
                    string3 = StringUtil.replace((String)string3, (String)"&amp;#", (String)"&#");
                    return this.table.getDBColumn(n4).getWriteValue(string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = "\u8b66\u544a\uff1a\u30d8\u30c3\u30c0\u30fc\u306b'_'\u30ab\u30e9\u30e0\u540d\u304c\u4f7f\u7528  key=[" + string + "]  " + numberFormatException.getMessage();
                LogWriter.log((String)string5);
            }
            catch (RuntimeException runtimeException) {
                String string6 = "\u30ab\u30e9\u30e0\u30c7\u30fc\u30bf\u53d6\u5f97\u51e6\u7406\u3067\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002  key=[" + string + "]  " + runtimeException.getMessage();
                LogWriter.log((String)string6);
            }
        }
        if ("YKNO".equals(string)) {
            return this.ykno;
        }
        String string7 = this.rowOver ? this.getFooterValue(string) : this.getHeaderValue(string);
        if (string7 == null) {
            string7 = "";
        }
        return string7;
    }

    private String getHeaderValue(String string) {
        if (this.headerKeys == null || this.headerVals == null || string == null) {
            return null;
        }
        for (int i = 0; i < this.headerKeys.length; ++i) {
            if (!string.equals(this.headerKeys[i])) continue;
            return this.headerVals[i];
        }
        return null;
    }

    @Override
    public void setFooterKeys(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.footerKeys = new String[n];
            System.arraycopy(stringArray, 0, this.footerKeys, 0, n);
        } else {
            this.footerKeys = null;
        }
    }

    private String getFooterValue(String string) {
        if (this.footerKeys == null || this.footerVals == null || string == null) {
            return null;
        }
        for (int i = 0; i < this.footerKeys.length; ++i) {
            if (!string.equals(this.footerKeys[i])) continue;
            return this.footerVals[i];
        }
        return null;
    }

    @Override
    public void setFooterVals(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.footerVals = new String[n];
            System.arraycopy(stringArray, 0, this.footerVals, 0, n);
        } else {
            this.footerVals = null;
        }
    }

    @Override
    public void setPageEndCut(boolean bl) {
        this.pageEndCut = bl;
    }

    protected void initReader() {
        Closer.ioClose((Closeable)this.reader);
        if (this.reader == null && this.firstTemplateFile != null) {
            this.reader = FileUtil.getBufferedReader((File)this.firstTemplateFile, (String)ENCODE);
        } else {
            if (this.formatErr) {
                String string = "Error in HTML File. " + HybsConst.CR + "Excel containing two or more sheets is not supporting." + HybsConst.CR + "or HTML template File is not in '{@xxxx_0}' key word.";
                throw new HybsSystemException(string);
            }
            this.reader = FileUtil.getBufferedReader((File)this.templateFile, (String)ENCODE);
            this.formatErr = true;
        }
    }

    protected void initWriter() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
            ++this.pageCount;
            if (this.pageCount >= this.maxPageCount) {
                String string = "EXCEL\u306e\u30da\u30fc\u30b8(\u30b7\u30fc\u30c8)\u304c\u6700\u5927\u30da\u30fc\u30b8\u6570(1000)\u3092\u30aa\u30fc\u30d0\u30fc\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "\u3053\u306e\u6570\u306f\u3001DB_MAX_ROW_COUNT \u3067\u306f\u306a\u304f\u3001LISTID_999.html\u306e\u30aa\u30fc\u30d0\u30fc\u3092\u610f\u5473\u3057\u307e\u3059\u3002" + HybsConst.CR;
                throw new HybsSystemException(string);
            }
        }
        int n = this.pageCount + 1000;
        String string = String.valueOf(n).substring(1);
        String string2 = this.htmlFileKey + "_" + string + ".html";
        this.writer = FileUtil.getPrintWriter((File)new File(this.htmlDir, string2), (String)ENCODE);
        this.pageRowCount = this.maxRowCount;
        this.pageBreak = false;
    }

    protected void setHeaderFooter() {
        DBColumn dBColumn;
        int n;
        if (this.headerKeys != null && this.headerVals != null && this.resource != null) {
            for (n = 0; n < this.headerKeys.length; ++n) {
                dBColumn = this.resource.getDBColumn(this.headerKeys[n]);
                if (dBColumn == null) continue;
                this.headerVals[n] = dBColumn.getWriteValue(this.headerVals[n]);
            }
        }
        if (this.footerKeys != null && this.footerVals != null && this.resource != null) {
            for (n = 0; n < this.footerKeys.length; ++n) {
                dBColumn = this.resource.getDBColumn(this.footerKeys[n]);
                if (dBColumn == null) continue;
                this.footerVals[n] = dBColumn.getWriteValue(this.footerVals[n]);
            }
        }
    }

    private void close() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
        Closer.ioClose((Closeable)this.reader);
        this.reader = null;
    }
}

