/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.HashSet;
import java.util.Set;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.FileMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class HelpTag
extends CommonTagSupport {
    private static final String VERSION = "6.3.9.0 (2015/11/06)";
    private static final long serialVersionUID = 639020151106L;
    private static final String JSP = HybsSystem.sys("JSP");
    private static final String QUERY = "select KNRNGUI from GE80 where SYSTEM_ID = ? and FGJ='1' and KNRNGUI is not null";
    private static final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final FileMap helpMap = new FileMap();
    private static final Set<String> faqSet = new HashSet<String>();
    private String guiInfoKey;
    private String target = "_blank";
    private boolean viewMsg;
    private String iconURL = HybsSystem.sys("DEFAULT_HELP_ICON");
    private String faqIconURL = HybsSystem.sys("DEFAULT_FAQ_ICON");
    private String faqGUI = HybsSystem.sys("DEFAULT_FAQ_GUI");
    private boolean useFaq = HybsSystem.sysBool("USE_GUI_FAQ");
    private boolean useFaqCtrl = HybsSystem.sysBool("USE_GUI_FAQ_CTRL");

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!helpMap.isInit()) {
            String string = HybsSystem.sys("HELP_URL");
            helpMap.init(HybsSystem.url2dir(string), string);
            this.loadGE80();
        }
        this.jspPrint(this.makeHelpTag());
        if (this.useFaq) {
            this.jspPrint(this.makeTagFaq());
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.guiInfoKey = null;
        this.target = "_blank";
        this.viewMsg = false;
        this.iconURL = HybsSystem.sys("DEFAULT_HELP_ICON");
        this.faqIconURL = HybsSystem.sys("DEFAULT_FAQ_ICON");
        this.faqGUI = HybsSystem.sys("DEFAULT_FAQ_GUI");
        this.useFaq = HybsSystem.sysBool("USE_GUI_FAQ");
        this.useFaqCtrl = HybsSystem.sysBool("USE_GUI_FAQ_CTRL");
    }

    private String makeHelpTag() {
        String string;
        String string2 = "";
        if (this.guiInfoKey == null) {
            this.guiInfoKey = this.getGUIInfoAttri("KEY");
        }
        if ((string = helpMap.getFilename(new String[]{this.guiInfoKey})) != null) {
            string2 = this.getLink(string);
        } else if (this.viewMsg) {
            string2 = this.getLinkBody(null, this.getMsglbl());
        }
        return string2;
    }

    private String makeTagFaq() {
        String string = "";
        if (this.guiInfoKey == null) {
            this.guiInfoKey = this.getGUIInfoAttri("KEY");
        }
        if (!this.useFaqCtrl || faqSet.contains(this.guiInfoKey)) {
            GUIInfo gUIInfo = this.getGUIInfo(this.faqGUI);
            if (gUIInfo == null) {
                return string;
            }
            String string2 = gUIInfo.getRealAddress(this.get("href"));
            String string3 = string2 + "index.jsp?command=NEW&GAMENID=" + this.faqGUI + "&KNRNGUI=%25" + this.guiInfoKey + "%25";
            string = this.getFAQLink(string3);
        }
        return string;
    }

    private String getLink(String string) {
        return XHTMLTag.link((Attributes)new Attributes().set("href", this.getContextPath() + "/" + string).set("body", this.getLinkBody(this.iconURL, this.getMsglbl())).set("target", this.target).set("class", "helplink"));
    }

    private String getFAQLink(String string) {
        return XHTMLTag.link((Attributes)new Attributes().set("href", string).set("body", this.getLinkBody(this.faqIconURL, "FAQ")).set("target", this.target).set("class", "faqlink"));
    }

    private String getLinkBody(String string, String string2) {
        return string == null || string.isEmpty() ? this.getMsglbl() : "<img src=\"" + JSP + string + "\" title=\"" + StringUtil.htmlFilter((String)string2, (boolean)true) + "\"/>";
    }

    public void setGuiInfoKey(String string) {
        this.guiInfoKey = this.getRequestParameter(string);
    }

    public void setExtension(String string) {
    }

    public void setTarget(String string) {
        this.target = StringUtil.nval((String)this.getRequestParameter(string), (String)this.target);
    }

    public void setViewMsg(String string) {
        this.viewMsg = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.viewMsg);
    }

    public void setIconURL(String string) {
        this.iconURL = StringUtil.nval((String)this.getRequestParameter(string), (String)this.iconURL);
    }

    public void setFaqIconURL(String string) {
        this.faqIconURL = StringUtil.nval((String)this.getRequestParameter(string), (String)this.faqIconURL);
    }

    public void setUseFaq(String string) {
        this.useFaq = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useFaq);
    }

    public void setUseFaqCtrl(String string) {
        this.useFaqCtrl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useFaqCtrl);
    }

    private void loadGE80() {
        String[] stringArray = new String[]{HybsSystem.sys("SYSTEM_ID")};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.getApplicationInfo(), (String)DBID);
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3 = stringArray2[i][0].split("[ ,]");
            for (int j = 0; j < stringArray3.length; ++j) {
                faqSet.add(stringArray3[j]);
            }
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("guiInfoKey", (Object)this.guiInfoKey).println("target", (Object)this.target).println("viewMsg", (Object)this.viewMsg).println("iconURL", (Object)this.iconURL).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                helpMap.clear();
                faqSet.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

