/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.text.MessageFormat;
import java.util.List;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.resource.LDAPSearch;
import org.opengion.hayabusa.resource.UserInfo;

public final class UserInfoFactory {
    private static final String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
    private static String dbid = StringUtil.nval((String)HybsSystem.sys("RESOURCE_USER_DBID"), (String)HybsSystem.sys("RESOURCE_DBID"));
    private static String query = HybsSystem.sys("RESOURCE_USER_SQL");
    private static String queryRole = HybsSystem.sys("RESOURCE_USER_ROLE_SQL");
    private static String srcType = HybsSystem.sys("RESOURCE_USER_SRC_TYPE");
    private static String[] ldapClm = StringUtil.csv2Array((String)HybsSystem.sys("RESOURCE_USER_LDAP_CLM"));
    private static String ldapFilter = HybsSystem.sys("RESOURCE_USER_LDAP_FILTER");
    private static String ldapRoleFilter = HybsSystem.sys("RESOURCE_USER_ROLE_LDAP_FILTER");
    private static String searchScope = HybsSystem.sys("LDAP_SEARCH_SCOPE");
    private static String initctx = HybsSystem.sys("LDAP_INITIAL_CONTEXT_FACTORY");
    private static String providerURL = HybsSystem.sys("LDAP_PROVIDER_URL");
    private static String entrydn = HybsSystem.sys("LDAP_ENTRYDN");
    private static String password = HybsSystem.sys("LDAP_PASSWORD");
    private static String searchbase = HybsSystem.sys("LDAP_SEARCH_BASE");
    private static final Object LOCK = new Object();
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");

    private UserInfoFactory() {
    }

    public static UserInfo newInstance(String string, String string2, String string3) {
        String[][] stringArray;
        int n;
        ApplicationInfo applicationInfo = null;
        if (USE_DB_APPLICATION_INFO) {
            applicationInfo = new ApplicationInfo();
            applicationInfo.setClientInfo(string, string2, null);
            applicationInfo.setModuleInfo("UserInfoFactory", null, "newInstance");
        }
        if ((n = (stringArray = "LDAP".equalsIgnoreCase(srcType) ? UserInfoFactory.getValsByLdap(string, string3) : UserInfoFactory.getVals(string, string3, applicationInfo)).length) < 1 || stringArray[0].length < 5) {
            String string4 = "UserInfo \u306e\u30c7\u30fc\u30bf(USERID,LANG,NAME,ROLES,DROLES)\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002 Key [" + string + "]" + " SQL [" + query + "]";
            LogWriter.log((String)string4);
            throw new HybsSystemException(string4);
        }
        UserInfo userInfo = new UserInfo(string, stringArray[n - 1][1], stringArray[n - 1][2], stringArray[n - 1][3], stringArray[n - 1][4], SYSTEM_ID, string2, applicationInfo);
        return userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = LOCK;
        synchronized (object) {
            dbid = StringUtil.nval((String)HybsSystem.sys("RESOURCE_USER_DBID"), (String)HybsSystem.sys("RESOURCE_DBID"));
            query = HybsSystem.sys("RESOURCE_USER_SQL");
            queryRole = HybsSystem.sys("RESOURCE_USER_ROLE_SQL");
            srcType = HybsSystem.sys("RESOURCE_USER_SRC_TYPE");
            ldapClm = StringUtil.csv2Array((String)HybsSystem.sys("RESOURCE_USER_LDAP_CLM"));
            ldapFilter = HybsSystem.sys("RESOURCE_USER_LDAP_FILTER");
            ldapRoleFilter = HybsSystem.sys("RESOURCE_USER_ROLE_LDAP_FILTER");
            searchScope = HybsSystem.sys("LDAP_SEARCH_SCOPE");
            initctx = HybsSystem.sys("LDAP_INITIAL_CONTEXT_FACTORY");
            providerURL = HybsSystem.sys("LDAP_PROVIDER_URL");
            entrydn = HybsSystem.sys("LDAP_ENTRYDN");
            password = HybsSystem.sys("LDAP_PASSWORD");
            searchbase = HybsSystem.sys("LDAP_SEARCH_BASE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[][] getVals(String string, String string2, ApplicationInfo applicationInfo) {
        String[][] stringArray;
        if (string2 == null || string2.isEmpty()) {
            String[] stringArray2 = new String[]{SYSTEM_ID, string};
            Object object = LOCK;
            synchronized (object) {
                stringArray = DBUtil.dbExecute((String)query, (String[])stringArray2, (ApplicationInfo)applicationInfo, (String)dbid);
            }
        }
        String[] stringArray3 = new String[]{SYSTEM_ID, string, string2};
        Object object = LOCK;
        synchronized (object) {
            stringArray = DBUtil.dbExecute((String)queryRole, (String[])stringArray3, (ApplicationInfo)applicationInfo, (String)dbid);
        }
        return stringArray;
    }

    private static String[][] getValsByLdap(String string, String string2) {
        String[] stringArray;
        String string3;
        LDAPSearch lDAPSearch = new LDAPSearch();
        lDAPSearch.setSearchScope(searchScope);
        lDAPSearch.setInitctx(initctx);
        lDAPSearch.setProviderURL(providerURL);
        lDAPSearch.setSearchbase(searchbase);
        if (entrydn != null) {
            lDAPSearch.setEntrydn(entrydn);
        }
        if (password != null) {
            lDAPSearch.setPassword(password);
        }
        lDAPSearch.setAttributes(ldapClm);
        lDAPSearch.init();
        String string4 = string3 = string2 == null || string2.isEmpty() ? ldapFilter : ldapRoleFilter;
        if (string2 == null || string2.isEmpty()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = SYSTEM_ID;
            stringArray = stringArray2;
            stringArray2[1] = string;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = SYSTEM_ID;
            stringArray3[1] = string;
            stringArray = stringArray3;
            stringArray3[2] = string2;
        }
        String[] stringArray4 = stringArray;
        string3 = MessageFormat.format(string3, stringArray4);
        List<String[]> list = lDAPSearch.search(string3);
        String[][] stringArray5 = null;
        if (!list.isEmpty()) {
            stringArray5 = new String[][]{list.get(0)};
            stringArray5[0][1] = StringUtil.nval((String)stringArray5[0][1], (String)"ja");
            stringArray5[0][2] = StringUtil.nval((String)stringArray5[0][2], (String)stringArray5[0][0]);
            stringArray5[0][3] = StringUtil.nval((String)stringArray5[0][3], (String)ldapClm[3]);
            stringArray5[0][4] = StringUtil.nval((String)stringArray5[0][4], (String)"");
        }
        return stringArray5;
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                UserInfoFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

