/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.QueryTag;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class TableUpdateTag
extends QueryTag {
    private static final String VERSION = "6.4.2.0 (2016/01/29)";
    private static final long serialVersionUID = 642020160129L;
    public static final String CMD_ENTRY = "ENTRY";
    private static final String[] COMMAND_LIST = new String[]{"ENTRY"};
    private String sqlType;
    private String resourceType;
    private int resTypeColNo = -1;
    private String conditionKey;
    private String conditionList;
    private boolean selectedAll;
    private boolean commitTableModel = true;
    private boolean followCdkh;
    private boolean quotCheck;

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        this.dyStart = System.currentTimeMillis();
        this.table = (DBTableModel)this.getObject(this.tableId);
        this.startQueryTransaction(this.tableId);
        if (this.table == null || this.table.getRowCount() == 0 || !this.check(this.command, COMMAND_LIST)) {
            return 0;
        }
        ((QueryTag)this).quotCheck = this.quotCheck;
        return 2;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        String string = "";
        if (this.check(this.command, COMMAND_LIST)) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder(200);
            if (this.executeCount > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                stringBuilder.append(this.executeCount);
                stringBuilder.append(this.getResource().getLabel(this.displayMsg));
                stringBuilder.append(BR);
            }
            if ((string2 = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource())) != null && string2.length() > 0) {
                stringBuilder.append(string2);
                this.setSessionAttribute("h_errMsg", this.errMessage);
            } else {
                this.removeSessionAttribute("h_errMsg");
            }
            string = stringBuilder.toString();
            if (this.table != null && !this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("TableUpdateTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        this.jspPrint(string);
        long l = System.currentTimeMillis() - this.dyStart;
        GUIInfo gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (gUIInfo != null) {
            gUIInfo.addWriteCount(this.executeCount, l, this.sql);
        }
        if (this.useTimeView) {
            this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        }
        return this.errCode >= 2 ? 5 : 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.sqlType = null;
        this.resourceType = null;
        this.resTypeColNo = -1;
        this.conditionKey = null;
        this.conditionList = null;
        this.selectedAll = false;
        this.commitTableModel = true;
        this.followCdkh = false;
        this.quotCheck = false;
    }

    @Override
    protected void execute(Query query) {
        int[] nArray = this.getParameterRows();
        if (nArray.length > 0) {
            query.execute(nArray, this.table);
            this.errCode = query.getErrorCode();
            this.errMessage = query.getErrorMessage();
            if (this.resourceType != null) {
                this.resTypeColNo = this.table.getColumnNo("CLM");
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                if (this.resTypeColNo >= 0) {
                    this.clearResourceData((String)this.table.getValue(n, this.resTypeColNo));
                }
                if (!this.commitTableModel) continue;
                if ("D".equals(this.table.getModifyType(n))) {
                    this.table.removeValue(n);
                    continue;
                }
                this.table.resetModify(n);
            }
        }
    }

    @Override
    protected int[] getParameterRows() {
        int n;
        int n2;
        int[] nArray;
        int n3;
        if (this.selectedAll) {
            n3 = this.table.getRowCount();
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = n2;
            }
        } else {
            nArray = super.getParameterRows();
        }
        if (this.conditionKey != null) {
            n3 = this.table.getColumnNo(this.conditionKey);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < nArray.length; ++n) {
                String string = "|" + (String)this.table.getValue(nArray[n], n3) + "|";
                if (this.conditionList.indexOf(string) < 0) continue;
                arrayList.add(nArray[n]);
            }
            n = arrayList.size();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
        }
        if (this.sqlType != null && this.sqlType.length() > 0 && this.followCdkh) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                String string = this.table.getModifyType(nArray[n2]);
                if ((!"INSERT".equals(this.sqlType) && !"COPY".equals(this.sqlType) || !"A".equals(string)) && (!"UPDATE".equals(this.sqlType) && !"CHANGE".equals(this.sqlType) || !"C".equals(string)) && (!"DELETE".equals(this.sqlType) || !"D".equals(string))) continue;
                arrayList.add(nArray[n2]);
            }
            n2 = arrayList.size();
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    @Override
    public void setQueryType(String string) {
        super.setQueryType(StringUtil.nval((String)string, (String)"JDBCTableUpdate"));
    }

    private void clearResourceData(String string) {
        this.getResource().clear(string);
    }

    public void setResourceType(String string) {
        this.resourceType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.resourceType);
        if (this.resourceType != null && "|GEA03|GEA04|GEA08|".indexOf("|" + this.resourceType + "|") < 0) {
            String string2 = "resourceType\u306f GEA03,GEA04,GEA08 \u306e\u3069\u308c\u304b\u3067\u3059\u3002resourceType=" + string;
            throw new HybsSystemException(string2);
        }
    }

    public void setConditionKey(String string) {
        this.conditionKey = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setConditionList(String string) {
        this.conditionList = "|" + StringUtil.nval((String)this.getRequestParameter(string), (String)"") + "|";
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setCommitTableModel(String string) {
        this.commitTableModel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.commitTableModel);
    }

    protected String[] getNames() {
        return this.table.getNames();
    }

    public void setSqlType(String string) {
        this.sqlType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sqlType);
    }

    public void setFollowCdkh(String string) {
        this.followCdkh = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.followCdkh);
    }

    @Override
    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    protected String getSqlType() {
        return this.sqlType;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("resourceType", (Object)this.resourceType).println("resTypeColNo", (Object)this.resTypeColNo).println("conditionKey", (Object)this.conditionKey).println("conditionList", (Object)this.conditionList).println("followCdkh", (Object)this.followCdkh).println("CMD_ENTRY", (Object)CMD_ENTRY).println("commitTabelModel", (Object)this.commitTableModel).println("sql", (Object)this.sql).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString() + CR + super.toString();
    }
}

