/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.util.Arrays;
import java.util.Locale;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.system.OgRuntimeException;

public enum DBFunctionName {
    ORACLE("||", "SUBSTR", "SYSDATE"),
    HSQL("||", "SUBSTR", "CURRENT_TIMESTAMP"),
    POSTGRES("||", "SUBSTR", "CURRENT_DATE"),
    MYSQL("||", "SUBSTR", "now()"),
    SQLSERVER("+", "SUBSTRING", "GETDATE()"),
    FIREBIRD("||", "SUBSTR", "CURRENT_DATE"),
    CACHE("||", "SUBSTRING", "SYSDATE");

    private final String dbfCON;
    private final String dbfSUBSTR;
    private final String dbfSYSDATE;

    private DBFunctionName(String string2, String string3, String string4) {
        this.dbfCON = string2;
        this.dbfSUBSTR = string3;
        this.dbfSYSDATE = string4;
    }

    public String getFunctionName(String string) {
        String string2 = "NAME".equalsIgnoreCase(string) ? this.toString() : ("CON".equalsIgnoreCase(string) ? this.dbfCON : ("SUBSTR".equalsIgnoreCase(string) ? this.dbfSUBSTR : ("SYSDATE".equalsIgnoreCase(string) ? this.dbfSYSDATE : string)));
        return string2;
    }

    public static String getFunctionName(String string, String string2) {
        String string3 = ConnectionFactory.getDBName(string2);
        return DBFunctionName.getDBName(string3).getFunctionName(string);
    }

    public int getSequence(String string, Transaction transaction) {
        String string2 = null;
        switch (this) {
            case ORACLE: {
                string2 = "select " + string + ".nextval from dual";
                break;
            }
            case HSQL: {
                string2 = "select next value for " + string + " from dual";
                break;
            }
            case POSTGRES: {
                string2 = "select nextval('" + string + "')";
                break;
            }
            case MYSQL: {
                string2 = "update " + string + " set SEQID = last_insert_id(SEQID+1)";
                DBUtil.dbExecute(string2, new String[0], transaction);
                string2 = "select last_insert_id()";
                break;
            }
            case SQLSERVER: {
                throw new OgRuntimeException("\u73fe\u5728\u3001SQLSERVER\u3067\u306f\u30b7\u30fc\u30b1\u30f3\u30b9\u6a5f\u80fd\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            case FIREBIRD: {
                string2 = "select gen_id(" + string + ", 1) from rdb$database";
                break;
            }
            case CACHE: {
                throw new OgRuntimeException("\u73fe\u5728\u3001CACHE\u3067\u306f\u30b7\u30fc\u30b1\u30f3\u30b9\u6a5f\u80fd\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            default: {
                throw new OgRuntimeException("\u73fe\u5728\u3001\u3053\u306e\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3067\u306f\u30b7\u30fc\u30b1\u30f3\u30b9\u6a5f\u80fd\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
        }
        String[][] stringArray = DBUtil.dbExecute(string2, new String[0], transaction);
        return Integer.parseInt(stringArray[0][0]);
    }

    public static DBFunctionName getDBName(String string) {
        DBFunctionName dBFunctionName;
        String string2 = string.toUpperCase(Locale.JAPAN);
        if (string2.contains("ORACLE")) {
            dBFunctionName = ORACLE;
        } else if (string2.contains("HSQL")) {
            dBFunctionName = HSQL;
        } else if (string2.contains("POSTGRES")) {
            dBFunctionName = POSTGRES;
        } else if (string2.contains("MYSQL")) {
            dBFunctionName = MYSQL;
        } else if (string2.contains("SQLSERVER")) {
            dBFunctionName = SQLSERVER;
        } else if (string2.contains("FIREBIRD")) {
            dBFunctionName = FIREBIRD;
        } else if (string2.contains("CACHE")) {
            dBFunctionName = CACHE;
        } else {
            String string3 = "\u521d\u671f\u5316\u6642\u306b\u3001\u6307\u5b9a\u306e dbName \u30ad\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[" + string + "] \u30ad\u30fc\u306f\u3001" + Arrays.toString((Object[])DBFunctionName.values());
            throw new OgRuntimeException(string3);
        }
        return dBFunctionName;
    }
}

