/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;

public class TransactionImpl
implements Transaction {
    private static final String VERSION = "6.3.9.0 (2015/11/06)";
    private static final long serialVersionUID = 639020151106L;
    private static final String DBID = "DEFAULT";
    private final ApplicationInfo appInfo;
    private Connection defconn;
    private final Map<String, Connection> dbidMap = Collections.synchronizedMap(new HashMap());
    private boolean isCommit;
    private boolean isRollback;
    private boolean isFinish;

    public TransactionImpl(ApplicationInfo applicationInfo) {
        this.appInfo = applicationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String string) {
        if (string == null || string.isEmpty() || DBID.equalsIgnoreCase(string)) {
            if (this.defconn == null) {
                this.defconn = ConnectionFactory.connection(DBID, this.appInfo);
            }
            return this.defconn;
        }
        String string2 = string.toUpperCase(Locale.JAPAN);
        Map<String, Connection> map = this.dbidMap;
        synchronized (map) {
            Connection connection = this.dbidMap.get(string2);
            if (connection == null) {
                connection = ConnectionFactory.connection(string2, this.appInfo);
                this.dbidMap.put(string2, connection);
            }
            return connection;
        }
    }

    @Override
    public void commit() {
        this.isCommit = true;
    }

    @Override
    public void rollback() {
        this.isRollback = true;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (this.isFinish) {
            String string = "\u3059\u3067\u306b\u3001finish() \u5b9f\u884c\u6e08\u307f\u3067\u3059\u3002" + HybsConst.CR + "  \u65b0\u898f\u306b Transaction \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u4f5c\u6210\u304b\u3089\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR;
            throw new OgRuntimeException(string);
        }
        if (this.defconn != null) {
            this.connClose(this.defconn, DBID);
            this.defconn = null;
        }
        Map<String, Connection> map = this.dbidMap;
        synchronized (map) {
            for (Map.Entry<String, Connection> entry : this.dbidMap.entrySet()) {
                String string = entry.getKey();
                Connection connection = entry.getValue();
                this.connClose(connection, string);
            }
            this.dbidMap.clear();
        }
        this.isFinish = true;
    }

    private void connClose(Connection connection, String string) {
        boolean bl = this.isCommit && !this.isRollback ? Closer.commit(connection) : Closer.rollback(connection);
        if (this.isRollback || !bl) {
            ConnectionFactory.remove(connection, string);
        } else {
            ConnectionFactory.close(connection, string);
        }
    }
}

