<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0003"
	title    = "カラム"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	5.6.9.2 2013/10/18 {@scope}対応
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "CLM,NAME_JA,SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@USE_UPLOADFILE}{@command}" val2="trueNEW">
	<og:value key="scope" value="request" />
</og:equals>

<og:query command="{@command}" dbid="{@FROM_DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="{@scope}">
		select
		'1' as WRITABLE,A.CLM,A.NAME_JA,B.LNAME,B.SNAME,A.CLS_NAME,A.USE_LENGTH,A.VIEW_LENGTH,
		A.RENDERER,A.EDITOR,A.DBTYPE,A.LABEL_CLM,A.CODE_CLM,A.ROLES,
		A.DATA_DEFAULT,A.COMMENTS,A.RENDERER_PARAM,A.EDITOR_PARAM,A.TYPE_PARAM,A.SYSTEM_ID,A.KBSAKU,A.FGLOAD,
		B.DESCRIPTION,A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,B.LANG,A.UNIQ,'0' EXIST_GEA08,0 UNIQ_GEA08
		from GEA03 A left outer join GEA08 B
		on A.SYSTEM_ID = B.SYSTEM_ID
		and A.CLM = B.CLM
		and B.FGJ    = '1'
		<og:where startKey="and">
			<og:and value = "B.LANG          =    '{@LANG}'"    />
		</og:where>
		where A.SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	<og:where startKey="and">
		<og:and value = "A.FGJ			=    '{@FGJ}'"			/>
		<og:and value = "UPPER(A.CLM)	like UPPER('{@CLM}')"	/>
		<og:and value = "A.CLS_NAME		=    '{@CLS_NAME}'"		/>
		<og:and value = "A.RENDERER		=    '{@RENDERER}'"		/>
		<og:and value = "A.EDITOR		=    '{@EDITOR}'"		/>
		<og:and value = "A.DBTYPE		=    '{@DBTYPE}'"		/>
		<og:and value = "A.LABEL_CLM	like '{@LABEL_CLM}'"	/>
		<og:and value = "A.CODE_CLM		like '{@CODE_CLM}'" 	/>
		<og:and value = "A.USE_LENGTH	=    '{@USE_LENGTH}'"	/>
		<og:and value = "A.VIEW_LENGTH	=    '{@VIEW_LENGTH}'"	/>
		<og:and value = "B.LNAME		like '{@LNAME}'"		/>
		<og:and value = "B.SNAME		like '{@SNAME}'"		/>
		<og:and value = "A.KBSAKU		=    '{@KBSAKU}'"		/>
		<og:and value = "A.FGLOAD		=    '{@FGLOAD}'"		/>
		<og:and value = "A.ROLES		like '{@ROLES}'"		/>
		<og:and value = "A.COMMENTS		like '{@COMMENTS}'" 	/>
		<og:and value = "A.RDC_CODE		=    '{@RDC_CODE}'"		/>
		<og:and value = "A.DYUPD	&gt;=    '{@DYUPDFROM}'"	/>
		<og:and value = "A.DYUPD	&lt;=    '{@DYUPDTO}99'"	/>
		<og:and value = "A.RELEASE_NOTES like '{@RELEASE_NOTES}'" />
		<og:and value = "A.USRUPD		=    '{@USRUPD}'"		/>
		<og:and value = "A.CDKH {@CDKH}"						/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.CLM,B.LANG,A.SYSTEM_ID DESC,A.KBSAKU DESC,B.KBSAKU DESC" />
</og:query>

<og:columnEditor columns="CLM,SYSTEM_ID" must="true" />

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GE0005" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG"
		vals="NEW,[SYSTEM_ID],[CLM],1,[LANG]" />
	<og:link column="RENDERER" gamenId="GE0004" href="index.jsp" target="CONTENTS" onLink="[RENDERER]"
				markList="MENU|INMENU|CHBOX|RADIO|BITBOX"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG"
		vals="NEW,[SYSTEM_ID],[CLM],1,[LANG]" />
	<og:link column="CODE_CLM" gamenId="GE0004" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG"
		vals="NEW,[SYSTEM_ID],[CODE_CLM],1,[LANG]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:equals val1="{@ACTION}" nullCheck="true">
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
			keys="noWritable" vals="null" />
		<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
			keys="noWritable" vals='"SYSTEM_ID,CLM,KBSAKU,RDC_CODE,CDKH"' />
		<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="Z"
			keys="columnWritable,logicalDelete" vals="null,true" />
		<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
			keys="columnWritable" vals="null" />
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA03" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  value="update" lbl="COPY" command="COPY"
				keys="noWritable,sysins" vals="null,true" />
		</fieldset>
	</og:equals>
	<og:equals val1="{@ACTION}" val2="MINUS">
		<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
			keys="noWritable" vals="null" />
	</og:equals>
	<og:equals val1="{@ACTION}" val2="DIFFERENCE">
		<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
			keys="noWritable" vals='"SYSTEM_ID,CLM,KBSAKU,RDC_CODE,CDKH"' />
	</og:equals>
<br />
</og:writeCheck>

<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
		{@USER.LASTSQL}
	</og:query>

	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM,KBSAKU"
		diffKeys      = "NAME_JA,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,LABEL_CLM,CODE_CLM,ROLES,DATA_DEFAULT,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,LNAME,SNAME"
		slaveScope    = "request"
		modifyClms    = "UNIQ,UNIQ_GEA08"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,EXIST_GEA08,UNIQ_GEA08"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
