/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.system;

/**
 * 関数型インターフェースです。
 *
 * カウンターを引数に受け取り、結果を文字列配列で返す関数型インターフェースのメソッドです。
 * 使用方法としては、何らかの処理で、開始から終了までのカウンターをループに回し、
 * 何らかの処理の結果、文字列配列を作成します。
 * 戻り値を、一気に返したかっただけなので、本当は何らかのオブジェクトにした方が良いです。
 * 近いうちに修正しますので、今は、使わないでください。
 *
 * これは、主に、OgBuilder で使うインターフェースです。
 *
 * @og.rev 6.4.4.1 (2016/03/18) 新規追加
 *
 * @version  6.4
 * @author	 Kazuhiko Hasegawa
 * @since    JDK8.0,
 */
@FunctionalInterface
public interface RoopFunction {

	/**
	 * カウンターを引数に、実行する関数型インターフェースの関数です。
	 *
	 * @param cnt 数値カウンター
	 * @return 関数を適用した結果返される文字列配列
	 */
	String[] apply( Integer cnt );

//	/**
//	 * Returns a composed function that first applies the {@code before}
//	 * function to its input, and then applies this function to the result.
//	 * If evaluation of either function throws an exception, it is relayed to
//	 * the caller of the composed function.
//	 *
//	 * @param <V> the type of input to the {@code before} function, and to the
//	 *			 composed function
//	 * @param before the function to apply before this function is applied
//	 * @return a composed function that first applies the {@code before}
//	 * function and then applies this function
//	 * @throws NullPointerException if before is null
//	 *
//	 * @see #andThen(Function)
//	 */
//	default <V> Function<V, R> compose( Function<? super V, ? extends T> before ) {
//		Objects.requireNonNull( before );
//		return (V v) -> apply( before.apply(v) );
//	}
//
//	/**
//	 * Returns a composed function that first applies this function to
//	 * its input, and then applies the {@code after} function to the result.
//	 * If evaluation of either function throws an exception, it is relayed to
//	 * the caller of the composed function.
//	 *
//	 * @param <V> the type of output of the {@code after} function, and of the
//	 *			 composed function
//	 * @param after the function to apply after this function is applied
//	 * @return a composed function that first applies this function and then
//	 * applies the {@code after} function
//	 * @throws NullPointerException if after is null
//	 *
//	 * @see #compose(Function)
//	 */
//	default <V> Function<T, V> andThen( Function<? super R, ? extends V> after ) {
//		Objects.requireNonNull( after );
//		return (T t) -> after.apply( apply(t) );
//	}
//
//	/**
//	 * Returns a function that always returns its input argument.
//	 *
//	 * @param <T> the type of the input and output objects to the function
//	 * @return a function that always returns its input argument
//	 */
//	static <T> Function<T, T> identity() {
//		return t -> t;
//	}
}
