/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.mail.MailPattern;

public class DefaultMailManager {
    private static final String CONTENTS = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "CONTENT" : "CONTENTS";
    private static final String SEL_YKNO = "SELECT GE32S02.NEXTVAL YKNO FROM DUAL";
    private static final String INS_GE32 = "INSERT INTO GE32(YKNO,PARA_KEY,PTN_ID,FROM_ADDR,TITLE," + CONTENTS + ",ATTACH1,ATTACH2,ATTACH3,ATTACH4,ATTACH5,DYSET,USRSET,PGUPD,SYSTEM_ID,FGJ)" + " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'1')";
    private static final String INS_GE34 = "INSERT INTO GE34(YKNO,DST_ID,GROUP_ID,DST_NAME,DST_ADDR,DST_KBN,FGJ,DYSET,USRSET,PGUPD) VALUES(?,?,?,?,?,?,?,?,?,?)";
    protected static final String FGJ_SEND_WAIT = "0";
    protected static final String FGJ_SEND_OVER = "1";
    protected static final String FGJ_ADDR_ERR = "7";
    protected static final String FGJ_ACNT_ERR = "8";
    private static final int GE32_YKNO = 0;
    private static final int GE32_PARAKEY = 1;
    private static final int GE32_PTN_ID = 2;
    private static final int GE32_FROM_ADDR = 3;
    private static final int GE32_TITLE = 4;
    private static final int GE32_CONTENTS = 5;
    private static final int GE32_ATTACH1 = 6;
    private static final int GE32_ATTACH2 = 7;
    private static final int GE32_ATTACH3 = 8;
    private static final int GE32_ATTACH4 = 9;
    private static final int GE32_ATTACH5 = 10;
    private static final int GE32_DYSET = 11;
    private static final int GE32_USRSET = 12;
    private static final int GE32_PGUPD = 13;
    private static final int GE32_SYSTEM_ID = 14;
    private static final int GE34_YKNO = 0;
    private static final int GE34_DST_ID = 1;
    private static final int GE34_GROUP_ID = 2;
    private static final int GE34_DST_NAME = 3;
    private static final int GE34_DST_ADDR = 4;
    private static final int GE34_DST_KBN = 5;
    private static final int GE34_FGJ = 6;
    private static final int GE34_DYSET = 7;
    private static final int GE34_USRSET = 8;
    private static final int GE34_PGUPD = 9;
    private static String charset = HybsSystem.sys("MAIL_DEFAULT_CHARSET");
    private boolean debugFlag;
    private final List<String> errAddrList = new ArrayList<String>();
    private static final int MAX_RETRY = 3;
    private String host = HybsSystem.sys("COMMON_MAIL_SERVER");
    private String smtpPort = HybsSystem.sys("SMTP_PORT");
    private String authType = HybsSystem.sys("MAIL_SEND_AUTH");
    private String authPort = HybsSystem.sys("MAIL_SEND_AUTH_PORT");
    private String authUser = HybsSystem.sys("MAIL_SEND_AUTH_USER");
    private String authPass = HybsSystem.sys("MAIL_SEND_AUTH_PASSWORD");
    private boolean useSSL = HybsSystem.sysBool("MAIL_SEND_USE_SSL");
    private String mailTitle;
    private String mailContent;
    private String fromAddr;
    private String[] attachFiles;
    private ConcurrentMap<String, String[]> mailDstMap;
    private ConcurrentMap<String, String> initParamMap;
    private MailTX mail;
    protected final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    protected static final ApplicationInfo APP_INFO;

    public void create(ConcurrentMap<String, String> concurrentMap) {
        this.initParamMap = concurrentMap;
        MailPattern mailPattern = new MailPattern(concurrentMap);
        this.fromAddr = mailPattern.getFromAddr();
        this.setAttachFiles((String)concurrentMap.get("ATTACH1"), (String)concurrentMap.get("ATTACH2"), (String)concurrentMap.get("ATTACH3"), (String)concurrentMap.get("ATTACH4"), (String)concurrentMap.get("ATTACH5"));
        this.mailDstMap = mailPattern.getDstMap();
        this.mailTitle = mailPattern.getTitle();
        this.mailContent = mailPattern.getContent();
        this.errAddrList.addAll(mailPattern.getErrList());
        this.host = StringUtil.nval((String)mailPattern.getHost(), (String)this.host);
        this.smtpPort = StringUtil.nval((String)mailPattern.getSmtpPort(), (String)this.smtpPort);
        this.authType = StringUtil.nval((String)mailPattern.getAuthType(), (String)this.authType);
        this.authPort = StringUtil.nval((String)mailPattern.getAuthPort(), (String)this.authPort);
        this.authUser = StringUtil.nval((String)mailPattern.getAuthUser(), (String)this.authUser);
        this.authPass = StringUtil.nval((String)mailPattern.getAuthPass(), (String)this.authPass);
    }

    public void send() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.mail = new MailTX(this.host, charset, this.smtpPort, this.authType, this.authPort, this.authUser, this.authPass, this.useSSL);
        this.mail.setFrom(this.fromAddr);
        this.mail.setFilename(this.attachFiles);
        this.mail.setSubject(this.mailTitle);
        this.mail.setMessage(this.mailContent);
        this.mail.setDebug(this.debugFlag);
        this.setMailDst(arrayList);
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = 3;
        while (n > 0) {
            try {
                this.mail.sendmail();
            }
            catch (RuntimeException runtimeException) {
                Object object;
                Throwable throwable = runtimeException.getCause();
                if (throwable instanceof SendFailedException) {
                    object = ((SendFailedException)throwable).getInvalidAddresses();
                    if (object != null) {
                        int n2 = ((Address[])object).length;
                        for (int i = 0; i < n2; ++i) {
                            arrayList.add(((InternetAddress)object[i]).getAddress());
                        }
                    }
                }
                object = "\u9001\u4fe1\u6642\u306b\u30a8\u30e9\u30fc\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + runtimeException.getMessage();
                throw new OgRuntimeException((String)object, (Throwable)runtimeException);
            }
            if (arrayList.isEmpty()) {
                n = -1;
                continue;
            }
            stringBuilder.setLength(0);
            String string = stringBuilder.append("\u30a2\u30c9\u30ec\u30b9\u30a8\u30e9\u30fc\u3002\u30e6\u30fc\u30b6\u30fcID\uff1a").append(this.getUserIds(arrayList)).append(" \u30a2\u30c9\u30ec\u30b9\uff1a").append(arrayList.stream().collect(Collectors.joining(","))).toString();
            if ("true".equals(this.initParamMap.get("ADDR_CHECK"))) {
                throw new OgRuntimeException(string);
            }
            this.setMailDst(arrayList);
            --n;
            arrayList.clear();
            this.errAddrList.add(string);
        }
        this.commitMailDB();
    }

    public void setDebug(boolean bl) {
        this.debugFlag = bl;
    }

    public void setFromAddr(String string) {
        this.fromAddr = string;
    }

    public void setTitle(String string) {
        this.mailTitle = string;
    }

    public void setContent(String string) {
        this.mailContent = string;
    }

    public void setHost(String string) {
        this.host = StringUtil.nval((String)string, (String)this.host);
    }

    public void setPort(String string) {
        this.smtpPort = StringUtil.nval((String)string, (String)this.smtpPort);
    }

    public void setAuthType(String string) {
        this.authType = StringUtil.nval((String)string, (String)this.authType);
    }

    public void setAuthUser(String string) {
        this.authUser = StringUtil.nval((String)string, (String)this.authUser);
    }

    public void setAuthPass(String string) {
        this.authPass = StringUtil.nval((String)string, (String)this.authPass);
    }

    public String getFromAddr() {
        return this.fromAddr;
    }

    public String getTitle() {
        return this.mailTitle;
    }

    public String getContent() {
        return this.mailContent;
    }

    protected void commitMailDB() {
        String string;
        String[] stringArray = new String[15];
        stringArray[0] = string = this.getYkno();
        stringArray[1] = (String)this.initParamMap.get("PARAKEY");
        stringArray[2] = this.trim((String)this.initParamMap.get("PTN_ID"), 20);
        stringArray[3] = this.trim(this.fromAddr, 100);
        stringArray[4] = this.trim(this.mailTitle, 300);
        stringArray[5] = this.mailContent;
        stringArray[6] = "";
        stringArray[7] = "";
        stringArray[8] = "";
        stringArray[9] = "";
        stringArray[10] = "";
        if (this.attachFiles != null) {
            int n = this.attachFiles.length;
            for (int i = 0; i < n; ++i) {
                stringArray[6 + i] = this.trim(this.attachFiles[i], 256);
            }
        }
        stringArray[11] = DateSet.getDate((String)"yyyyMMddHHmmss");
        stringArray[12] = (String)this.initParamMap.get("LOGIN_USERID");
        stringArray[13] = (String)this.initParamMap.get("PGID");
        stringArray[14] = (String)this.initParamMap.get("SYSTEM_ID");
        DBUtil.dbExecute((String)INS_GE32, (String[])stringArray, (ApplicationInfo)APP_INFO, (String)this.DBID);
        String[] stringArray2 = new String[10];
        stringArray2[0] = string;
        for (String[] stringArray3 : this.mailDstMap.values()) {
            stringArray2[1] = this.trim(stringArray3[0], 10);
            stringArray2[2] = this.trim(stringArray3[1], 20);
            stringArray2[3] = this.trim(stringArray3[3], 20);
            stringArray2[4] = this.trim(stringArray3[4], 100);
            stringArray2[5] = stringArray3[5];
            stringArray2[6] = stringArray3[6];
            stringArray2[7] = DateSet.getDate((String)"yyyyMMddHHmmss");
            stringArray2[8] = (String)this.initParamMap.get("LOGIN_USERID");
            stringArray2[9] = (String)this.initParamMap.get("PGID");
            DBUtil.dbExecute((String)INS_GE34, (String[])stringArray2, (ApplicationInfo)APP_INFO, (String)this.DBID);
        }
    }

    protected void setInitParams(ConcurrentMap<String, String> concurrentMap) {
        this.initParamMap = concurrentMap;
    }

    protected void setAttachFiles(String string, String string2, String string3, String string4, String string5) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() != 0) {
            arrayList.add(string);
        }
        if (string2 != null && string2.length() != 0) {
            arrayList.add(string2);
        }
        if (string3 != null && string3.length() != 0) {
            arrayList.add(string3);
        }
        if (string4 != null && string4.length() != 0) {
            arrayList.add(string4);
        }
        if (string5 != null && string5.length() != 0) {
            arrayList.add(string5);
        }
        this.attachFiles = arrayList.toArray(new String[arrayList.size()]);
    }

    protected void setMailDstMap(ConcurrentMap<String, String[]> concurrentMap) {
        this.mailDstMap = concurrentMap;
    }

    protected ConcurrentMap<String, String[]> getMailDstMap() {
        return this.mailDstMap;
    }

    protected String trim(String string, int n) {
        String string2 = string;
        if (string != null && string.length() > n) {
            string2 = StringUtil.cut((String)string, (int)n);
        }
        return string2;
    }

    protected List<String> getErrList() {
        return this.errAddrList;
    }

    private void setMailDst(List<String> list) {
        String[] stringArray2;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        HashMap hashMap = new HashMap();
        hashMap.put(0, arrayList);
        hashMap.put(1, arrayList2);
        hashMap.put(2, arrayList3);
        for (String[] stringArray2 : this.mailDstMap.values()) {
            Integer n = Integer.valueOf(stringArray2[5]);
            if (list.contains(stringArray2[4]) || FGJ_ADDR_ERR.equals(stringArray2[6])) {
                if (!FGJ_SEND_OVER.equals(stringArray2[6])) continue;
                stringArray2[6] = FGJ_ACNT_ERR;
                continue;
            }
            stringArray2[6] = FGJ_SEND_OVER;
            String string = stringArray2[3];
            if (string != null && string.length() > 0) {
                ((ArrayList)hashMap.get(n)).add(stringArray2[3] + "<" + stringArray2[4] + ">");
                continue;
            }
            ((ArrayList)hashMap.get(n)).add(stringArray2[4]);
        }
        this.mail.clearTo();
        this.mail.clearCc();
        this.mail.clearBcc();
        boolean bl = false;
        if (!arrayList.isEmpty()) {
            bl = true;
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            this.mail.setTo(stringArray2);
        }
        if (!arrayList2.isEmpty()) {
            bl = true;
            stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
            this.mail.setCc(stringArray2);
        }
        if (!arrayList3.isEmpty()) {
            bl = true;
            stringArray2 = arrayList3.toArray(new String[arrayList3.size()]);
            this.mail.setBcc(stringArray2);
        }
        if (!bl) {
            throw new OgRuntimeException("\u5b9b\u5148\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u6709\u52b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002TO , CC , BCC \u306e\u3044\u3065\u308c\u306b\u3082\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    private String getYkno() {
        String[][] stringArray = DBUtil.dbExecute((String)SEL_YKNO, (String[])new String[0], (ApplicationInfo)APP_INFO, (String)this.DBID);
        if (stringArray == null || stringArray.length == 0) {
            throw new OgRuntimeException("\u8981\u6c42NO\u63a1\u756a\u30a8\u30e9\u30fc SQL=SELECT GE32S02.NEXTVAL YKNO FROM DUAL");
        }
        return stringArray[0][0];
    }

    private String getUserIds(List<String> list) {
        int n = list.size();
        if (n == 0) {
            return "";
        }
        HashMap hashMap = new HashMap();
        this.mailDstMap.forEach((string, stringArray) -> hashMap.put(stringArray[4], string));
        StringBuilder stringBuilder = new StringBuilder(200).append((String)hashMap.get(list.get(0)));
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(',').append((String)hashMap.get(list.get(i)));
        }
        return stringBuilder.toString();
    }

    static {
        if (USE_DB_APPLICATION_INFO) {
            APP_INFO = new ApplicationInfo();
            APP_INFO.setClientInfo("MailModuel", HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            APP_INFO.setModuleInfo("MailModuel", "MailManager", "MailManager");
        } else {
            APP_INFO = null;
        }
    }
}

