/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.ChartCreate;
import org.opengion.hayabusa.io.ChartDataset;
import org.opengion.hayabusa.io.HybsURLTagFragmentGenerator;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ChartCreateTag
extends CommonTagSupport {
    private static final String VERSION = "6.4.3.1 (2016/02/12)";
    private static final long serialVersionUID = 643120160212L;
    private static final String FILE_URL = HybsSystem.sys("CHART_TEMP_DIR");
    private static final String CHART_CACHE_KEY = "h_chartKey";
    private transient List<ChartDataset> chartDataset;
    private transient Map<String, ChartCache> chrtMap;
    private String title;
    private int width = 200;
    private int height = 200;
    private String domainLabel;
    private boolean showLegend = true;
    private String rectangleEdge = "BOTTOM";
    private String plotOrientation = "VERTICAL";
    private String chartBackColor;
    private String plotBackColor;
    private int rotationLabel = 3;
    private boolean useVerticalLabels;
    private String domainMarker;
    private boolean useDomainLabel = true;
    private boolean useMarkerLabel = true;
    private boolean useCache;
    private int seriesPikup = -1;
    private String masterKey = "imgTag";
    private int cacheTime = HybsSystem.sysInt("CHART_CACHE_TIME");
    private String imgTag;
    private String imageMapUrl;
    private String imageMapTarget;
    private long dyStart;
    private boolean useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
    private String categoryMargin;
    private String lowerMargin;
    private String upperMargin;
    private boolean useDomainLine;
    private String domainLineColor;
    private boolean useRangeLine = true;
    private String rangeLineColor;
    private int categorySkip = 1;
    private int categoryCutNo = -1;
    private String categoryAnchor;
    private int rangeSkip = -1;
    private boolean useToolTip;
    private String dateAxisFormat = "MM/dd";
    private String chartFile;

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        this.dyStart = System.currentTimeMillis();
        if (this.useCache) {
            this.chrtMap = (Map)this.getObject(CHART_CACHE_KEY);
            if (this.chrtMap == null) {
                this.chrtMap = new ConcurrentHashMap<String, ChartCache>();
            } else {
                this.chrtMap.values().removeIf(chartCache -> !chartCache.isAvailable());
                String string = this.getGUIInfoAttri("KEY") + this.masterKey;
                ChartCache chartCache2 = this.chrtMap.get(string);
                if (chartCache2 != null && chartCache2.isAvailable()) {
                    this.imgTag = chartCache2.getImageTag();
                    return 0;
                }
            }
        }
        return 2;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        long l = System.currentTimeMillis();
        if (this.useTimeView) {
            this.jspPrint("<div id=\"queryTime\" value=\"" + (l - this.dyStart) + "\"></div>");
        }
        if (this.imgTag == null) {
            String string;
            Object object;
            ChartCreate chartCreate = this.create();
            JFreeChart jFreeChart = chartCreate.getChart();
            File file = this.getTempFile(FILE_URL);
            try {
                object = file.getName();
                string = this.getContextPath() + "/" + FILE_URL + (String)object;
                if (this.imageMapUrl != null || this.useToolTip) {
                    String string2 = ((String)object).substring(0, ((String)object).length() - 4);
                    StandardToolTipTagFragmentGenerator standardToolTipTagFragmentGenerator = this.useToolTip ? new StandardToolTipTagFragmentGenerator() : null;
                    HybsURLTagFragmentGenerator hybsURLTagFragmentGenerator = this.imageMapUrl == null ? null : new HybsURLTagFragmentGenerator(this.imageMapTarget);
                    ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                    ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)this.width, (int)this.height, (ChartRenderingInfo)chartRenderingInfo);
                    this.imgTag = ImageMapUtilities.getImageMap((String)string2, (ChartRenderingInfo)chartRenderingInfo, (ToolTipTagFragmentGenerator)standardToolTipTagFragmentGenerator, (URLTagFragmentGenerator)hybsURLTagFragmentGenerator) + this.makeTag2(string, string2);
                } else {
                    ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)this.width, (int)this.height);
                    this.imgTag = this.makeTag2(string, null);
                }
            }
            catch (IOException iOException) {
                String string3 = "\u30d5\u30a1\u30a4\u30eb I/O \u304c\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + file + CR + iOException.getMessage();
                throw new HybsSystemException(string3, iOException);
            }
            this.jspPrint(this.imgTag);
            if (this.useCache) {
                object = new ChartCache(this.imgTag, this.cacheTime);
                string = this.getGUIInfoAttri("KEY") + this.masterKey;
                this.chrtMap.put(string, (ChartCache)object);
                this.setObject(CHART_CACHE_KEY, this.chrtMap);
            }
        } else {
            this.jspPrint(this.imgTag);
        }
        this.setRequestAttribute("CHART.TAG", this.imgTag);
        if (this.useTimeView) {
            long l2 = System.currentTimeMillis();
            this.jspPrint("<div id=\"viewTime\" value=\"" + (l2 - l) + "\"></div>");
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.chartDataset = null;
        this.title = null;
        this.width = 200;
        this.height = 200;
        this.domainLabel = null;
        this.showLegend = true;
        this.rectangleEdge = "BOTTOM";
        this.plotOrientation = "VERTICAL";
        this.chartBackColor = null;
        this.plotBackColor = null;
        this.rotationLabel = 3;
        this.useVerticalLabels = false;
        this.domainMarker = null;
        this.useDomainLabel = true;
        this.useMarkerLabel = true;
        this.useCache = false;
        this.seriesPikup = -1;
        this.masterKey = "imgTag";
        this.cacheTime = HybsSystem.sysInt("CHART_CACHE_TIME");
        this.chrtMap = null;
        this.imgTag = null;
        this.imageMapUrl = null;
        this.imageMapTarget = null;
        this.categoryMargin = null;
        this.lowerMargin = null;
        this.upperMargin = null;
        this.useDomainLine = false;
        this.domainLineColor = null;
        this.useRangeLine = true;
        this.rangeLineColor = null;
        this.categorySkip = 1;
        this.categoryCutNo = -1;
        this.categoryAnchor = null;
        this.rangeSkip = -1;
        this.dateAxisFormat = "MM/dd";
        this.chartFile = null;
        this.useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
    }

    private String makeTag2(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(200).append("<img");
        if (string2 != null) {
            stringBuilder.append(" usemap=\"#").append(string2).append('\"');
        }
        stringBuilder.append(" width=\"").append(this.width).append("px\" height=\"").append(this.height).append("px\" src=\"").append(string).append("\" /> ");
        return stringBuilder.toString();
    }

    private ChartCreate create() {
        ChartCreate chartCreate = new ChartCreate();
        chartCreate.setTitle(this.title);
        chartCreate.setDomainLabel(this.domainLabel);
        chartCreate.setShowLegend(this.showLegend);
        chartCreate.setRectangleEdge(this.rectangleEdge);
        chartCreate.setPlotOrientation(this.plotOrientation);
        chartCreate.setChartBackColor(this.chartBackColor);
        chartCreate.setPlotBackColor(this.plotBackColor);
        chartCreate.setRotationLabel(this.rotationLabel);
        chartCreate.setUseVerticalLabels(this.useVerticalLabels);
        chartCreate.setDomainMarker(this.domainMarker);
        chartCreate.setUseDomainLabel(this.useDomainLabel);
        chartCreate.setUseMarkerLabel(this.useMarkerLabel);
        chartCreate.setSeriesPikup(this.seriesPikup);
        chartCreate.setImageMapUrl(this.imageMapUrl);
        chartCreate.setCategoryMargin(this.categoryMargin);
        chartCreate.setLowerMargin(this.lowerMargin);
        chartCreate.setUpperMargin(this.upperMargin);
        chartCreate.setUseDomainLine(this.useDomainLine);
        chartCreate.setDomainLineColor(this.domainLineColor);
        chartCreate.setUseRangeLine(this.useRangeLine);
        chartCreate.setRangeLineColor(this.rangeLineColor);
        chartCreate.setCategorySkip(this.categorySkip);
        chartCreate.setCategoryCutNo(this.categoryCutNo);
        chartCreate.setCategoryAnchor(this.categoryAnchor);
        chartCreate.setRangeSkip(this.rangeSkip);
        chartCreate.setUseToolTip(this.useToolTip);
        chartCreate.setDateAxisFormat(this.dateAxisFormat);
        if (this.isDebug()) {
            chartCreate.setDebug(true);
        }
        chartCreate.setDatasetList(this.chartDataset);
        return chartCreate;
    }

    private File getTempFile(String string) {
        File file;
        String string2 = HybsSystem.url2dir(string, new String[0]);
        File file2 = new File(string2);
        if (!file2.exists() && !file2.mkdirs()) {
            String string3 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string2 + "]";
            throw new HybsSystemException(string3);
        }
        try {
            if (this.chartFile == null) {
                file = File.createTempFile("JFree", ".png", file2);
                file.deleteOnExit();
            } else {
                file = new File(file2, this.chartFile);
            }
        }
        catch (IOException iOException) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "Url:" + string;
            throw new HybsSystemException(string4, iOException);
        }
        return file;
    }

    public void setTitle(String string) {
        this.title = StringUtil.nval((String)this.getRequestParameter(string), (String)this.title);
    }

    public void setWidth(String string) {
        this.width = string != null && string.length() >= 3 && string.endsWith("px") ? Integer.parseInt(string.substring(0, string.length() - 2)) : StringUtil.nval((String)this.getRequestParameter(string), (int)this.width);
    }

    public void setHeight(String string) {
        this.height = string != null && string.length() >= 3 && string.endsWith("px") ? Integer.parseInt(string.substring(0, string.length() - 2)) : StringUtil.nval((String)this.getRequestParameter(string), (int)this.height);
    }

    public void setDomainLabel(String string) {
        this.domainLabel = StringUtil.nval((String)this.getRequestParameter(string), (String)this.domainLabel);
    }

    public void setShowLegend(String string) {
        this.showLegend = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.showLegend);
    }

    public void setRectangleEdge(String string) {
        this.rectangleEdge = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rectangleEdge);
    }

    public void setPlotOrientation(String string) {
        this.plotOrientation = StringUtil.nval((String)this.getRequestParameter(string), (String)this.plotOrientation);
    }

    public void setChartBackColor(String string) {
        this.chartBackColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.chartBackColor);
    }

    public void setPlotBackColor(String string) {
        this.plotBackColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.plotBackColor);
    }

    public void setRotationLabel(String string) {
        this.rotationLabel = StringUtil.nval((String)this.getRequestParameter(string), (int)this.rotationLabel);
    }

    public void setUseVerticalLabels(String string) {
        this.useVerticalLabels = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useVerticalLabels);
    }

    public void setDomainMarker(String string) {
        this.domainMarker = StringUtil.nval((String)this.getRequestParameter(string), (String)this.domainMarker);
    }

    public void setUseDomainLabel(String string) {
        this.useDomainLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useDomainLabel);
    }

    public void setUseMarkerLabel(String string) {
        this.useMarkerLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMarkerLabel);
    }

    public void setUseCache(String string) {
        this.useCache = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useCache);
    }

    public void setCacheTime(String string) {
        this.cacheTime = StringUtil.nval((String)this.getRequestParameter(string), (int)this.cacheTime);
    }

    public void setCacheScope(String string) {
        this.setScope(string);
    }

    public void setMasterKey(String string) {
        this.masterKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.masterKey);
    }

    public void setSeriesPikup(String string) {
        this.seriesPikup = StringUtil.nval((String)this.getRequestParameter(string), (int)this.seriesPikup);
    }

    public void setImageMapUrl(String string) {
        this.imageMapUrl = StringUtil.nval((String)this.getRequestParameter(string), (String)this.imageMapUrl);
    }

    public void setImageMapTarget(String string) {
        this.imageMapTarget = StringUtil.nval((String)this.getRequestParameter(string), (String)this.imageMapTarget);
    }

    public void setCategoryMargin(String string) {
        this.categoryMargin = StringUtil.nval((String)this.getRequestParameter(string), (String)this.categoryMargin);
    }

    public void setLowerMargin(String string) {
        this.lowerMargin = StringUtil.nval((String)this.getRequestParameter(string), (String)this.lowerMargin);
    }

    public void setUpperMargin(String string) {
        this.upperMargin = StringUtil.nval((String)this.getRequestParameter(string), (String)this.upperMargin);
    }

    public void setUseDomainLine(String string) {
        this.useDomainLine = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useDomainLine);
    }

    public void setDomainLineColor(String string) {
        this.domainLineColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.domainLineColor);
    }

    public void setCategorySkip(String string) {
        this.categorySkip = StringUtil.nval((String)this.getRequestParameter(string), (int)this.categorySkip);
    }

    public void setCategoryCutNo(String string) {
        this.categoryCutNo = StringUtil.nval((String)this.getRequestParameter(string), (int)this.categoryCutNo);
    }

    public void setCategoryAnchor(String string) {
        this.categoryAnchor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.categoryAnchor);
        if (!(this.categoryAnchor == null || this.categoryAnchor.length() <= 0 || "START".equals(this.categoryAnchor) || "MIDDLE".equals(this.categoryAnchor) || "END".equals(this.categoryAnchor))) {
            String string2 = "\u6307\u5b9a\u306eAnchor\u306f\u9069\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]" + CR + "START,MIDDLE,END \u306e\u4e2d\u304b\u3089\u3001\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            throw new HybsSystemException(string2);
        }
    }

    public void setUseRangeLine(String string) {
        this.useRangeLine = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRangeLine);
    }

    public void setRangeLineColor(String string) {
        this.rangeLineColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rangeLineColor);
    }

    public void setRangeSkip(String string) {
        this.rangeSkip = StringUtil.nval((String)this.getRequestParameter(string), (int)this.rangeSkip);
    }

    public void setUseToolTip(String string) {
        this.useToolTip = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useToolTip);
    }

    public void setDateAxisFormat(String string) {
        this.dateAxisFormat = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dateAxisFormat);
    }

    public void setChartFile(String string) {
        this.chartFile = StringUtil.nval((String)this.getRequestParameter(string), (String)this.chartFile);
    }

    public void setUseTimeView(String string) {
        this.useTimeView = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTimeView);
    }

    protected void addChartDataset(ChartDataset chartDataset) {
        if (this.chartDataset == null) {
            this.chartDataset = new ArrayList<ChartDataset>();
        }
        this.chartDataset.add(chartDataset);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append('[').append(((Object)((Object)this)).getClass().getName()).append(']').append(CR).append("title           [").append(this.title).append(']').append(CR).append("width           [").append(this.width).append(']').append(CR).append("height          [").append(this.height).append(']').append(CR).append("domainLabel     [").append(this.domainLabel).append(']').append(CR).append("showLegend      [").append(this.showLegend).append(']').append(CR).append("rectangleEdge   [").append(this.rectangleEdge).append(']').append(CR).append("plotOrientation [").append(this.plotOrientation).append(']').append(CR).append("chartBackColor  [").append(this.chartBackColor).append(']').append(CR).append("plotBackColor   [").append(this.plotBackColor).append(']').append(CR);
        return stringBuilder.toString();
    }

    private static final class ChartCache {
        private final String imgTag;
        private final long createLimitTime;

        public ChartCache(String string, int n) {
            this.imgTag = string;
            this.createLimitTime = System.currentTimeMillis() + (long)n * 1000L;
        }

        public String getImageTag() {
            return this.imgTag;
        }

        public boolean isAvailable() {
            return System.currentTimeMillis() < this.createLimitTime;
        }
    }
}

