/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.CharacterCodingException;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.CommentLineParser;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.FileUtil;

public class FileLineModel
extends LineModel {
    private static final String[] KEYS = new String[]{"Level", "File", "Length", "Modify", "LineCnt", "Biko", "MD5", "FILEPATH", "ADDRESS", "FILENAME"};
    private static final int LEVEL = 0;
    private static final int FILE = 1;
    private static final int LENGTH = 2;
    private static final int MODIFY = 3;
    private static final int LINECNT = 4;
    private static final int BIKO = 5;
    private static final int MD5 = 6;
    private static final int FILEPATH = 7;
    private static final int ADDRESS = 8;
    private static final int FILENAME = 9;
    private final boolean useLineCnt;
    private final boolean useMD5;
    private final boolean omitCmnt;
    private final boolean useFilePath;
    private String encode = "JISAutoDetect";
    private String modifyForm = "yyyy/MM/dd HH:mm:ss";

    public FileLineModel() {
        this(false, false, false, false);
    }

    public FileLineModel(boolean bl) {
        this(bl, false, false, false);
    }

    public FileLineModel(boolean bl, boolean bl2) {
        this(bl, bl2, false, false);
    }

    public FileLineModel(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, bl3, false);
    }

    public FileLineModel(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.useLineCnt = bl;
        this.useMD5 = bl2;
        this.omitCmnt = bl3;
        this.useFilePath = bl4;
        this.init(KEYS);
    }

    public FileLineModel(LineModel lineModel) {
        this.init(lineModel.getNames());
        Object[] objectArray = lineModel.getValues();
        this.setValue(0, Integer.valueOf((String)objectArray[0]));
        this.setValue(1, new File((String)objectArray[1]));
        this.setValue(2, Long.valueOf((String)objectArray[2]));
        this.setValue(3, (String)objectArray[3]);
        String string = (String)objectArray[4];
        boolean bl = this.useLineCnt = string != null && string.length() > 0 && !"null".equalsIgnoreCase(string);
        if (this.useLineCnt) {
            this.setValue(4, string);
        }
        this.setValue(5, (String)objectArray[5]);
        String string2 = (String)objectArray[6];
        boolean bl2 = this.useMD5 = string2 != null && string2.length() > 0 && !"null".equalsIgnoreCase(string2);
        if (this.useMD5) {
            this.setValue(6, string2);
        }
        this.omitCmnt = false;
        if (objectArray.length > 7) {
            String string3 = (String)objectArray[7];
            boolean bl3 = this.useFilePath = string3 != null && string3.length() > 0 && !"null".equalsIgnoreCase(string3);
            if (this.useFilePath) {
                this.setValue(7, string3);
                if (objectArray.length > 8) {
                    this.setValue(8, (String)objectArray[8]);
                }
                if (objectArray.length > 9) {
                    this.setValue(9, (String)objectArray[9]);
                }
            }
        } else {
            this.useFilePath = false;
        }
    }

    public void setFileVals(int n, File file) {
        Object object;
        this.setValue(0, n);
        this.setValue(1, file);
        this.setValue(3, DateSet.getDate(file.lastModified(), this.modifyForm));
        File file2 = null;
        if (this.omitCmnt && this.useMD5) {
            try {
                file2 = File.createTempFile("temp", ".tmp");
                file2.deleteOnExit();
            }
            catch (IOException iOException) {
                String string = "\u30b3\u30e1\u30f3\u30c8\u9664\u5916\u306eMD5\u8a08\u7b97\u7528 temp \u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
        }
        if (this.useLineCnt || this.omitCmnt) {
            object = this.getLineCnt(file, file2);
            this.setValue(4, String.valueOf(object[0]));
            this.setValue(2, object[1]);
        } else {
            this.setValue(2, file.length());
        }
        if (this.useMD5 && file.isFile()) {
            if (file2 == null) {
                this.setValue(6, HybsCryptography.getMD5(file));
            } else {
                this.setValue(6, HybsCryptography.getMD5(file2));
            }
        }
        if (this.useFilePath) {
            try {
                this.setValue(7, file.getCanonicalPath());
            }
            catch (IOException iOException) {
                this.setValue(7, file.getAbsolutePath());
            }
            object = file.getParentFile();
            if (object != null) {
                this.setValue(8, ((File)object).getName());
            }
            this.setValue(9, file.getName());
        }
    }

    public void setEncode(String string) {
        this.encode = string;
    }

    public void setFile(File file) {
        this.setValue(1, file);
    }

    public File getFile() {
        return (File)this.getValue(1);
    }

    public void setBiko(String string) {
        this.setValue(5, string);
    }

    public int getLebel() {
        return (Integer)this.getValue(0);
    }

    public long getLength() {
        return (Long)this.getValue(2);
    }

    public void setModifyForm(String string) {
        if (string != null && !string.isEmpty()) {
            this.modifyForm = string;
        }
    }

    public String getModify() {
        return (String)this.getValue(3);
    }

    public String getMD5() {
        return (String)this.getValue(6);
    }

    private long[] getLineCnt(File file, File file2) {
        long l = 0L;
        long l2 = 0L;
        BufferedReader bufferedReader = FileUtil.getBufferedReader(file, this.encode);
        PrintWriter printWriter = null;
        if (file2 != null) {
            printWriter = FileUtil.getPrintWriter(file2, this.encode);
        }
        CommentLineParser commentLineParser = this.omitCmnt ? new CommentLineParser(FileInfo.getSUFIX(file)) : null;
        try {
            if (file.isFile()) {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (this.omitCmnt) {
                        if ((string = commentLineParser.line(string)) == null) continue;
                        if (printWriter != null) {
                            printWriter.println(string);
                        }
                    }
                    ++l;
                    l2 += (long)string.length();
                }
            }
        }
        catch (CharacterCodingException characterCodingException) {
            String string = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + " [" + file.getPath() + "] , Encode=[" + this.encode + "]";
            throw new OgRuntimeException(string, characterCodingException);
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u30ab\u30a6\u30f3\u30c8\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + " [" + file.getPath() + "] , Encode=[" + this.encode + "]";
            throw new OgRuntimeException(string, iOException);
        }
        finally {
            Closer.ioClose(bufferedReader);
            Closer.ioClose(printWriter);
        }
        return new long[]{l, l2};
    }
}

