/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBEditConfig;

public class DBEditConfigManager {
    private final ConcurrentMap<String, Map<String, DBEditConfig>> editConfigMap = new ConcurrentHashMap<String, Map<String, DBEditConfig>>();
    private static final String NAME_KEY = "EDIT_NAME_";
    private static final int NAME_LEN = "EDIT_NAME_".length();
    private final ConcurrentMap<String, String> editSelMap = new ConcurrentHashMap<String, String>();
    private static final String SLCT_KEY = "EDIT_SELECTED_";
    private static final int SLCT_LEN = "EDIT_SELECTED_".length();

    public DBEditConfigManager() {
    }

    public DBEditConfigManager(Map<String, String> map) {
        String[] stringArray;
        for (String string2 : stringArray = map.keySet().toArray(new String[map.size()])) {
            String string3;
            if (string2 == null) continue;
            if (string2.startsWith(SLCT_KEY)) {
                string3 = map.get(string2);
                if (string3 == null || string3.isEmpty()) {
                    map.remove(string2);
                    continue;
                }
                String string4 = string2.substring(SLCT_LEN);
                if (string4 != null && string4.length() > 0) {
                    this.editSelMap.put(string4, string3);
                }
            }
            if (!string2.startsWith(NAME_KEY)) continue;
            string3 = map.get(string2);
            if (string3 == null || string3.isEmpty()) {
                map.remove(string2);
                continue;
            }
            int n = string2.lastIndexOf(string3) - 1;
            if (n < 0) {
                map.remove(string2);
                continue;
            }
            String string5 = string2.substring(NAME_LEN, n);
            if (string5 == null || string5.length() <= 0) continue;
            String[] stringArray2 = DBEditConfig.getEditKeys(string5, string3);
            String[] stringArray3 = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray3[i] = map.get(stringArray2[i]);
            }
            this.editConfigMap.computeIfAbsent(string5, string -> new HashMap()).put(string3, new DBEditConfig(stringArray3));
        }
    }

    public void addEditConfig(String string2, String string3, DBEditConfig dBEditConfig) {
        if (string2 != null && string3 != null && dBEditConfig != null) {
            Map map = this.editConfigMap.computeIfAbsent(string2, string -> new HashMap());
            DBEditConfig dBEditConfig2 = (DBEditConfig)map.get(string3);
            if (dBEditConfig2 != null && dBEditConfig2.isCommon() != dBEditConfig.isCommon()) {
                throw new HybsSystemException("\u500b\u5225\u8a2d\u5b9a\u3068\u5171\u901a\u8a2d\u5b9a\u306f\u3001\u540c\u3058\u30ad\u30fc\u3067\u306f\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            map.put(string3, dBEditConfig);
        }
    }

    public DBEditConfig deleteEditConfig(String string, String string2) {
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            return null;
        }
        Map map = (Map)this.editConfigMap.get(string);
        return map == null ? null : (DBEditConfig)map.remove(string2);
    }

    public DBEditConfig getEditConfig(String string, String string2) {
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            return null;
        }
        Map map = (Map)this.editConfigMap.get(string);
        return map == null ? null : (DBEditConfig)map.get(string2);
    }

    public DBEditConfig[] getEditConfigs(String string) {
        if (string == null || string.isEmpty()) {
            return new DBEditConfig[0];
        }
        Map map = (Map)this.editConfigMap.get(string);
        if (map == null) {
            return new DBEditConfig[0];
        }
        DBEditConfig[] dBEditConfigArray = map.values().toArray(new DBEditConfig[map.size()]);
        Arrays.sort(dBEditConfigArray, new EditConfigComparator());
        return dBEditConfigArray;
    }

    public String getSelectedEdit(String string) {
        return (String)this.editSelMap.get(SLCT_KEY + string);
    }

    private static final class EditConfigComparator
    implements Comparator<DBEditConfig>,
    Serializable {
        private static final long serialVersionUID = 602520141024L;

        private EditConfigComparator() {
        }

        @Override
        public int compare(DBEditConfig dBEditConfig, DBEditConfig dBEditConfig2) {
            return dBEditConfig == null ? -1 : dBEditConfig.getEditName().compareTo(dBEditConfig2.getEditName());
        }
    }
}

