$(function(){
  /*================================================
    ファイルをドロップした時の処理
  =================================================*/
  $('#drag-area').bind('drop', function(e){
    // デフォルトの挙動を停止
    e.preventDefault();
 
    // ファイル情報を取得
    var files = e.originalEvent.dataTransfer.files;
 
    uploadFiles(files);
 
  }).bind('dragenter', function(){
    // デフォルトの挙動を停止
    return false;
  }).bind('dragover', function(){
    // デフォルトの挙動を停止
    return false;
  });
 
  /*================================================
    ダミーボタンを押した時の処理
  =================================================*/
  $('#uploadbtn').click(function() {
    // ダミーボタンとinput[type="file"]を連動
    $('.btn-group input[type="file"]').click().change();
    return false;
  });

  $('.btn-group input[type="file"]').change(function(){
    // ファイル情報を取得
    var files = this.files;
    
    //alert(this.files[0].name);
 	
 	if( typeof FormData == 'function'){
	    uploadFiles(files);
	}
  });
  
  // 互換性対応
  if( typeof FormData != 'function'){
	$('#uploadbtn').css('display','none');
	$('#uploaddrop').css('display','none');
	$('#uploadinput').css('display','inline');
	$('#uploadsubmit').css('display','inline');
  }
  else{
  }
 
});
 
/*================================================
  アップロード処理
=================================================*/
function uploadFiles(files) {
 if( ! files[0]){
 	return;
 }

  // FormDataオブジェクトを用意
  var fd = new FormData();
 
  // ファイルの個数を取得
  var filesLength = files.length;
 
  // ファイル情報を追加
  for (var i = 0; i < filesLength; i++) {
    fd.append("FILE_01", files[i]);
  }
 
  // Ajaxでアップロード処理をするファイルへ内容渡す
  // multipartのboundaryの問題があるのでIE及びEdgeのみの対応となる。
  // contentTypeをfalseにしてもうまく動作しないため
  $.ajax({
    url: 'upload.jsp',
    type: 'POST',
    data: fd,
    processData: false,
    contentType: "multipart/form-data",
    success: function(data) {
      console.log('file uploade success.');
      console.log(data);
       $('#uploadinfo').append('<br/>' + data + ' upload.' );
    },
    error: function(data,err) {
      console.log('file uploade error.');
      console.log(data.responseText + "/"  + err);
      $('#uploadinfo').append(data.responseText);
    },
    xhr: function() {
            var xhr = new window.XMLHttpRequest();
            // アップロードの進捗状況を取得
            xhr.upload.addEventListener("progress", function(event) {
                if (event.lengthComputable) {
                    $('#status').html('<progress max="100" value="'+ parseInt(parseInt((event.loaded / event.total) * 100)) + '" />'+ parseInt(parseInt((event.loaded / event.total) * 100)) +'%');
                }
            }, false);
            // 中止の際に何かしたい場合
            xhr.addEventListener("abort", function(event) {
            }, false);
            return xhr;
        }
  });
}
