<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" adjustEvent="Gantt" />	<!-- 積上げ処理 -->

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7217"
	title	= "積上げガント"
	date	= "2012/09/17"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>
<!--製番未入力の場合 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT	 PN
			,NOORDER
			,SUORDER
			,DYORDER
			,DYNOKI
			,MOD(ROWNUM ,10)		as COLOR
			,ROWNUM*0.4+0.6 		as COSTCLM
			,1						as CAPACITY
	FROM GF45
	<og:where>
		<og:and value="NOORDER = '{@NOORDER}'" />
		<og:and value="DYORDER IS NOT NULL" />
	</og:where>
	ORDER BY NOORDER,PN
</og:query>

<og:view
	viewFormType = "HTMLStackedGanttTable"
	command		 = "{@command}"
	writable	 = "false"
	useScrollBar = "false"
	useParam	 = "true"
	numberType = "none"
>
<!-- stackParamでstackColumnsを指定しなかった場合はcustomTableとほぼ同じ処理となる -->
<og:stackParam
	stackColumns = "NOORDER"
/>
<og:thead rowspan="2">
	<tr>
		<td>[NOORDER]</td>
		<td>[PN]</td>
		<td rowspan="2" class="gantt zoom{@SZOOM}" style="text-align:left;background-image: url('../image/stackBG{@SZOOM}.gif');" >
			<div style="position:relative;left:0px;z-index:101; " height="100%" width="100%" >
				<og:ganttHeader
					startDate	= "{@startDate}"
					endDate		= "{@endDate}"
					zoom		= "{@SZOOM}"
					calDB		= "GF13"
					arg1		= "A"
				/>
			</div>
		</td>
	</tr>
</og:thead>
<og:tbody rowspan="2">
	<tr>
		<td>[NOORDER]</td>
		<td>[PN]</td>
		<td rowspan="2" class="gantt zoom{@SZOOM}" style="text-align:left;background-image: url('../image/stackBG{@SZOOM}.gif');" >
			<og:iGanttBar type="1" colorNo="[COLOR]" start="[DYORDER]" end="[DYNOKI]"  text="[COSTCLM]"
					  		cost="[COSTCLM]" capacity="[CAPACITY]" />
			<og:iGanttBar type="0" src="../image/dia_blue.gif" start="[DYORDER]"	   text="開始"  />
		</td>
	</tr>
</og:tbody>
</og:view>

	<og:iGantt
		margeRows		= "true"
		fixedCols		= "5"
		verticalShift	= "false"
		viewGantt		= "{@viewGantt}"
		stackHoliday	= "{@stackHoliday}"
		useBgColor		= "true"
		viewMode		= "2"
	/>

<!-- ガント描画の利用方法 
	【属性説明】
		type		: ガント要素のタイプ
		color		: バーの色
		start	 	: 開始日(YYYYMMDD)、または開始時間(YYYYMMDDHH24MM)
		end			: 終了日(YYYYMMDD)、または終了時間(YYYYMMDDHH24MM)
						指定しない場合はstartの翌月１日が終了日となります。
		cost		: 工数（積上げられる工数です）
		text		: ガント要素の注釈メッセージ
		capacity	: 行単位の能力（担当能力）
		href		: textにリンクを貼る時の遷移先
		target		: hrefの遷移target(初期値：CONTENTS)
	【使用例】
		<iGanttBar 
			type		= "1" 
			color		= "[COLOR]" 
			start		= "[DYORDER]" 
			end			= "[DYNOKI]" 
			text		= "[PN]"
			cost		= "[COSTCLM]"
			capacity	= "[CAPACITY]"
			href		= "../遷移先画面ID/index.jsp?command={@command}&amp;BACK_GAMENID=自身の画面ID" 
			target		= "CONTENTS"
		/>
-->
<!--ガント全体の属性設定（タグ必須）
	【属性説明】
		margeRows		: 複数行のマージ、前後の行データが一致している場合はマージする。
		fixedCols		: 左の固定列の列数（テーブル２分割機能）
		viewNumberType 	: viewタグの出力に番号列が出力されるか(出力されていない場合:delete)
		verticalShift	: ガントの上下ずらし表示
		viewGantt		: ガントの表示を行うかどうか(初期値=true:表示する)
		stackHoliday	: 休日に積上げるかどうか（zoom=DAYの場合のみ有効。初期値=true:積上げる)
		useBgColor		: 一覧の背景色の縞々模様を再作成するか（margeRows='true'の場合は使用する）
		viewMode		: 1:行の最大値を基準に積上げ高さの計算を行う。0:能力設定値を基準に積上げ高さの計算を行う。
	【使用例】
		<iGantt 
			margeRows	= "true"
			fixedCols	= "5"
			verticalShift	= "false"
			viewGantt 		= "false"
			stackHoliday	= "false"
			useBgColor		= "true"
			viewMode		= "1"
		/>
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
