/*
 * showModalDialogを上書きして、IE限定のshowModalDialogではなく、独自実装のダイアログを表示します。
 * 内部でIframeを作成し、その中にURLの内容を表示します。
 * JSP内でこの.jsとhtml5modalDialog.cssを読み込む事で、エンジンのポップアップは自動的にこのタイプに変更されます。
 * コントロール可能な最上位フレームにiframeを作成し、表示します。
 * クロスドメインの小さなフレーム内で利用した場合はフレーム内に内容が表示しきれず、スクロールが必要になります。
 * ポップアップ内の閉じるボタンが存在する場合は、Windowを閉じてしまうため注意が必要です。
 *
 * 元：https://github.com/Mehuge/showModalDialog/tree/master/showModalDialog
 * PromiseがIEで利用できない事と、jQuery1.4対応、エンジンとの互換性の変更を行っています。
 *
 *
 * [Options]
 * width,height,left,top,closeIcon
 *
 * @og.rev 5.8.9.0 (2015/08/07) Takahashi Masakazu & oota
 * @og.rev 5.9.1.3 (2015/10/30) 出来る限り上位フレームで表示する、URLを絶対パス変換してから利用する
*/
function showModalDialog(tgturl, args, options, p_this,p_out_Array,p_append) {
    options = options || {};
    var closeIcon = options.closeIcon || '../image/close.gif';
    // 絶対パスに変換
    closeIcon = absolutePath( closeIcon );
    tgturl = absolutePath( tgturl );
    
    var rtn;
    var tgt_frame= frame_check(window); // 5.9.1.3
    tgt_frame.popParent = window;
    
    $.ajax({
    	url:tgturl
    	,success:function (r) {
	        var cover = $('<div>')
	            .addClass('popcover')
//	            .appendTo(document.body);
	            .appendTo( tgt_frame );
	        var close = function () {
	                iframe.remove();
	                content.remove();
	                cover.remove();
	            };
	        var content = $('<div>')
	            .addClass('popdialog')
	            .css({
	                width: options.width || '85%',
	                height: options.height || '85%',
	                left: options.left || '5%',
	                top: options.top || '5%',
	                display: 'none'
	            })
//	            .appendTo(document.body);
	            .appendTo( tgt_frame );
	            
	        var iframe = $('<iframe>').appendTo(content).attr("src", tgturl)
	            .bind("load", function () {
	                content.css({ display: 'block' });
	            });
	            
	        var closeButton= $('<div>')
	        	.addClass('closeButton')
	            .css({ width: '100%', left: '0px', top: '0px' })
	        	.appendTo(cover)
	        	.bind("click",function(){
	            	close();
	            })
	            .append('<img src="'+closeIcon+'" style="left:' +content.css("left")+ ';"/>');
	        showModalDialog.dialogArguments = args;
	        // ポップアップ先からCallされる
	        showModalDialog.returnValue = function (v) {
	            close();
				ogPchangeData(v,p_this,p_out_Array,p_append); // 独自関数
	        };
	        showModalDialog.cancel = function () {
	            close();
	        };
   		}
    });
}

// コントロール可能な上位フレームを探して返す 5.9.1.3 (2015/10/30)
// 該当最上位フレーム(通常はindex.jsp)にjQueryとcssが必要
function frame_check(_tgtwindow){
	// 上位フレーム無しの場合
	if(_tgtwindow.parent.document.URL == _tgtwindow.document.URL){
		return _tgtwindow.document.body ;
	}
	//それ以外の場合はコントロール可能な親フレームを返す
	// 親フレームがコントロール可能な場合は再帰処理。try-cathcで判定しておく
	try{
		var ck = $(_tgtwindow.parent.document.body); // 読める場合はコントロール可能なはず
		var rtn = frame_check(_tgtwindow.parent);
		// frameの場合と、既にpopcoverが存在する場合はNG
		if( rtn.getElementsByTagName('frame').length > 0 ){
			return _tgtwindow.document.body
		}
		else if ( $(rtn).find('.popcover').length > 0 ){
			return _tgtwindow.document.body
		}
		else{
			return rtn;
		}
	}
	catch(e){
		return _tgtwindow.document.body ;
	}
	return _tgtwindow.document.body ;
}

// 絶対パスに変換
function absolutePath(path) {
    var e = document.createElement('span');
    e.innerHTML = '<a href="' + path + '" />';
    return e.firstChild.href;
}

// ogPopupのshowDialog呼出し以降の処理をそのまま別ﾒｿｯﾄﾞ化
function ogPchangeData(ret_val, p_this,p_out_Array, p_append){
	var	_oldTmpVal;
	// 戻り値が文字列の場合は、配列に変換
	if( ( ret_val != null ) && ( typeof ret_val !== "object" ) ){
		ret_val = new Array( ret_val );
	}

	// 5.5.3.0 changeイベントを起こすオブジェクトを保存しておいて、後からキックする
	var changes_obj = new Array();

	// 5.8.3.0, 5.8.3.1
	// 出力引数に、ポップアップからの戻り値を設定
	if( ret_val != null && p_out_Array != null ) {
		for( j=0; ( j<p_out_Array.length && j<ret_val.length ) ; j++ ) {
			if( p_out_Array[j] != '' ) {
				tmp = p_this.form.elements[p_out_Array[j]];
				if( tmp != null ) {
					// ヘッダー固定のBulkSet対応
					if( p_out_Array[j].indexOf( "h_" ) == 0 && tmp.length ) {
						for( var k=0; k<tmp.length; k++) {
							_oldTmpVal = tmp[k].value;

							if( p_append == "true" ){ // 5.8.5.0 (2015/02/16)
								var caret_position = getCaretPositionIE(tmp[k]);
								tmp[k].value = tmp[k].value.substring(0,caret_position) + ret_val[j] + tmp[k].value.substring(caret_position,tmp[k].value.length); 
							}
							else{
								tmp[k].value = ret_val[j];
							}
							// 4.3.6.2 (2009/04/15) 異なる値をセットした場合にChangeイベントを発生させる。
							if( _oldTmpVal != ret_val[j] ){
								changes_obj[changes_obj.length] = tmp[k];
							}
						}
					}
					else {
						_oldTmpVal = tmp.value;

						if( p_append == "true" ){ // 5.8.5.0 (2015/02/16)
							var caret_position = getCaretPositionIE(tmp);
							tmp.value = tmp.value.substring(0,caret_position) + ret_val[j] + tmp.value.substring(caret_position,tmp.value.length); 
						}
						else{
							tmp.value = ret_val[j];
						}
						// 4.3.6.2 (2009/04/15) 異なる値をセットした場合にChangeイベントを発生させる。
						if( _oldTmpVal != ret_val[j] ){
							changes_obj[changes_obj.length] = tmp;
						}
					}
				}
			}
		}
	}
	// 5.5.3.0
	for( i=0; i<changes_obj.length; i++){
		$(changes_obj[i]).change();
	}
		
	// 5.5.1.5 (2012/04/12) 先頭が_RENEWの場合は[1]をRENEW付きでcall
	if( ret_val != null && ret_val[0] == '_RENEW' ){
		if(ret_val[1].indexOf('?') > 0 ){
			location.href=ret_val[1]+'&command=RENEW';
		}
		else{
			location.href=ret_val[1]+'?command=RENEW';
		}
	}
}

// defaultの上書き
// @og.rev 5.9.1.3 (2015/10/30) 上位フレーム表示対応
// @og.rev 5.9.4.3 (2016/001/15) 返せない場合、一段階までは親を見るように変更
function rtnPopup( rtnValue ) {
	window.returnValue = rtnValue;
	//parent.showModalDialog.returnValue(rtnValue);
	if(parent.document.body.popParent){
		parent.document.body.popParent.showModalDialog.returnValue(rtnValue); // 5.9.1.3
	}
	else if(parent.parent.document.body.popParent){
		parent.parent.document.body.popParent.showModalDialog.returnValue(rtnValue);
	}
}

// defaultの上書き 
function ogPopup( p_pgid,p_height,p_width,p_in_Array,p_this,p_out_Array,command,p_append,event ) {
	var height , width , url , sTmp , param , ret_val , tmp , i , j , _oldTmpVal ;
	// 5.8.5.0 (2015/02//6) キャレットの位置を取得
	var getCaretPositionIE = function( elem ){
		elem.focus();
		var range = document.selection.createRange();
		range.moveStart( "character", - elem.value.length );
		var caret_position = range.text.length;
		return caret_position;
	}

	if( p_height != null ) { height = p_height; }
	if( p_width  != null ) { width	= p_width;	}
	
	// 5.8.3.0 (2014/01/09) height,width の "px" 処理の修正
	height = p_height ? parseInt(p_height, 10) + "px" : "85%" ;
	width  = p_width  ? parseInt(p_width , 10) + "px" : "85%" ;

	// ポップアップ画面定義
	url  =	p_pgid + "?command=" + ( command ? command : "NEW" );
//	sTmp = 'resizable:on; dialogHeight:' + height + ';dialogWidth:' + width;		// 5.7.5.0 (2014/04/04)
	sTmp = {};
	sTmp.height = height;
	sTmp.width  = width;
	
	if( event ) {
//		sTmp = sTmp + ';dialogLeft:' + event.screenX + 'px;' + 'dialogTop:' + event.screenY + 'px';
		sTmp.left = event.screenX + 'px';
		sTmp.top = event.screenY + 'px';
	}

	// 入力引数の設定
	if( p_in_Array != null ) {
		for( i=0; i<p_in_Array.length; i+=2 ) {
			url = url + "&" + p_in_Array[i] + "=" + encodeURIComponent( p_in_Array[i+1]);  // 5.2.0.0 (2010/09/01)
		}
	}

	// ポップアップ画面
	param = "";
	if( ( p_out_Array != null ) && ( document.getElementById( p_out_Array[0] ) ) ){
		param = document.getElementById( p_out_Array[0] ).value;
	}
	// oota modify 引数を変更
	// ret_val = showModalDialog( url,param,sTmp);
	ret_val = showModalDialog( url,param,sTmp ,p_this,p_out_Array,p_append );

	// 以降の処理をshowModalDialogとして別ﾒｿｯﾄﾞ化
}
