/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.jdbc.JDBCPieDataset;
import org.jfree.data.jdbc.JDBCXYDataset;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.ChartPlot;
import org.opengion.hayabusa.io.HybsCategoryDataset;
import org.opengion.hayabusa.io.HybsTaskSeriesCollection;
import org.opengion.hayabusa.io.HybsTimeSeriesCollection;
import org.opengion.hayabusa.io.TypeRenderer;

public final class ChartFactory {
    private static final String PLOT_SUB = "org.opengion.hayabusa.io.ChartPlot_";
    private static volatile ChartPlot plot_cat = null;
    private static volatile ChartPlot plot_xy = null;
    private static volatile ChartPlot plot_pie = null;
    private static volatile ChartPlot plot_tim = null;
    private static volatile ChartPlot plot_xtim = null;
    private static final Object lock = new Object();
    private static final Map<String, TypeRenderer> TYPE_RENDERER_MAP = new HashMap<String, TypeRenderer>();

    private ChartFactory() {
    }

    public static Dataset newDataset(Connection connection, String string, String string2) throws SQLException {
        Object object;
        TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(string2);
        String string3 = typeRenderer.getDatasetType();
        boolean bl = "ParetoCategory".equalsIgnoreCase(string3);
        if ("Category".equalsIgnoreCase(string3) || bl) {
            HybsCategoryDataset hybsCategoryDataset = new HybsCategoryDataset();
            hybsCategoryDataset.initParam(null, false, false);
            hybsCategoryDataset.execute(connection, string);
            object = hybsCategoryDataset;
        } else if ("XY".equalsIgnoreCase(string3)) {
            object = new JDBCXYDataset(connection, string);
        } else if ("Pie".equalsIgnoreCase(string3)) {
            object = new JDBCPieDataset(connection, string);
        } else if ("Value".equalsIgnoreCase(string3)) {
            object = new DefaultValueDataset();
        } else if ("TimeSeries".equalsIgnoreCase(string3)) {
            object = new HybsTimeSeriesCollection(string2);
            ((HybsTimeSeriesCollection)((Object)object)).executeQuery(connection, string);
        } else if ("TaskSeries".equalsIgnoreCase(string3)) {
            object = new HybsTaskSeriesCollection();
            ((HybsTaskSeriesCollection)((Object)object)).executeQuery(connection, string);
        } else {
            String string4 = "Category,Pie,XY,Value,TimeSeries \u4ee5\u5916\u306eDataset \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string3 + "]";
            throw new HybsSystemException(string4);
        }
        return object;
    }

    public static Dataset newDataset(DBTableModel dBTableModel, String string) {
        Object object;
        TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(string);
        int n = dBTableModel.getColumnCount();
        int n2 = dBTableModel.getRowCount();
        String string2 = typeRenderer.getDatasetType();
        if ("Category".equalsIgnoreCase(string2)) {
            String[] stringArray = dBTableModel.getNames();
            HybsCategoryDataset hybsCategoryDataset = new HybsCategoryDataset();
            hybsCategoryDataset.initParam(stringArray, false, false);
            hybsCategoryDataset.execute(dBTableModel);
            object = hybsCategoryDataset;
        } else if ("XY".equalsIgnoreCase(string2)) {
            CategoryTableXYDataset categoryTableXYDataset = new CategoryTableXYDataset();
            String[] stringArray = dBTableModel.getNames();
            for (int i = 0; i < n2; ++i) {
                String[] stringArray2 = (String[])dBTableModel.getValues(i);
                double d = stringArray2[0] == null || stringArray2[0].length() == 0 ? 0.0 : Double.parseDouble(stringArray2[0]);
                for (int j = 1; j < n; ++j) {
                    String string3 = stringArray2[j];
                    double d2 = string3 == null || string3.length() == 0 ? 0.0 : Double.parseDouble(string3);
                    categoryTableXYDataset.add(d, d2, stringArray[j]);
                }
            }
            object = categoryTableXYDataset;
        } else if ("Pie".equalsIgnoreCase(string2)) {
            DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
            for (int i = 0; i < n2; ++i) {
                String[] stringArray = (String[])dBTableModel.getValues(i);
                String string4 = stringArray[0];
                String string5 = stringArray[1];
                double d = string5 == null || string5.length() == 0 ? 0.0 : Double.parseDouble(string5);
                defaultKeyedValues.addValue((Comparable)((Object)string4), d);
            }
            object = new DefaultPieDataset((KeyedValues)defaultKeyedValues);
        } else if ("Value".equalsIgnoreCase(string2)) {
            object = new DefaultValueDataset();
        } else {
            String string6 = "Category,Pie,XY,Value \u4ee5\u5916\u306eDataset \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string2 + "]";
            throw new HybsSystemException(string6);
        }
        return object;
    }

    public static TypeRenderer getTypeRenderer(String string) {
        TypeRenderer typeRenderer = TYPE_RENDERER_MAP.get(string);
        if (typeRenderer == null) {
            String string2 = "\u6307\u5b9a\u306e\u30bf\u30a4\u30d7\u306b\u8a72\u5f53\u3059\u308b Renderer \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string + "]" + HybsSystem.CR + "Key=" + Arrays.toString(TYPE_RENDERER_MAP.keySet().toArray(new String[TYPE_RENDERER_MAP.size()]));
            throw new HybsSystemException(string2);
        }
        return typeRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChartPlot newChartPlot(String string) {
        ChartPlot chartPlot;
        TypeRenderer typeRenderer = TYPE_RENDERER_MAP.get(string);
        String string2 = typeRenderer.getPlotType();
        if ("Category".equalsIgnoreCase(string2)) {
            Object object = lock;
            synchronized (object) {
                if (plot_cat == null) {
                    plot_cat = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_cat;
        } else if ("XY".equalsIgnoreCase(string2)) {
            Object object = lock;
            synchronized (object) {
                if (plot_xy == null) {
                    plot_xy = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_xy;
        } else if ("Time".equalsIgnoreCase(string2)) {
            Object object = lock;
            synchronized (object) {
                if (plot_tim == null) {
                    plot_tim = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_tim;
        } else if ("XYTime".equalsIgnoreCase(string2)) {
            Object object = lock;
            synchronized (object) {
                if (plot_xtim == null) {
                    plot_xtim = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_xtim;
        } else {
            Object object = lock;
            synchronized (object) {
                if (plot_pie == null) {
                    plot_pie = (ChartPlot)StringUtil.newInstance((String)"org.opengion.hayabusa.io.ChartPlot_Pie");
                }
            }
            chartPlot = plot_pie;
        }
        return chartPlot;
    }

    static {
        String[][] stringArrayArray = new String[][]{{"HybsLine", "HybsLineRenderer", "Category", "Category"}, {"LineAndShape", "category.LineAndShapeRenderer", "Category", "Category"}, {"Line3D", "category.LineRenderer3D", "Category", "Category"}, {"StatisticalLineAndShape", "category.StatisticalLineAndShapeRenderer", "Category", "Category"}, {"HybsBar", "HybsBarRenderer", "Category", "Category"}, {"Bar", "category.BarRenderer", "Category", "Category"}, {"Bar3D", "category.BarRenderer3D", "Category", "Category"}, {"Area", "category.AreaRenderer", "Category", "Category"}, {"HybsStackedBar", "HybsStackedBarRenderer", "Category", "Category"}, {"StackedBar", "category.StackedBarRenderer", "Category", "Category"}, {"StackedBar3D", "category.StackedBarRenderer3D", "Category", "Category"}, {"StackedArea", "category.StackedAreaRenderer", "Category", "Category"}, {"GroupedStackedBar", "category.GroupedStackedBarRenderer", "Category", "Category"}, {"LayeredBar", "category.LayeredBarRenderer", "Category", "Category"}, {"CategoryStep", "category.CategoryStepRenderer", "Category", "Category"}, {"Level", "category.LevelRenderer", "Category", "Category"}, {"MinMax", "category.MinMaxCategoryRenderer", "Category", "Category"}, {"WaterfallBar", "category.WaterfallBarRenderer", "Category", "Category"}, {"MultiplePie", null, "Category", "MultiplePie"}, {"SpiderWeb", null, "Category", "SpiderWeb"}, {"Pie", null, "Pie", "Pie"}, {"Pie3D", null, "Pie", "Pie"}, {"Ring", null, "Pie", "Ring"}, {"XYArea", "xy.XYAreaRenderer", "XY", "XY"}, {"XYArea2", "xy.XYAreaRenderer2", "XY", "XY"}, {"XYBlock", "xy.XYBlockRenderer", "XY", "XY"}, {"CyclicXYItem", "xy.CyclicXYItemRenderer", "XY", "XY"}, {"HighLow", "xy.HighLowRenderer", "XY", "XY"}, {"StackedXYArea", "xy.StackedXYAreaRenderer", "XY", "XY"}, {"StackedXYArea2", "xy.StackedXYAreaRenderer2", "XY", "XY"}, {"StandardXYItem", "xy.StandardXYItemRenderer", "XY", "XY"}, {"XYBubble", "xy.XYBubbleRenderer", "XY", "XY"}, {"XYDifference", "xy.XYDifferenceRenderer", "XY", "XY"}, {"XYDot", "xy.XYDotRenderer", "XY", "XY"}, {"XYError", "xy.XYErrorRenderer", "XY", "XY"}, {"XYLine3D", "xy.XYLine3DRenderer", "XY", "XY"}, {"XYLineAndShape", "xy.XYLineAndShapeRenderer", "XY", "XY"}, {"XYStepArea", "xy.XYStepAreaRenderer", "XY", "XY"}, {"XYStep", "xy.XYStepRenderer", "XY", "XY"}, {"PolarItem", "DefaultPolarItemRenderer", "XY", "Polar"}, {"Meter", null, "Value", "Meter"}, {"Thermometer", null, "Value", "Thermometer"}, {"Compass", null, "Value", "Compass"}, {"Gantt", "category.GanttRenderer", "TaskSeries", "Time"}, {"XYBarV", "xy.XYBarRenderer", "TimeSeries", "XYTime"}, {"ClusteredXYBarV", "xy.ClusteredXYBarRenderer", "TimeSeries", "XYTime"}, {"YIntervalV", "xy.YIntervalRenderer", "TimeSeries", "XYTime"}, {"DeviationV", "xy.DeviationRenderer", "TimeSeries", "XYTime"}, {"TimeSeriesBarV", "xy.XYBarRenderer", "TimeSeries", "XYTime"}, {"TimeSeriesBarH", "xy.XYBarRenderer", "TimeSeries", "XYTime"}, {"TimeSeriesLineV", "xy.StandardXYItemRenderer", "TimeSeries", "XYTime"}, {"TimeSeriesLineH", "xy.StandardXYItemRenderer", "TimeSeries", "XYTime"}, {"StackedTimeSeriesLineV", "xy.StandardXYItemRenderer", "TimeSeries", "XYTime"}, {"StackedTimeSeriesLineH", "xy.StandardXYItemRenderer", "TimeSeries", "XYTime"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            TYPE_RENDERER_MAP.put(stringArrayArray[i][0], new TypeRenderer(stringArrayArray[i][0], stringArrayArray[i][1], stringArrayArray[i][2], stringArrayArray[i][3]));
        }
    }
}

