/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * JSON出力用のパラメータ定数定義クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public static final で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.rev 5.9.7.0 (2016/04/01) 新規作成
 *
 * @version  5.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public class ViewJsonParam {
	public static final String JSON_INFO_KEY		= "h_jsoninfo" ;
	public static final String JSON_HEAD_KEY		= "h_jsonhead" ;
	public static final String JSON_RENDERER_KEY		= "h_jsonrnd" ;
	public static final String JSON_DATANAME_KEY		= "h_jsondname" ;
	public static final String JSON_UTF_ENCODE		= "h_jsonutfencode" ;
	
	/** パラメータ初期値:{@value} */
	public static final String USE_JSON_INFO	= "true" ;
	/** パラメータ初期値:{@value} */
	public static final String USE_JSON_HEAD	= "true" ;		
	/** パラメータ初期値:{@value} */
	public static final String USE_JSON_RENDERER	= "false" ;	
	/** パラメータ初期値:{@value} */
	public static final String USE_JSON_UTFENC	= "false" ;	
	/** パラメータ初期値:{@value} */
	public static final String JSON_DATANAME	= "DATA" ;	
}
