/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.util.StringFormat;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public class DBEventColumn {
    private static final String EVENT_COLUMN_URL = HybsSystem.sys("JSP") + "/" + HybsSystem.sys("EVENT_COLUMN_URL");
    private final String name;
    private final String eventColumn;
    private final String eventValue;
    private final String eventUrl;
    private final String renderer;
    private final String editor;
    private final String rendParam;
    private final String editParam;
    private final String valParam;

    public DBEventColumn(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.name = string;
        this.eventColumn = string2;
        this.eventValue = string3;
        this.eventUrl = string4 != null && string4.length() > 0 ? string4 : EVENT_COLUMN_URL;
        this.renderer = string5;
        this.editor = string6;
        this.rendParam = string7;
        this.editParam = string8;
        this.valParam = "{@" + this.evColReplace(string2).replace(",", "}:{@") + "}";
    }

    public String getName() {
        return this.name;
    }

    public String getEventColumn() {
        return this.eventColumn;
    }

    public String getEventURL() {
        return this.eventUrl;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getRendParam() {
        StringFormat stringFormat = new StringFormat(this.rendParam, this.valParam, this.name);
        return stringFormat.format();
    }

    public String getEditParam() {
        StringFormat stringFormat = new StringFormat(this.editParam, this.valParam, this.name);
        return stringFormat.format();
    }

    public String getEventValue() {
        StringFormat stringFormat = new StringFormat(this.eventValue, this.valParam, this.name);
        return stringFormat.format();
    }

    private String evColReplace(String string) {
        String[] stringArray = string != null && string.indexOf(44) >= 0 ? StringUtil.csv2Array((String)string, (char)',') : new String[]{string};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) != '_') continue;
            stringArray[i] = stringArray[i].substring(1);
        }
        return StringUtil.array2csv((String[])stringArray);
    }
}

