/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.RoleMode;

public final class GUIData {
    public static final int GUIKEY = 0;
    public static final int GUILVL = 1;
    public static final int LABEL_CLM = 2;
    public static final int ADDRESS = 3;
    public static final int SEQNO = 4;
    public static final int GROUPS = 5;
    public static final int CLASSIFY = 6;
    public static final int ROLES = 7;
    public static final int RWMODE = 8;
    public static final int TARGET = 9;
    public static final int PARAM = 10;
    public static final int KBLINK = 11;
    public static final int DYUPD = 12;
    private final String guiKey;
    private final int guiLevel;
    private final String lblClm;
    private final String address;
    private final String realAddress;
    private final int seqno;
    private final String groups;
    private final String classify;
    private final String target;
    private final String param;
    private final String kblink;
    private final boolean pageUse;
    private final RoleMode roleMode;
    private final String dyupd;
    private final String imageKey;
    private static final String CON_DIR = "/" + HybsSystem.getContextName() + "/";

    GUIData(String[] stringArray) {
        this.guiKey = stringArray[0].intern();
        this.guiLevel = Integer.parseInt(stringArray[1]);
        this.lblClm = StringUtil.nval2((String)stringArray[2], (String)this.guiKey);
        this.address = stringArray[3].intern();
        this.seqno = Integer.parseInt(stringArray[4]);
        this.groups = StringUtil.nval2((String)stringArray[5], null);
        this.classify = StringUtil.nval2((String)stringArray[6], (String)"");
        this.target = StringUtil.nval2((String)stringArray[9], null);
        if (this.address.startsWith("http://") || this.address.startsWith("https://") || StringUtil.startsChar((CharSequence)this.address, (char)'.')) {
            this.pageUse = false;
            this.kblink = "http";
            this.realAddress = this.address;
        } else if (StringUtil.startsChar((CharSequence)this.address, (char)'/')) {
            this.pageUse = false;
            this.kblink = "/";
            this.realAddress = this.address;
        } else {
            this.pageUse = true;
            this.kblink = "jsp";
            this.realAddress = CON_DIR + "jsp/" + this.address + "/";
        }
        String string = stringArray[10];
        this.param = string != null && string.length() > 0 ? string.intern() : "";
        this.imageKey = StringUtil.nval2((String)stringArray[11], (String)this.guiKey);
        String string2 = stringArray[7];
        if ("root".equals(string2)) {
            string2 = "r00t";
        }
        this.roleMode = RoleMode.newInstance(string2, stringArray[8]);
        this.dyupd = StringUtil.nval2((String)stringArray[12], (String)"");
    }

    public String getGuiKey() {
        return this.guiKey;
    }

    public int getGuiLevel() {
        return this.guiLevel;
    }

    public String getLabelClm() {
        return this.lblClm;
    }

    public String getAddress() {
        return this.address;
    }

    public String getRealAddress() {
        return this.realAddress;
    }

    public String getRealAddress(String string) {
        return !this.pageUse || string == null ? this.realAddress : this.realAddress + string;
    }

    public int getSeqno() {
        return this.seqno;
    }

    public String getGroups() {
        return this.groups;
    }

    public String getClassify() {
        return this.classify;
    }

    public String getRoles() {
        return this.roleMode.getRoles();
    }

    public String getMode() {
        return this.roleMode.getMode();
    }

    public RoleMode getRoleMode() {
        return this.roleMode;
    }

    public String getTarget() {
        return this.target;
    }

    public String getParam() {
        return this.param;
    }

    public String getKblink() {
        return this.kblink;
    }

    public String getDyupd() {
        return this.dyupd;
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("guiKey     :").append(this.guiKey).append(HybsConst.CR).append("guiLevel   :").append(this.guiLevel).append(HybsConst.CR).append("address    :").append(this.address).append(HybsConst.CR).append("realAddress:").append(this.realAddress).append(HybsConst.CR).append("seqno      :").append(this.seqno).append(HybsConst.CR).append("classify   :").append(this.classify).append(HybsConst.CR).append("roles      :").append(this.getRoles()).append(HybsConst.CR).append("mode       :").append(this.getMode()).append(HybsConst.CR).append("target     :").append(this.target).append(HybsConst.CR).append("param      :").append(this.param).append(HybsConst.CR).append("kblink     :").append(this.kblink).append(HybsConst.CR).append("dyupd      :").append(this.dyupd).append(HybsConst.CR);
        return stringBuilder.toString();
    }
}

