/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.servlet.MultipartRequest;
import org.opengion.hayabusa.servlet.UploadedFile;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class FileUploadTag
extends CommonTagSupport {
    private static final String VERSION = "6.4.2.1 (2016/02/05)";
    private static final long serialVersionUID = 642120160205L;
    public static final String UPLOAD_FILES = "UPLOAD_FILES";
    private static final String[] NAMES = new String[]{"KEY", "VALUE", "ISFILE"};
    private static final String ENCODE = "UTF-8";
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename;
    private int maxPostSize = 0x1E00000;
    private String tableId = "h_tblmdl";
    private String columns;
    private String useBackup;

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.startQueryTransaction(this.tableId);
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        try {
            String string = HybsSystem.url2dir(this.fileURL);
            File file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                String string2 = this.getResource().getLabel("ERR0043") + "[" + string + "]";
                throw new HybsSystemException(string2);
            }
            MultipartRequest multipartRequest = new MultipartRequest(httpServletRequest, string, this.maxPostSize, ENCODE, this.filename, this.useBackup);
            DBTableModel dBTableModel = null;
            dBTableModel = this.columns == null ? this.makeDBTable(multipartRequest) : this.makeDBTableFromClms(multipartRequest);
            if (!this.commitTableObject(this.tableId, dBTableModel)) {
                this.jspPrint("FileUploadTag " + this.getResource().getLabel("ERR0041"));
                return 5;
            }
        }
        catch (IOException iOException) {
            String string = this.getResource().getLabel("ERR0044") + iOException.getMessage() + CR + "(" + this.toString() + CR + "FileURL=" + this.fileURL + ")";
            throw new HybsSystemException(string, iOException);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.maxPostSize = 0x1E00000;
        this.tableId = "h_tblmdl";
        this.filename = null;
        this.columns = null;
        this.useBackup = null;
    }

    private DBTableModel makeDBTable(MultipartRequest multipartRequest) {
        String string;
        String string2;
        Object object;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(NAMES.length);
        for (int i = 0; i < NAMES.length; ++i) {
            object = this.getDBColumn(NAMES[i]);
            dBTableModel.setDBColumn(i, (DBColumn)object);
        }
        object = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        UploadedFile[] uploadedFileArray = multipartRequest.getUploadedFile();
        for (int i = 0; i < uploadedFileArray.length; ++i) {
            String string3 = uploadedFileArray[i].getName();
            string2 = uploadedFileArray[i].getUploadFile().getName();
            arrayList.add(string2);
            String[] stringArray = new String[]{string3, string2, "1"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string3, string2);
            object.add(string3);
            string = string3 + "_ORG";
            string2 = uploadedFileArray[i].getOriginalFileName();
            stringArray = new String[]{string, string2, "2"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string, string2);
        }
        this.setRequestAttribute(UPLOAD_FILES, arrayList);
        String[] stringArray = new String[]{"directory", this.fileURL, "0"};
        dBTableModel.addColumnValues(stringArray);
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray2 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            string2 = stringArray2[i];
            if ("h_rowSel".equals(string2)) {
                this.setRequestAttribute(string2, multipartRequest.getIntParameters(string2));
                continue;
            }
            string = this.getParamVal(string2, multipartRequest);
            stringArray = new String[]{string2, string, "0"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string2, string);
            object.add(string2);
        }
        this.setParameterNames(object.toArray(new String[object.size()]));
        return dBTableModel;
    }

    private DBTableModel makeDBTableFromClms(MultipartRequest multipartRequest) {
        String string;
        Object object;
        Object object2;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        String[] stringArray = this.columns.split(",");
        dBTableModel.init(stringArray.length);
        String[] stringArray2 = new String[stringArray.length];
        UploadedFile[] uploadedFileArray = multipartRequest.getUploadedFile();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            object2 = this.getDBColumn(string2);
            dBTableModel.setDBColumn(i, (DBColumn)object2);
            object = this.getParamVal(string2, multipartRequest);
            if (object == null) {
                for (int j = 0; j < uploadedFileArray.length; ++j) {
                    string = uploadedFileArray[j].getName();
                    if (!string2.equalsIgnoreCase(string)) continue;
                    object = uploadedFileArray[i].getUploadFile().getName();
                    break;
                }
            }
            stringArray2[i] = object == null ? "" : object;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < uploadedFileArray.length; ++i) {
            object2 = uploadedFileArray[i].getName();
            object = new String[stringArray.length];
            System.arraycopy(stringArray2, 0, object, 0, ((String[])object).length);
            String string3 = uploadedFileArray[i].getUploadFile().getName();
            this.setRequestAttribute((String)object2, string3);
            arrayList.add(object2);
            arrayList2.add(string3);
            string = (String)object2 + "_ORG";
            String string4 = uploadedFileArray[i].getOriginalFileName();
            this.setRequestAttribute(string, string4);
            int n = ((String)object2).lastIndexOf(95);
            if (n > 0) {
                String string5 = ((String)object2).substring(0, n);
                String string6 = ((String)object2).substring(n);
                for (int j = 0; j < stringArray.length; ++j) {
                    String string7 = stringArray[j];
                    String string8 = null;
                    String string9 = null;
                    if (string5.equalsIgnoreCase(string7)) {
                        string9 = string3;
                    } else if ((string5 + "_ORG").equalsIgnoreCase(string7)) {
                        string9 = string4;
                    } else if ((string5 + "_NEW").equalsIgnoreCase(string7)) {
                        string8 = (String)object2 + "_NEW";
                        string9 = multipartRequest.getParameter(string8);
                    } else if ((string5 + "_PFX").equalsIgnoreCase(string7)) {
                        string8 = (String)object2 + "_PFX";
                        string9 = multipartRequest.getParameter(string8);
                    } else if ((string5 + "_SFX").equalsIgnoreCase(string7)) {
                        string8 = (String)object2 + "_SFX";
                        string9 = multipartRequest.getParameter(string8);
                    } else {
                        string8 = stringArray[j] + string6;
                        string9 = this.getParamVal(string8, multipartRequest);
                    }
                    if (string9 == null) continue;
                    object[j] = string9;
                }
            }
            dBTableModel.addColumnValues((String[])object);
        }
        this.setRequestAttribute(UPLOAD_FILES, arrayList2);
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray3 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray3.length; ++i) {
            object = stringArray3[i];
            if ("h_rowSel".equals(object)) {
                this.setRequestAttribute((String)object, multipartRequest.getIntParameters((String)object));
                continue;
            }
            String string10 = this.getParamVal((String)object, multipartRequest);
            this.setRequestAttribute((String)object, string10);
            arrayList.add(object);
        }
        this.setParameterNames(arrayList.toArray(new String[arrayList.size()]));
        return dBTableModel;
    }

    private String getParamVal(String string, MultipartRequest multipartRequest) {
        String string2 = multipartRequest.getParameter(string);
        if ("0".equals(string2)) {
            String[] stringArray;
            for (String string3 : stringArray = multipartRequest.getParameters(string)) {
                if (!"1".equals(string3)) continue;
                string2 = "1";
                break;
            }
        }
        return string2;
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 == null) {
            this.chckReqParam(string, "fileURL");
        } else {
            this.fileURL = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setMaxPostSize(String string) {
        this.maxPostSize = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxPostSize);
        this.chckReqParam(string, "maxPostSize");
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
        this.chckReqParam(string, "tableId");
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getReservedParameter(string), null);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
        this.chckReqParam(string, "columns");
    }

    public void setUseBackup(String string) {
        this.useBackup = StringUtil.nval((String)this.getRequestParameter(string), (String)this.useBackup);
        if (this.useBackup != null && "true/false/rename".indexOf(this.useBackup.toLowerCase(Locale.JAPAN)) < 0) {
            String string2 = "useBackup \u5c5e\u6027\u306f\u3001[true/false/rename] \u304b\u3089\u3001\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 useBackup=[" + this.useBackup + "]" + CR;
            throw new HybsSystemException(string2);
        }
        this.chckReqParam(string, "useBackup");
    }

    private void chckReqParam(String string, String string2) {
        if (this.isNull() && string != null && string.contains("{@")) {
            String string3 = "upload \u3067\u306f\u3001enctype=\"multipart/form-data\" \u306e\u305f\u3081\u3001{@XXXX}\u5f62\u5f0f\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u4f7f\u3048\u307e\u305b\u3093\u3002" + CR + "    " + string2 + "=[" + string + "]";
            throw new HybsSystemException(string3);
        }
    }

    @Override
    protected String getTagName() {
        return "upload";
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("names", (Object[])NAMES).println("ENCODE", (Object)ENCODE).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("maxPostSize", (Object)this.maxPostSize).println("tableId", (Object)this.tableId).println("columns", (Object)this.columns).println("useBackup", (Object)this.useBackup).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

