/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.daemon;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.transfer.TransferConfig;
import org.opengion.fukurou.transfer.TransferProcess;
import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class Daemon_Transfer
extends HybsTimerTask {
    private static final String VERSION = "6.4.2.0 (2016/01/29)";
    private static final String GE62_SELECT = "SELECT A.KBREAD,A.READOBJ,A.READPRM,A.KBEXEC,A.EXECDBID,A.EXECOBJ,A.EXECPRM,A.ERROR_SENDTO FROM GE62 A WHERE A.FGJ = '1'";
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool((String)"USE_DB_APPLICATION_INFO");
    private static final String HTTP_PROXY_HOST = HybsSystem.sys((String)"HTTP_PROXY_HOST");
    private static final int HTTP_PROXY_PORT = HybsSystem.sysInt((String)"HTTP_PROXY_PORT");
    private static final String HFROM = HybsSystem.sys((String)"TRANSFER_HOST_CODE");
    private static final int LOOP_COUNTER = 24;
    protected final String DBID = HybsSystem.sys((String)"RESOURCE_DBID");
    private boolean running = true;
    private int loopCnt;
    private String ge62Select;
    private String dmnName;
    private ApplicationInfo appInfo;
    private boolean debug;

    public void initDaemon() {
        this.debug = StringUtil.nval((String)this.getValue("DEBUG"), (boolean)this.debug);
        this.dmnName = this.getName();
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(GE62_SELECT);
        String string = this.getValue("SYSTEM_ID");
        if (StringUtil.isNull((CharSequence)string)) {
            throw new HybsSystemException("\u30b7\u30b9\u30c6\u30e0ID\u65b9\u6cd5\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002");
        }
        stringBuilder.append(" AND A.SYSTEM_ID='").append(string).append('\'');
        String string2 = this.getValue("KBREAD");
        if (StringUtil.isNull((CharSequence)string2)) {
            throw new HybsSystemException("\u8aad\u53d6\u65b9\u6cd5\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002");
        }
        stringBuilder.append(" AND A.KBREAD='").append(string2).append('\'');
        String string3 = this.getValue("DMN_GRP");
        if (StringUtil.isNull((CharSequence)string3)) {
            throw new HybsSystemException("\u30c7\u30fc\u30e2\u30f3\u30b0\u30eb\u30fc\u30d7\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002");
        }
        stringBuilder.append(" AND A.DMN_GRP='").append(string3).append('\'');
        stringBuilder.append(" ORDER BY A.READOBJ,A.KBEXEC,A.EXECOBJ");
        this.ge62Select = stringBuilder.toString();
        if (this.debug) {
            System.out.println("DMN_NAME=[" + this.dmnName + "]");
            System.out.println("QUERY=[" + this.ge62Select + "]");
        }
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(string, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("TransferDaemon", this.dmnName, this.dmnName);
        } else {
            this.appInfo = null;
        }
    }

    protected void startDaemon() {
        Object object;
        Object object2;
        if (this.loopCnt % 24 == 0) {
            this.loopCnt = 1;
            System.out.println();
            System.out.print(this.toString() + " " + new Date() + " ");
        } else {
            System.out.print(".");
            ++this.loopCnt;
        }
        GE62Data gE62Data = new GE62Data();
        try {
            object2 = DBUtil.dbExecute((String)this.ge62Select, null, (ApplicationInfo)this.appInfo, (String)this.DBID);
            if (object2 != null && ((String[][])object2).length > 0) {
                for (int i = 0; this.running && i < ((String[][])object2).length; ++i) {
                    gE62Data.addData(object2[i]);
                }
            }
        }
        catch (Throwable throwable) {
            String string = "\u4f1d\u9001\u8aad\u53d6\u30a8\u30e9\u30fc\uff1aDMN_NAME=[" + this.dmnName + "] , DMN_HOST=[" + HybsSystem.HOST_NAME + "] , QUERY=[" + this.ge62Select + "]";
            String string2 = string + HybsConst.CR + ThrowUtil.ogStackTrace((Throwable)throwable);
            System.out.println(string2);
            LogWriter.log((String)string2);
            object = HybsSystem.sys((String)"ERROR_MAIL_TO_USERS");
            this.sendMail(string, string2, (String)object);
        }
        object2 = new StringBuilder(200);
        for (String string2 : gE62Data.getTranSet()) {
            object = null;
            try {
                object = new TransferProcess(gE62Data.getConfSet(string2));
                object.setDmnName(this.dmnName);
                object.setAppInfo(this.appInfo);
                if (this.debug) {
                    object.setDebug();
                }
                object.process();
            }
            catch (Throwable throwable) {
                Object object3;
                this.cancel();
                ((StringBuilder)object2).setLength(0);
                ((StringBuilder)object2).append("\u4f1d\u9001\u30a8\u30e9\u30fc\uff1aDMN_NAME=[").append(this.dmnName).append("] , DMN_HOST=[").append(HybsSystem.HOST_NAME).append(']');
                String string = null;
                if (object != null && (object3 = object.getLastConfig()) != null) {
                    ((StringBuilder)object2).append(" , CONFIG=[").append(object3).append(']');
                    string = object3.getErrorSendto();
                }
                object3 = ((StringBuilder)object2).toString();
                String string3 = ((StringBuilder)object2).append(HybsConst.CR).append(ThrowUtil.ogStackTrace((Throwable)throwable)).toString();
                System.out.println(string3);
                LogWriter.log((String)string3);
                this.sendMail((String)object3, string3, string);
            }
        }
    }

    public boolean cancel() {
        this.running = false;
        return super.cancel();
    }

    protected void sendMail(String string, String string2, String string3) {
        String string4 = HybsSystem.sys((String)"COMMON_MAIL_SERVER");
        String string5 = HybsSystem.sys((String)"ERROR_MAIL_FROM_USER");
        Object[] objectArray = StringUtil.csv2Array((String)string3);
        if (string4 != null && string5 != null && objectArray.length > 0) {
            try {
                MailTX mailTX = new MailTX(string4);
                mailTX.setFrom(string5);
                mailTX.setTo((String[])objectArray);
                mailTX.setSubject(string);
                mailTX.setMessage(string2);
                mailTX.sendmail();
            }
            catch (Throwable throwable) {
                String string6 = "\u30a8\u30e9\u30fc\u6642\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + " SUBJECT:" + string + HybsConst.CR + " HOST:" + string4 + HybsConst.CR + " FROM:" + string5 + HybsConst.CR + " TO:" + Arrays.toString(objectArray) + HybsConst.CR + throwable.getMessage();
                LogWriter.log((String)string6);
                LogWriter.log((Throwable)throwable);
            }
        }
    }

    private static final class GE62Data {
        private final Set<String> tranSet = new LinkedHashSet<String>();
        private final Map<String, Set<TransferConfig>> tran2ConfSetMap = new LinkedHashMap<String, Set<TransferConfig>>();

        private GE62Data() {
        }

        private void addData(String ... stringArray) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            String string6 = stringArray[5];
            String string7 = stringArray[6];
            String string8 = stringArray[7];
            String string9 = string2;
            this.tranSet.add(string9);
            Set<TransferConfig> set = this.tran2ConfSetMap.get(string9);
            if (set == null) {
                set = new LinkedHashSet<TransferConfig>();
            }
            TransferConfig transferConfig = new TransferConfig(string, string2, string3, string4, string5, string6, string7, string8, HFROM, HTTP_PROXY_HOST, HTTP_PROXY_PORT);
            set.add(transferConfig);
            this.tran2ConfSetMap.put(string9, set);
        }

        private Set<String> getTranSet() {
            return this.tranSet;
        }

        private Set<TransferConfig> getConfSet(String string) {
            return this.tran2ConfSetMap.get(string);
        }
    }
}

