/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.mail;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.mail.DefaultMailManager;
import org.opengion.hayabusa.mail.MailPattern;
import org.opengion.hayabusa.resource.ResourceManager;

public class MailManager_DIRECT
extends DefaultMailManager {
    private static final String[] NAMES = new String[]{"DST_ID", "GROUP_ID", "GROUP_NAME", "DST_NAME", "DST_ADDR", "DST_KBN", "FGJ_MAIL"};
    private static final int IDX_DST_ID = 0;
    private static final int IDX_FGJ_MAIL = 6;
    private ResourceManager resource;

    public void create(ConcurrentMap<String, String> concurrentMap, DBTableModel dBTableModel) {
        MailPattern mailPattern = new MailPattern(concurrentMap);
        this.setHost(mailPattern.getHost());
        this.setPort(mailPattern.getSmtpPort());
        this.setAuthType(mailPattern.getAuthType());
        this.setAuthUser(mailPattern.getAuthUser());
        this.setAuthPass(mailPattern.getAuthPass());
        this.setInitParams(concurrentMap);
        this.setAttachFiles((String)concurrentMap.get("ATTACH1"), (String)concurrentMap.get("ATTACH2"), (String)concurrentMap.get("ATTACH3"), (String)concurrentMap.get("ATTACH4"), (String)concurrentMap.get("ATTACH5"));
        ConcurrentMap<String, String[]> concurrentMap2 = this.makeMailDstMap(dBTableModel);
        this.setMailDstMap(concurrentMap2);
    }

    public DBTableModel makeDstTable() {
        ConcurrentMap<String, String[]> concurrentMap = this.getMailDstMap();
        int n = NAMES.length;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n);
        this.setTableDBColumn(dBTableModel, NAMES);
        concurrentMap.values().forEach(stringArray -> dBTableModel.addColumnValues((String[])stringArray));
        return dBTableModel;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    protected void setTableDBColumn(DBTableModel dBTableModel, String ... stringArray) {
        if (this.resource == null) {
            throw new OgRuntimeException("#setResourceManager(ResourceManager)\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            DBColumn dBColumn = this.resource.makeDBColumn(stringArray[i]);
            dBTableModel.setDBColumn(i, dBColumn);
        }
    }

    private ConcurrentMap<String, String[]> makeMailDstMap(DBTableModel dBTableModel) {
        ConcurrentSkipListMap<String, String[]> concurrentSkipListMap = new ConcurrentSkipListMap<String, String[]>();
        int n = dBTableModel.getRowCount();
        int n2 = NAMES.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = new String[n2];
            if (!"0".equals(dBTableModel.getValue(i, 6))) continue;
            for (int j = 0; j < n2; ++j) {
                stringArray[j] = (String)dBTableModel.getValue(i, j);
            }
            if (stringArray[0] == null) continue;
            concurrentSkipListMap.put(stringArray[0], stringArray);
        }
        return concurrentSkipListMap;
    }
}

