/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.business;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.business.ArrayTableModel;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBFunctionName;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.SystemParameter;

public abstract class AbstractBizLogic {
    protected static final int OK = 0;
    protected static final int WARNING = 1;
    protected static final int NG = 2;
    protected static final int EXCEPTION = 8;
    protected static final int ORCL_ERR = 9;
    private Connection conn;
    private Transaction tran;
    private String dbid;
    DBFunctionName dbName;
    private HybsLoader loader;
    private String[] keys;
    private String[] vals;
    private final Map<String, String> variableMap = new HashMap<String, String>();
    private final ConcurrentMap<String, Formatter> formatMap = new ConcurrentHashMap<String, Formatter>();
    private final ConcurrentMap<String, SystemParameter> sysParamMap = new ConcurrentHashMap<String, SystemParameter>();
    private final ErrorMessage errMsg = new ErrorMessage();
    private String bizRtn;
    private boolean debugFlag;
    private final StringBuilder debugMsg = new StringBuilder(200);
    private boolean useParamMetaData;
    protected ArrayTableModel table;
    protected int row = -1;

    protected AbstractBizLogic() {
    }

    public void setTransaction(Transaction transaction) {
        this.tran = transaction;
        this.conn = this.tran.getConnection(this.dbid);
        this.useParamMetaData = ConnectionFactory.useParameterMetaData(this.dbid);
    }

    void setDbid(String string) {
        this.dbid = string;
    }

    void setLoader(HybsLoader hybsLoader) {
        if (this.loader != null) {
            String string = "\u65e2\u306b\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u30fc\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002 OLD:" + this.loader + " IN :" + hybsLoader;
            throw new OgRuntimeException(string);
        }
        this.loader = hybsLoader;
    }

    void setTable(ArrayTableModel arrayTableModel) {
        if (this.table != null) {
            String string = "\u65e2\u306b\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002 OLD:" + this.table + " IN :" + arrayTableModel;
            throw new OgRuntimeException(string);
        }
        this.table = arrayTableModel;
    }

    void setKeys(String ... stringArray) {
        if (this.keys != null) {
            String string = "\u65e2\u306b\u56fa\u5b9a\u5024\u914d\u5217(\u30ad\u30fc)\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002" + HybsConst.CR + "   KESY   =" + Arrays.toString(this.keys) + HybsConst.CR + "   in keys=" + Arrays.toString(stringArray);
            throw new OgRuntimeException(string);
        }
        if (stringArray != null && stringArray.length > 0) {
            this.keys = stringArray;
        }
    }

    void setVals(String ... stringArray) {
        if (this.vals != null) {
            String string = "\u65e2\u306b\u56fa\u5b9a\u5024\u914d\u5217(\u5024)\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002" + HybsConst.CR + "   VALS   =" + Arrays.toString(this.vals) + HybsConst.CR + "   in vals=" + Arrays.toString(stringArray);
            throw new OgRuntimeException(string);
        }
        if (stringArray != null && stringArray.length > 0) {
            this.vals = stringArray;
        }
    }

    void setUserId(String string) {
        this.variableMap.put("CON.USERID", string);
    }

    void setParentPgId(String string) {
        this.variableMap.put("CON.PGPID", string);
    }

    void setDebug() {
        this.debugFlag = true;
    }

    String getDebugMsg() {
        return this.debugMsg.toString();
    }

    boolean exec() throws Throwable {
        this.dbName = DBFunctionName.getDBName(ConnectionFactory.getDBName(this.dbid));
        this.makeParamMap();
        this.init();
        return this.main();
    }

    protected abstract void init();

    protected abstract boolean main();

    int getKekka() {
        return this.errMsg.getKekka();
    }

    ErrorMessage getErrMsg() {
        return this.errMsg;
    }

    String getReturn() {
        return this.bizRtn;
    }

    protected boolean isRequireTable() {
        return false;
    }

    protected final boolean isDebug() {
        return this.debugFlag;
    }

    protected final void debug(String string) {
        this.debugMsg.append(string).append(HybsConst.CR);
    }

    protected final String var(String string) {
        return this.variableMap.get(string);
    }

    protected final int vari(String string) {
        return this.var(string) == null ? 0 : Integer.parseInt(this.var(string));
    }

    protected final double vard(String string) {
        return this.var(string) == null ? 0.0 : Double.valueOf(this.var(string));
    }

    protected final String[] varKeys() {
        Set<String> set = this.variableMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    protected final void set(String string, String string2) {
        if (this.variableMap.containsKey(string)) {
            String string3 = "\u3059\u3067\u306b\u767b\u9332\u6e08\u307f\u306e\u30ad\u30fc\u3092\u5b9a\u7fa9\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + HybsConst.CR + "   key =" + string + HybsConst.CR + "   val =" + string2 + HybsConst.CR + "   \u5143  =" + this.variableMap.get(string);
            throw new OgRuntimeException(string3);
        }
        this.variableMap.put(string, string2);
    }

    protected final void set(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    protected final void set(String string, double d) {
        this.set(string, String.valueOf(d));
    }

    protected final String line(String string) {
        return this.line(string, this.row);
    }

    protected final String line(String string, int n) {
        if (this.table == null) {
            String string2 = "\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001#line( String,int )\u30e1\u30bd\u30c3\u30c9\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + HybsConst.CR + "   line( " + string + "," + n + " );" + HybsConst.CR;
            throw new OgRuntimeException(string2);
        }
        int n2 = this.table.getColumnNo(string);
        return n2 < 0 || n < 0 || n >= this.table.getRowCount() ? null : this.table.getValue(n, n2);
    }

    protected final int linei(String string) {
        return this.line(string) == null ? 0 : Integer.parseInt(this.line(string));
    }

    protected final int linei(String string, int n) {
        return this.line(string, n) == null ? 0 : Integer.parseInt(this.line(string, n));
    }

    protected final double lined(String string) {
        return this.line(string) == null ? 0.0 : Double.valueOf(this.line(string));
    }

    protected final double lined(String string, int n) {
        return this.line(string, n) == null ? 0.0 : Double.valueOf(this.line(string, n));
    }

    protected final String[] lineKeys() {
        if (this.table == null) {
            throw new OgRuntimeException("\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001#lineKeys()\u30e1\u30bd\u30c3\u30c9\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        return this.table.getNames();
    }

    protected final boolean isLine(String string) {
        if (this.table == null) {
            String string2 = "\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001#isLine( String )\u30e1\u30bd\u30c3\u30c9\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + HybsConst.CR + "   isLine( " + string + " );" + HybsConst.CR;
            throw new OgRuntimeException(string2);
        }
        return this.table.getColumnNo(string) >= 0;
    }

    protected final void rtn(String string) {
        this.bizRtn = string;
    }

    protected final boolean call(String string, String string2, String string3) {
        return this.call(string, string2, string3, this.row, this.table);
    }

    protected final boolean call(String string, String string2, String string3, int n, ArrayTableModel arrayTableModel) {
        ErrMsg[] errMsgArray;
        boolean bl;
        if (this.loader == null) {
            String string4 = "#setLoader(HybsLoader)\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + "   subLogicName =" + string + HybsConst.CR + "   key =" + string2 + HybsConst.CR + "   val =" + string3 + HybsConst.CR + "   ArrayTableModel=" + arrayTableModel;
            throw new OgRuntimeException(string4);
        }
        AbstractBizLogic abstractBizLogic = (AbstractBizLogic)this.loader.newInstance(string);
        if (abstractBizLogic.isRequireTable()) {
            String string5 = "\u3053\u306e\u30af\u30e9\u30b9\u306f\u3001\u5916\u90e8\u304b\u3089\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u3092\u30bb\u30c3\u30c8\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\u305f\u3081\u3001\u5b50\u30ed\u30b8\u30c3\u30af\u3068\u3057\u3066\u547c\u3073\u51fa\u3059\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + HybsConst.CR + "  [\u30af\u30e9\u30b9\u540d=" + abstractBizLogic.getClass().getName() + "]" + HybsConst.CR + "   subLogicName =" + string + "   key =[" + string2 + "]   val =[" + string3 + "]" + HybsConst.CR;
            throw new OgRuntimeException(string5);
        }
        abstractBizLogic.setTransaction(this.tran);
        abstractBizLogic.setLoader(this.loader);
        abstractBizLogic.setKeys(StringUtil.csv2Array(string2));
        String[] stringArray = StringUtil.csv2Array(string3);
        for (bl = false; bl < stringArray.length; bl += 1) {
            stringArray[bl] = this.replaceParam(stringArray[bl], n, arrayTableModel);
        }
        abstractBizLogic.setVals(stringArray);
        abstractBizLogic.setUserId(this.variableMap.get("CON.USERID"));
        abstractBizLogic.setParentPgId(this.variableMap.get("CON.PGID"));
        if (this.debugFlag) {
            abstractBizLogic.setDebug();
        }
        try {
            bl = abstractBizLogic.exec();
        }
        catch (Throwable throwable) {
            String string6 = "\u5b50\u30ed\u30b8\u30c3\u30af\u306e\u547c\u3073\u51fa\u3057\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "   subLogicName =" + string + HybsConst.CR + "   key =[" + string2 + "]   val =[" + string3 + "]" + HybsConst.CR;
            throw new OgRuntimeException(string6, throwable);
        }
        this.variableMap.put("RETURN", abstractBizLogic.getReturn());
        if (this.debugFlag) {
            this.debug(abstractBizLogic.getDebugMsg());
        }
        if ((errMsgArray = abstractBizLogic.getErrMsg().toArray()).length > 0) {
            ErrorMessage errorMessage = new ErrorMessage();
            for (int i = 0; i < errMsgArray.length; ++i) {
                errorMessage.addMessage(errMsgArray[i].copy(n));
            }
            this.errMsg.append(errorMessage);
        }
        return bl;
    }

    protected final void sql(String string) {
        this.sql(string, this.row, this.table);
    }

    protected final void sql(String string, int n, ArrayTableModel arrayTableModel) {
        ArrayTableModel arrayTableModel2 = this.execSQL(string, n, arrayTableModel);
        if (arrayTableModel2 != null && arrayTableModel2.getRowCount() > 0) {
            String[] stringArray = arrayTableModel2.getNames();
            String[] stringArray2 = arrayTableModel2.getValues(0);
            for (int i = 0; i < stringArray.length; ++i) {
                this.variableMap.put(stringArray[i], stringArray2[i]);
            }
        }
    }

    protected final int seq(String string) {
        if (this.dbName == null) {
            String string2 = "#exec()\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + "   seqName =" + string;
            throw new OgRuntimeException(string2);
        }
        return this.dbName.getSequence(string, this.tran);
    }

    private ArrayTableModel execSQL(String string, int n, ArrayTableModel arrayTableModel) {
        if (this.conn == null) {
            String string2 = "#setTransaction(Transaction)\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + "   sql =" + string + HybsConst.CR + "   ArrayTableModel=" + arrayTableModel;
            throw new OgRuntimeException(string2);
        }
        String string3 = this.replaceParam(string, false);
        Formatter formatter = null;
        if (arrayTableModel != null && string3.indexOf(91) >= 0) {
            formatter = this.getFormatter(string3, arrayTableModel);
            string3 = formatter.getQueryFormatString();
        }
        ArrayTableModel arrayTableModel2 = null;
        try (PreparedStatement preparedStatement = this.conn.prepareStatement(string3);){
            Wrapper wrapper;
            if (arrayTableModel != null && formatter != null) {
                int[] nArray = formatter.getClmNos();
                if (this.useParamMetaData) {
                    wrapper = preparedStatement.getParameterMetaData();
                    for (int i = 0; i < nArray.length; ++i) {
                        int n2 = wrapper.getParameterType(i + 1);
                        String string4 = arrayTableModel.getValue(n, nArray[i]);
                        if (string4 == null || string4.isEmpty()) {
                            preparedStatement.setNull(i + 1, n2);
                            continue;
                        }
                        preparedStatement.setObject(i + 1, (Object)string4, n2);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        preparedStatement.setObject(i + 1, arrayTableModel.getValue(n, nArray[i]));
                    }
                }
            }
            boolean bl = preparedStatement.execute();
            wrapper = preparedStatement.getResultSet();
            Throwable throwable = null;
            try {
                if (bl) {
                    ResultSetMetaData resultSetMetaData = wrapper.getMetaData();
                    int n3 = resultSetMetaData.getColumnCount();
                    String[] stringArray = new String[n3];
                    for (int i = 0; i < n3; ++i) {
                        stringArray[i] = resultSetMetaData.getColumnLabel(i + 1).toUpperCase(Locale.JAPAN);
                    }
                    String[][] stringArray2 = DBUtil.resultToArray((ResultSet)wrapper, false);
                    arrayTableModel2 = new ArrayTableModel(stringArray, stringArray2);
                    this.variableMap.put("SQL_ROWCOUNT", String.valueOf(preparedStatement.getFetchSize()));
                } else {
                    this.variableMap.put("SQL_ROWCOUNT", String.valueOf(preparedStatement.getUpdateCount()));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (wrapper != null) {
                    if (throwable != null) {
                        try {
                            wrapper.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        wrapper.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            String string5 = "\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "   sql =" + string3 + HybsConst.CR + "   ArrayTableModel=" + arrayTableModel;
            throw new OgRuntimeException(string5, sQLException);
        }
        return arrayTableModel2;
    }

    protected final void error(int n, String string, String ... stringArray) {
        this.error(this.row, n, string, stringArray);
    }

    protected final void error(int n, int n2, String string, String ... stringArray) {
        this.errMsg.addMessage(n, n2, string, this.replaceParam(stringArray));
    }

    protected final boolean must(String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        String[] stringArray = StringUtil.csv2Array(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.variableMap.get(stringArray[i]);
            if (string2 != null && !string2.isEmpty()) continue;
            this.error(2, "ERR0012", "{#" + stringArray[i] + "}");
            return false;
        }
        return true;
    }

    protected final boolean exist(String string, String string2, String string3, String string4) {
        return this.exist(string, string2, string3, string4, null, null, true);
    }

    protected final boolean exist(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.exist(string, string2, string3, string4, string5, string6, true);
    }

    protected final boolean exist(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        int n;
        String string7;
        String[] stringArray;
        if (string3 == null || string3.isEmpty() || string4 == null || string4.isEmpty()) {
            String string8 = "\u30ab\u30e9\u30e0\u53c8\u306f\u3001\u5024\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + HybsConst.CR + "   ns =[" + string3 + "]   vs =[" + string4 + "]";
            throw new OgRuntimeException(string8);
        }
        String string9 = string3 + (string5 == null || string5.isEmpty() ? "" : "," + string5);
        String[] stringArray2 = StringUtil.csv2Array(string9);
        if (stringArray2.length != (stringArray = StringUtil.csv2Array(string7 = string4 + (string6 == null || string6.isEmpty() ? "" : "," + string6))).length) {
            String string10 = "\u30ab\u30e9\u30e0\u3068\u5024\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + "   names = [" + string9 + "]" + HybsConst.CR + "   vals  = [" + string7 + "]";
            throw new OgRuntimeException(string10);
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("select count(*) CNT from ").append(string2);
        for (n = 0; n < stringArray2.length; ++n) {
            if (n == 0) {
                stringBuilder.append(" where ");
            } else {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(stringArray2[n]).append(" = ").append(stringArray[n]);
        }
        n = 0;
        ArrayTableModel arrayTableModel = this.execSQL(stringBuilder.toString(), this.row, this.table);
        if (arrayTableModel != null && arrayTableModel.getRowCount() >= 0) {
            n = Integer.parseInt(arrayTableModel.getValues(0)[0]);
        }
        String string11 = this.replaceParam(string4);
        if ("true".equalsIgnoreCase(string)) {
            if (n <= 0) {
                if (bl) {
                    this.error(2, "ERR0025", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else if ("false".equalsIgnoreCase(string)) {
            if (n > 0) {
                if (bl) {
                    this.error(2, "ERR0026", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else if ("one".equalsIgnoreCase(string)) {
            if (n > 1) {
                if (bl) {
                    this.error(2, "ERR0027", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else {
            String string12 = "type\u306f\u3001true\u3001false\u3001one\u306e\u3044\u305a\u308c\u304b\u3067\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + HybsConst.CR + "   type = [" + string + "]";
            throw new OgRuntimeException(string12);
        }
        return true;
    }

    private void makeParamMap() {
        if (this.keys != null && this.vals != null) {
            if (this.keys.length == this.vals.length) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.variableMap.put(this.keys[i], this.vals[i]);
                }
            } else {
                String string = "keys\u3068vals\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + "   keys   =" + Arrays.toString(this.keys) + HybsConst.CR + "   vals   =" + Arrays.toString(this.vals);
                throw new OgRuntimeException(string);
            }
        }
        String string = DateSet.getDate("yyyyMMddHHmmss");
        this.variableMap.put("CON.YMDH", string);
        this.variableMap.put("CON.YMD", string.substring(0, 8));
        this.variableMap.put("CON.HMS", string.substring(8));
        this.variableMap.put("CON.PGID", this.getClass().getSimpleName());
    }

    private String[] replaceParam(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.replaceParam(stringArray[i], this.row, this.table);
        }
        return stringArray;
    }

    private String replaceParam(String string) {
        return this.replaceParam(string, this.row, this.table);
    }

    private String replaceParam(String string, boolean bl) {
        return bl ? this.replaceParam(string, this.row, this.table) : this.replaceParam(string, 0, null);
    }

    private String replaceParam(String string, int n, ArrayTableModel arrayTableModel) {
        Object object;
        if (string == null || string.isEmpty()) {
            return "";
        }
        String string2 = string;
        if (!this.variableMap.isEmpty() && string2.indexOf("{@") >= 0) {
            object = this.getSysParam(string2);
            string2 = ((SystemParameter)object).replace(this.variableMap);
        }
        if (arrayTableModel != null && string2.indexOf(91) >= 0) {
            object = this.getFormatter(string2, arrayTableModel);
            string2 = ((Formatter)object).getFormatString(n);
        }
        return string2;
    }

    private Formatter getFormatter(String string, ArrayTableModel arrayTableModel) {
        String string3 = string + arrayTableModel.toString();
        return this.formatMap.computeIfAbsent(string3, string2 -> new Formatter(arrayTableModel, string));
    }

    private SystemParameter getSysParam(String string2) {
        String string3 = string2 == null ? "NULL" : string2;
        return this.sysParamMap.computeIfAbsent(string3, string -> new SystemParameter((String)string));
    }

    protected final ArrayTableModel createTableBySql(String string) {
        return this.createTableBySql(string, this.row, this.table);
    }

    protected final ArrayTableModel createTableBySql(String string, int n, ArrayTableModel arrayTableModel) {
        return this.execSQL(string, n, arrayTableModel);
    }
}

