/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.opengion.fukurou.mail.MailMessage;
import org.opengion.fukurou.mail.MailReceiveListener;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;

public class MailRX {
    public static final int MAX_ROW_COUNT = 100;
    public static final boolean DELETE_MESSAGE = false;
    public static final String PROTOCOL = "pop3";
    public static final int PORT = -1;
    public static final String MBOX = "INBOX";
    public static final String CHARSET = "ISO-2022-JP";
    private MailReceiveListener listener;
    private String host;
    private String user;
    private String passwd;
    private String protocol = "pop3";
    private int port = -1;
    private boolean isUseSSL;
    private String mbox = "INBOX";
    private boolean deleteFlag = false;
    private String charset = "ISO-2022-JP";
    private int maxRowCount = 100;
    private final List<HybsEntry> matchList = new ArrayList<HybsEntry>();
    private boolean debug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MessagingException, NoSuchProviderException {
        String string;
        Session session;
        HybsEntry[] hybsEntryArray;
        this.debugMsg("\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u89e3\u6790\u3001\u53d6\u5f97");
        AndTerm andTerm = null;
        if (!this.matchList.isEmpty()) {
            this.debugMsg("\u6307\u5b9a\u306e\u6761\u4ef6\u306b\u30de\u30c3\u30c1\u3057\u305f\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u307f\u629c\u304d\u51fa\u3059\u6761\u4ef6\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
            hybsEntryArray = this.matchList.toArray(new HybsEntry[this.matchList.size()]);
            session = new SearchTerm[hybsEntryArray.length];
            for (int i = 0; i < hybsEntryArray.length; ++i) {
                string = hybsEntryArray[i].getKey();
                session[i] = "Subject".equalsIgnoreCase(string) ? new SubjectTerm(hybsEntryArray[i].getValue()) : ("From".equalsIgnoreCase(string) ? new FromStringTerm(hybsEntryArray[i].getValue()) : ("Body".equalsIgnoreCase(string) ? new BodyTerm(hybsEntryArray[i].getValue()) : new HeaderTerm(string, hybsEntryArray[i].getValue())));
            }
            andTerm = new AndTerm((SearchTerm[])session);
        }
        this.debugMsg("\u7a7a\u306e properties \u3092\u8a2d\u5b9a");
        hybsEntryArray = new Properties();
        hybsEntryArray.setProperty("mail.mime.charset", this.charset);
        hybsEntryArray.setProperty("mail.mime.decodetext.strict", "false");
        hybsEntryArray.setProperty("mail.mime.address.strict", "false");
        if (this.isUseSSL) {
            if (this.protocol.contains(PROTOCOL)) {
                hybsEntryArray.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                hybsEntryArray.setProperty("mail.pop3.socketFactory.fallback", "false");
                hybsEntryArray.setProperty("mail.pop3.socketFactory.port", String.valueOf(this.port));
            } else if (this.protocol.contains("imap")) {
                hybsEntryArray.setProperty("mail.imap.ssl.enable", "true");
                hybsEntryArray.setProperty("mail.imap.ssl.socketFactory.class", "DummySSLSocketFactory");
                hybsEntryArray.setProperty("mail.imap.ssl.socketFactory.fallback", "false");
            }
        }
        this.debugMsg("session \u3092\u53d6\u5f97");
        session = Session.getInstance((Properties)hybsEntryArray, null);
        Store store = null;
        string = null;
        try {
            this.debugMsg("store \u306e\u53d6\u5f97 protocol=", this.protocol);
            store = session.getStore(this.protocol);
            this.debugMsg("\u30b5\u30fc\u30d0\u30fc\u3068 connect \u3057\u307e\u3059\u3002");
            store.connect(this.host, this.port, this.user, this.passwd);
            this.debugMsg("folder \u306e\u53d6\u5f97");
            string = store.getFolder(this.mbox);
            if (this.deleteFlag) {
                string.open(2);
            } else {
                string.open(1);
            }
            this.debugMsg("\u30e1\u30c3\u30bb\u30fc\u30b8\u60c5\u5831\u306e\u53d6\u5f97");
            Message[] messageArray = andTerm == null ? string.getMessages() : string.search((SearchTerm)andTerm);
            int n = messageArray.length;
            for (int i = 0; i < n && i < this.maxRowCount; ++i) {
                MailMessage mailMessage = new MailMessage(messageArray[i], this.host, this.user);
                this.debugMsg("[", String.valueOf(i), "]", mailMessage.getMessageID(), " \u53d7\u4fe1\u4e2d");
                if (this.deleteFlag) {
                    messageArray[i].setFlag(Flags.Flag.DELETED, true);
                }
                boolean bl = true;
                if (this.listener != null) {
                    bl = this.listener.receive(mailMessage);
                }
                String string2 = mailMessage.getNotificationTo();
                if (!bl || string2 == null) continue;
                MailTX mailTX = new MailTX(this.host);
                mailTX.setFrom(this.user);
                mailTX.setTo(StringUtil.csv2Array(string2));
                mailTX.setSubject("\u53d7\u9818:" + mailMessage.getSubject());
                mailTX.setMessage(mailMessage.getContent());
                mailTX.sendmail();
            }
        }
        catch (Throwable throwable) {
            this.debugMsg("\u30bb\u30c3\u30b7\u30e7\u30f3\u7d42\u4e86\u51e6\u7406");
            if (string != null) {
                string.close(this.deleteFlag);
            }
            if (store != null) {
                store.close();
            }
            throw throwable;
        }
        this.debugMsg("\u30bb\u30c3\u30b7\u30e7\u30f3\u7d42\u4e86\u51e6\u7406");
        if (string != null) {
            string.close(this.deleteFlag);
        }
        if (store != null) {
            store.close();
        }
    }

    public void setHost(String string) {
        if (string == null) {
            throw new IllegalArgumentException("host \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        this.host = string;
    }

    public void setUser(String string) {
        if (string == null) {
            throw new IllegalArgumentException("user \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        this.user = string;
    }

    public void setPasswd(String string) {
        if (string == null) {
            throw new IllegalArgumentException("passwd \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        this.passwd = string;
    }

    public void setProtocol(String string) {
        if (string == null) {
            throw new IllegalArgumentException("protocol \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        this.protocol = string.toLowerCase(Locale.JAPAN);
        if (this.port < 0) {
            if (PROTOCOL.equalsIgnoreCase(this.protocol)) {
                this.port = 110;
            }
            if ("imap".equalsIgnoreCase(this.protocol)) {
                this.port = 143;
                this.isUseSSL = true;
            }
            if ("pop3s".equalsIgnoreCase(this.protocol)) {
                this.port = 995;
            }
            if ("imaps".equalsIgnoreCase(this.protocol)) {
                this.port = 993;
                this.isUseSSL = true;
            }
        }
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void useSSL(boolean bl) {
        this.isUseSSL = bl || "pop3s".equalsIgnoreCase(this.protocol) || "imaps".equalsIgnoreCase(this.protocol);
    }

    public void setMbox(String string) {
        if (string == null) {
            throw new IllegalArgumentException("mbox \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        this.mbox = string;
    }

    public void setMailReceiveListener(MailReceiveListener mailReceiveListener) {
        this.listener = mailReceiveListener;
    }

    public void setDelete(boolean bl) {
        this.deleteFlag = bl;
    }

    public void setCharset(String string) {
        if (string == null) {
            throw new IllegalArgumentException("charset \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        this.charset = string;
    }

    public void setMaxRowCount(int n) {
        this.maxRowCount = n > 0 ? n : Integer.MAX_VALUE;
    }

    public void addMatchTerm(HybsEntry hybsEntry) {
        this.matchList.add(hybsEntry);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    private void debugMsg(String ... stringArray) {
        if (this.debug) {
            for (String string : stringArray) {
                System.out.print(string);
            }
            System.out.println();
        }
    }

    public static void main(String[] stringArray) throws MessagingException {
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.mail.MailRX host user passwd [saveDir]");
            System.exit(1);
        }
        final String string = stringArray.length == 4 ? stringArray[3] : null;
        MailRX mailRX = new MailRX();
        mailRX.setHost(stringArray[0]);
        mailRX.setUser(stringArray[1]);
        mailRX.setPasswd(stringArray[2]);
        mailRX.setCharset(CHARSET);
        MailReceiveListener mailReceiveListener = new MailReceiveListener(){

            @Override
            public boolean receive(MailMessage mailMessage) {
                System.out.println(mailMessage.getSimpleMessage());
                if (string != null) {
                    mailMessage.saveSimpleMessage(string);
                }
                return true;
            }
        };
        mailRX.setMailReceiveListener(mailReceiveListener);
        mailRX.start();
    }
}

