/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.opengion.fukurou.db.ResultSetValue;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBTableModelImpl;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.resource.ResourceManager;

public class DBTableModelEditor
extends DBTableModelImpl {
    private static final String JS = "__";
    private static final DecimalFormat FORMAT = new DecimalFormat("0.#########");
    private int rowCountColumn = -1;
    private DBEditConfig config;

    public void create(ResultSet resultSet, int n, int n2, ResourceManager resourceManager, DBEditConfig dBEditConfig) throws SQLException {
        if (resultSet == null || dBEditConfig == null || resourceManager == null) {
            throw new HybsSystemException("DBTableModel\u307e\u305f\u306f\u3001DBEditConfig\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.config = dBEditConfig;
        ResultSetValue resultSetValue = new ResultSetValue(resultSet);
        int n3 = resultSetValue.getColumnCount();
        if (dBEditConfig.useGroup() || dBEditConfig.useSubTotal() || dBEditConfig.useTotal() || dBEditConfig.useGrandTotal()) {
            this.rowCountColumn = n3++;
        }
        this.init(n3);
        DBColumn[] dBColumnArray = new DBColumn[this.numberOfColumns];
        boolean[] blArray = new boolean[this.numberOfColumns];
        boolean[] blArray2 = new boolean[this.numberOfColumns];
        boolean[] blArray3 = new boolean[this.numberOfColumns];
        boolean[] blArray4 = new boolean[this.numberOfColumns];
        boolean bl = false;
        if (dBEditConfig.useGrandTotal()) {
            bl = true;
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            String string = null;
            if (i == this.rowCountColumn) {
                string = "rowCount";
                dBColumnArray[i] = resourceManager.makeDBColumn(string);
            } else {
                string = resultSetValue.getColumnName(i);
                dBColumnArray[i] = resourceManager.getDBColumn(string);
                if (dBColumnArray[i] == null) {
                    dBColumnArray[i] = DBTableModelUtil.makeDBColumn(string, i, resultSetValue, resourceManager);
                }
            }
            this.setDBColumn(i, dBColumnArray[i]);
            blArray[i] = dBEditConfig.isSumClm(string);
            blArray2[i] = dBEditConfig.isGroupClm(string);
            blArray3[i] = dBEditConfig.isSubTotalClm(string);
            blArray4[i] = dBEditConfig.isTotalClm(string);
            if (!blArray[i] && !blArray2[i] && !blArray3[i] && !blArray4[i]) continue;
            bl = true;
        }
        if (dBEditConfig.useGroup()) {
            this.addGroupRows(resultSetValue, n, n2, blArray, blArray2);
        } else {
            this.addPlainRows(resultSetValue, n, n2);
        }
        if (this.getRowCount() > 0 && dBEditConfig.useOrderBy()) {
            this.sort();
        }
        if (this.getRowCount() > 0 && !this.isOverflow() && (dBEditConfig.useSubTotal() || dBEditConfig.useTotal() || dBEditConfig.useGrandTotal())) {
            if (!bl) {
                throw new HybsSystemException("\u5c0f\u8a08\u3001\u5408\u8a08\u30ab\u30e9\u30e0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 \u3053\u308c\u306f\u3001query\u30bf\u30b0\u304c\u8907\u6570\u3042\u308a\u3001mainTrans=false \u3067\u5236\u5fa1\u3055\u308c\u3066\u3044\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            this.addTotalRows(n2, resourceManager, blArray, blArray2, blArray3, blArray4);
        }
    }

    private void addGroupRows(ResultSetValue resultSetValue, int n, int n2, boolean[] blArray, boolean[] blArray2) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n && resultSetValue.next(); ++n3) {
        }
        n3 = 0;
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, BigDecimal[]> hashMap2 = new HashMap<String, BigDecimal[]>();
        StringBuilder stringBuilder = new StringBuilder(200);
        while (n3 < n2 && resultSetValue.next()) {
            stringBuilder.setLength(0);
            BigDecimal[] bigDecimalArray = new BigDecimal[this.config.getSumClmCount()];
            String[] stringArray2 = new String[this.config.getGroupClmCount()];
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.numberOfColumns; ++i) {
                if (i == this.rowCountColumn) continue;
                String string2 = resultSetValue.getValue(i);
                if (blArray[i]) {
                    BigDecimal bigDecimal = bigDecimalArray[n4++] = string2 != null && string2.length() > 0 ? new BigDecimal(string2) : BigDecimal.ZERO;
                }
                if (!blArray2[i]) continue;
                stringArray2[n5++] = string2;
                stringBuilder.append(string2).append(JS);
            }
            String string3 = stringBuilder.toString();
            int n6 = 0;
            if (linkedHashMap.containsKey(string3)) {
                BigDecimal[] bigDecimalArray2 = (BigDecimal[])hashMap2.get(string3);
                for (int i = 0; i < this.config.getSumClmCount(); ++i) {
                    bigDecimalArray[i] = bigDecimalArray[i] == null ? BigDecimal.ZERO : bigDecimalArray[i].add(bigDecimalArray2[i]);
                }
                hashMap2.put(string3, bigDecimalArray);
                n6 = (Integer)hashMap.get(string3) + 1;
            } else {
                linkedHashMap.put(string3, stringArray2);
                n6 = 1;
                ++n3;
            }
            hashMap2.put(string3, bigDecimalArray);
            hashMap.put(string3, n6);
        }
        linkedHashMap.forEach((string, stringArray) -> this.addRow(blArray2, (String[])stringArray, (Integer)hashMap.get(string), blArray, (BigDecimal[])hashMap2.get(string)));
        if (n3 >= n2 && resultSetValue.next()) {
            this.setOverflow(true);
        }
    }

    private void addPlainRows(ResultSetValue resultSetValue, int n, int n2) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n && resultSetValue.next(); ++n3) {
        }
        n3 = 0;
        while (n3 < n2 && resultSetValue.next()) {
            ++n3;
            String[] stringArray = new String[this.numberOfColumns];
            for (int i = 0; i < this.numberOfColumns; ++i) {
                stringArray[i] = i == this.rowCountColumn ? "" : resultSetValue.getValue(i);
            }
            this.addColumnValues(stringArray);
        }
        if (n3 >= n2 && resultSetValue.next()) {
            this.setOverflow(true);
        }
    }

    private void sort() {
        DBTableModelSorter dBTableModelSorter = new DBTableModelSorter();
        dBTableModelSorter.setModel(this);
        String[] stringArray = StringUtil.csv2Array((String)this.config.getOrderByClms());
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string = stringArray[i];
            boolean bl = true;
            if (StringUtil.startsChar((CharSequence)string, (char)'!')) {
                string = string.substring(1);
                bl = false;
            }
            int n = this.getColumnNo(string);
            dBTableModelSorter.sortByColumn(n, bl);
        }
        this.data = dBTableModelSorter.data;
        this.rowHeader = dBTableModelSorter.rowHeader;
    }

    private boolean addTotalRows(int n, ResourceManager resourceManager, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, boolean[] blArray4) {
        boolean bl;
        int n2;
        String string = this.config.useSubTotal() ? resourceManager.makeDBColumn("EDIT_SUBTOTAL_VALUE").getLongLabel() : null;
        String string2 = this.config.useTotal() ? resourceManager.makeDBColumn("EDIT_TOTAL_VALUE").getLongLabel() : null;
        String string3 = this.config.useGrandTotal() ? resourceManager.makeDBColumn("EDIT_GRANDTOTAL_VALUE").getLongLabel() : null;
        int n3 = this.getRowCount();
        int n4 = this.config.getSumClmCount();
        BigDecimal[] bigDecimalArray = new BigDecimal[n4];
        BigDecimal[] bigDecimalArray2 = new BigDecimal[n4];
        BigDecimal[] bigDecimalArray3 = new BigDecimal[n4];
        String string4 = null;
        String string5 = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        StringBuilder stringBuilder3 = new StringBuilder(200);
        for (n2 = 0; n3 < n && n2 < this.getRowCount(); ++n2) {
            int n9;
            BigDecimal[] bigDecimalArray4 = new BigDecimal[n4];
            stringBuilder.setLength(0);
            stringBuilder2.setLength(0);
            stringBuilder3.setLength(0);
            int n10 = 0;
            for (n9 = 0; n9 < this.numberOfColumns; ++n9) {
                String string6 = this.getValue(n2, n9);
                if (blArray2[n9]) {
                    stringBuilder.append(string6).append(JS);
                }
                if (blArray[n9]) {
                    BigDecimal bigDecimal = bigDecimalArray4[n10++] = string6 != null && string6.length() > 0 ? new BigDecimal(string6) : BigDecimal.ZERO;
                }
                if (blArray3[n9]) {
                    stringBuilder2.append(string6).append(JS);
                }
                if (blArray4[n9]) {
                    stringBuilder3.append(string6).append(JS);
                }
                if (n9 != this.rowCountColumn) continue;
                n8 = string6 != null && string6.length() > 0 ? Integer.parseInt(string6) : 0;
            }
            if (n3 < n && this.config.useSubTotal() && string4 != null && string4.length() > 0 && !string4.equals(stringBuilder2.toString())) {
                this.addRow(blArray3, string, n5, blArray, bigDecimalArray, n2);
                bigDecimalArray = new BigDecimal[n4];
                n5 = 0;
                ++n3;
                ++n2;
            }
            if (n3 < n && this.config.useTotal() && string5 != null && string5.length() > 0 && !string5.equals(stringBuilder3.toString())) {
                this.addRow(blArray4, string2, n6, blArray, bigDecimalArray2, n2);
                bigDecimalArray2 = new BigDecimal[n4];
                n6 = 0;
                ++n3;
                ++n2;
            }
            for (n9 = 0; n9 < n10; ++n9) {
                bigDecimalArray[n9] = bigDecimalArray[n9] == null ? BigDecimal.ZERO.add(bigDecimalArray4[n9]) : bigDecimalArray[n9].add(bigDecimalArray4[n9]);
                bigDecimalArray2[n9] = bigDecimalArray2[n9] == null ? BigDecimal.ZERO.add(bigDecimalArray4[n9]) : bigDecimalArray2[n9].add(bigDecimalArray4[n9]);
                bigDecimalArray3[n9] = bigDecimalArray3[n9] == null ? BigDecimal.ZERO.add(bigDecimalArray4[n9]) : bigDecimalArray3[n9].add(bigDecimalArray4[n9]);
            }
            string4 = stringBuilder2.toString();
            string5 = stringBuilder3.toString();
            n9 = 1;
            if (this.config.useGroup() && this.rowCountColumn >= 0 && n8 > 0) {
                n9 = n8;
            }
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        boolean bl2 = bl = n2 < this.getRowCount();
        if (this.config.useSubTotal() && string4 != null) {
            if (n3 < n) {
                this.addRow(blArray3, string, n5, blArray, bigDecimalArray, n2);
                ++n3;
                ++n2;
            } else {
                bl = true;
            }
        }
        if (this.config.useTotal() && string5 != null) {
            if (n3 < n) {
                this.addRow(blArray4, string2, n6, blArray, bigDecimalArray2, n2);
                ++n3;
                ++n2;
            } else {
                bl = true;
            }
        }
        if (this.config.useGrandTotal() && n3 > 0) {
            if (n3 < n) {
                boolean[] blArray5 = new boolean[this.numberOfColumns];
                if (this.config.useFirstTotal()) {
                    this.addRow(blArray5, string3, n7, blArray, bigDecimalArray3, 0);
                } else {
                    this.addRow(blArray5, string3, n7, blArray, bigDecimalArray3, n2);
                    ++n2;
                }
                ++n3;
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.setOverflow(true);
        }
        return bl;
    }

    private void addRow(boolean[] blArray, String[] stringArray, int n, boolean[] blArray2, BigDecimal[] bigDecimalArray, int n2) {
        String[] stringArray2 = new String[this.numberOfColumns];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            String string = "";
            if (blArray[i]) {
                string = stringArray[n4++];
            }
            if (blArray2[i]) {
                string = FORMAT.format(bigDecimalArray[n3++]);
            }
            if (i == this.rowCountColumn) {
                string = String.valueOf(n);
            }
            stringArray2[i] = string;
        }
        if (n2 < 0) {
            this.addColumnValues(stringArray2);
        } else {
            this.addValues(stringArray2, n2, false);
        }
    }

    private void addRow(boolean[] blArray, String[] stringArray, int n, boolean[] blArray2, BigDecimal[] bigDecimalArray) {
        this.addRow(blArray, stringArray, n, blArray2, bigDecimalArray, -1);
    }

    private void addRow(boolean[] blArray, String string, int n, boolean[] blArray2, BigDecimal[] bigDecimalArray, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (!blArray[i]) continue;
            arrayList.add(string);
        }
        this.addRow(blArray, arrayList.toArray(new String[arrayList.size()]), n, blArray2, bigDecimalArray, n2);
    }
}

