/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.ArrayList;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelImpl;

public class DBTableModelSorter
extends DBTableModelImpl {
    private int[] indexes;
    private int sortingColumn;
    private boolean ascending = true;
    private int lastColumNo = -1;
    private boolean isNumberType;

    public void setModel(DBTableModel dBTableModel) {
        DBTableModelImpl dBTableModelImpl = (DBTableModelImpl)dBTableModel;
        this.dbColumns = dBTableModelImpl.dbColumns;
        this.names = dBTableModelImpl.names;
        this.data = dBTableModelImpl.data;
        this.rowHeader = dBTableModelImpl.rowHeader;
        this.columnMap = dBTableModelImpl.columnMap;
        this.overflow = dBTableModelImpl.overflow;
        this.numberOfColumns = dBTableModelImpl.numberOfColumns;
        this.consistencyKey = dBTableModelImpl.consistencyKey;
        this.lastColumNo = -1;
        this.reallocateIndexes();
    }

    private void reallocateIndexes() {
        int n = super.getRowCount();
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
    }

    private int compareRowsByColumn(int n, int n2, int n3) {
        String string = super.getValue(n, n3);
        String string2 = super.getValue(n2, n3);
        if (this.isNumberType) {
            double d;
            if (string.isEmpty() || string2.isEmpty()) {
                return string.length() - string2.length();
            }
            double d2 = StringUtil.parseDouble((String)string);
            if (d2 < (d = StringUtil.parseDouble((String)string2))) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        return string.compareTo(string2);
    }

    private int compare(int n, int n2) {
        int n3 = this.compareRowsByColumn(n, n2, this.sortingColumn);
        return n3 == 0 ? 0 : (this.ascending ? n3 : -n3);
    }

    private void checkModel() {
        if (this.indexes.length != super.getRowCount()) {
            String string = "\u5185\u90e8\u884c\u756a\u53f7\u3068\u3001\u30c6\u30fc\u30d6\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u4ef6\u6570\u304c\u4e0d\u4e00\u81f4\u3067\u3059\u3002 " + HybsConst.CR + "Index Length=[" + this.indexes.length + "] , Table Row Count=[" + super.getRowCount() + "]";
            LogWriter.log((String)string);
            this.reallocateIndexes();
        }
    }

    private void sort() {
        this.checkModel();
        this.reallocateIndexes();
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        int n = this.indexes.length;
        ArrayList arrayList = new ArrayList(n);
        ArrayList arrayList2 = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(i, this.data.get(this.indexes[i]));
            arrayList2.add(i, this.rowHeader.get(this.indexes[i]));
        }
        this.data = arrayList;
        this.rowHeader = arrayList2;
    }

    private void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = n + n2 >>> 1;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            System.arraycopy(nArray, n, nArray2, n, n2 - n);
            return;
        }
        int n4 = n;
        int n5 = n3;
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public void sortByColumn(int n) {
        this.ascending = this.lastColumNo == n ? !this.ascending : true;
        this.sortByColumn(n, this.ascending);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumn = n;
        this.isNumberType = this.getDBColumn(this.sortingColumn).isNumberType();
        this.sort();
        this.lastColumNo = n;
    }

    public boolean isAscending() {
        return this.ascending;
    }
}

