/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* HYBS ( PACKAGE BODY )                                                    */
/* Created : 2017/01/05 15:19:29                                            */
/****************************************************************************/

CREATE 
PACKAGE BODY HYBS AS
/*****************************************************************************/
/*	はやぶさエラーメッセージ標準関数ボディ									 */
/*****************************************************************************/

	TM_START TIMESTAMP := NULL;
	TM_LAP   TIMESTAMP := NULL;

	---------------------------------------------------------------------------
	-- エラーメッセージ配列セット関数
	---------------------------------------------------------------------------
	PROCEDURE SET_ERRMSGS
		(P_ERRMSGS	IN OUT	ERR_MSG_ARRAY,
		 P_NO		IN		NUMBER   := NULL,
		 P_KEKKA	IN		NUMBER	 := NULL,
		 P_ID		IN		VARCHAR2 := NULL,
		 P_MSG1		IN		VARCHAR2 := NULL,
		 P_MSG2		IN		VARCHAR2 := NULL,
		 P_MSG3		IN		VARCHAR2 := NULL,
		 P_MSG4		IN		VARCHAR2 := NULL,
		 P_MSG5		IN		VARCHAR2 := NULL )	IS

		V_ERRMSG			ERR_MSG;		-- エラーメッセージオブジェクト
	BEGIN
		-- 引数のエラーメッセージにて、エラーメッセージオブジェクトの初期化
		V_ERRMSG := ERR_MSG(P_NO,P_KEKKA,P_ID,
							SUBSTRB(P_MSG1,1,1000),
							SUBSTRB(P_MSG2,1,1000),
							SUBSTRB(P_MSG3,1,1000),
							SUBSTRB(P_MSG4,1,1000),
							SUBSTRB(P_MSG5,1,1000),
							NULL,NULL  );

		-- エラーメッセージ配列が初期化されていない場合
		IF P_ERRMSGS IS NULL THEN
			-- エラーメッセージ配列の初期化(エラーメッセージのセット)
			P_ERRMSGS := ERR_MSG_ARRAY(V_ERRMSG);

		-- エラーメッセージ配列が最大保持件数以下の場合
		ELSIF P_ERRMSGS.COUNT < P_ERRMSGS.LIMIT THEN
			-- エラーメッセージ配列にNULL要素を追加
			P_ERRMSGS.EXTEND(1);
			-- コピー追加した要素に引数のエラーメッセージオブジェクトを上書き
			P_ERRMSGS(P_ERRMSGS.COUNT) := V_ERRMSG;

		-- エラーメッセージ配列が最大保持件数以上の場合
		ELSE
			RAISE TOO_MANY_ERRORS;
		END IF;
	END SET_ERRMSGS;

	---------------------------------------------------------------------------
	-- エラーメッセージ配列セット関数2 3.8.9.5 (2007/09/29) PG、ステップ名称追加
	---------------------------------------------------------------------------
	PROCEDURE SET_ERRMSGS2
		(P_ERRMSGS	IN OUT	ERR_MSG_ARRAY,
		 P_NO		IN		NUMBER   := NULL,
		 P_KEKKA	IN		NUMBER	 := NULL,
		 P_PG		IN		VARCHAR2 := NULL,
		 P_STEP		IN		VARCHAR2 := NULL,
		 P_ID		IN		VARCHAR2 := NULL,
		 P_MSG1		IN		VARCHAR2 := NULL,
		 P_MSG2		IN		VARCHAR2 := NULL,
		 P_MSG3		IN		VARCHAR2 := NULL,
		 P_MSG4		IN		VARCHAR2 := NULL,
		 P_MSG5		IN		VARCHAR2 := NULL )	IS

		V_ERRMSG			ERR_MSG;		-- エラーメッセージオブジェクト
	BEGIN
		-- 引数のエラーメッセージにて、エラーメッセージオブジェクトの初期化
		V_ERRMSG := ERR_MSG(P_NO,P_KEKKA,P_ID,
							SUBSTRB(P_MSG1,1,1000),
							SUBSTRB(P_MSG2,1,1000),
							SUBSTRB(P_MSG3,1,1000),
							SUBSTRB(P_MSG4,1,1000),
							SUBSTRB(P_MSG5,1,1000),
							P_PG,P_STEP  );

		-- エラーメッセージ配列が初期化されていない場合
		IF P_ERRMSGS IS NULL THEN
			-- エラーメッセージ配列の初期化(エラーメッセージのセット)
			P_ERRMSGS := ERR_MSG_ARRAY(V_ERRMSG);

		-- エラーメッセージ配列が最大保持件数以下の場合
		ELSIF P_ERRMSGS.COUNT < P_ERRMSGS.LIMIT THEN
			-- エラーメッセージ配列にNULL要素を追加
			P_ERRMSGS.EXTEND(1);
			-- コピー追加した要素に引数のエラーメッセージオブジェクトを上書き
			P_ERRMSGS(P_ERRMSGS.COUNT) := V_ERRMSG;

		-- エラーメッセージ配列が最大保持件数以上の場合
		ELSE
			RAISE TOO_MANY_ERRORS;
		END IF;
	END SET_ERRMSGS2;

	---------------------------------------------------------------------------
	-- エラーメッセージ配列最大値オーバーメッセージセット関数
	---------------------------------------------------------------------------
	PROCEDURE SET_LIMITOVER
		(P_ERRMSGS	IN OUT	ERR_MSG_ARRAY) IS
	BEGIN
		P_ERRMSGS(P_ERRMSGS.COUNT).NO   := 0;
		P_ERRMSGS(P_ERRMSGS.COUNT).ID   := 'ERRXXXXX';
		P_ERRMSGS(P_ERRMSGS.COUNT).MSG1 := 'There are too many errors.';
		P_ERRMSGS(P_ERRMSGS.COUNT).MSG2 := NULL;
		P_ERRMSGS(P_ERRMSGS.COUNT).MSG3 := NULL;
		P_ERRMSGS(P_ERRMSGS.COUNT).MSG4 := NULL;
		P_ERRMSGS(P_ERRMSGS.COUNT).MSG5 := NULL;
	END SET_LIMITOVER;

	---------------------------------------------------------------------------
	-- 経過時刻セット関数
	---------------------------------------------------------------------------
	PROCEDURE SET_TIMEMSG
		(P_ERRMSGS	IN OUT	ERR_MSG_ARRAY,
		 P_ID		IN		VARCHAR2 := NULL,
		 P_MSG1		IN		VARCHAR2 := NULL )
	IS
		TM_NOW TIMESTAMP := SYSTIMESTAMP;
	BEGIN
		IF P_ERRMSGS IS NULL THEN TM_START := TM_NOW; TM_LAP := TM_NOW; END IF;

		SET_ERRMSGS(P_ERRMSGS,0,'1',P_ID
						,ltrim(to_char(TM_NOW-TM_LAP  ,'SSSSS.ff5'),'+0 :')
						,ltrim(to_char(TM_NOW-TM_START,'SSSSS.ff5'),'+0 :')
						,P_MSG1);
		TM_LAP := TM_NOW;
	END SET_TIMEMSG;

	---------------------------------------------------------------------------
	-- エラーメッセージ配列出力関数 3.8.9.5 (2007/09/29)
	---------------------------------------------------------------------------
	PROCEDURE OUTPUT_ERRMSGS
		(P_ERRMSGS	IN	ERR_MSG_ARRAY,
		 P_JOBID	IN	VARCHAR2,
		 P_PGNAME	IN	VARCHAR2) IS
	BEGIN
		IF P_ERRMSGS IS NOT NULL THEN
			FOR I IN 1..P_ERRMSGS.COUNT LOOP
				--ログ出力
				LOCAL_MSG_RTN(P_ERRMSGS(I).PG
							,P_ERRMSGS(I).STEP
							,P_ERRMSGS(I).ID || ' ' ||
							 P_ERRMSGS(I).MSG1 || ' ' ||
							 P_ERRMSGS(I).MSG2 || ' ' ||
							 P_ERRMSGS(I).MSG3 || ' ' ||
							 P_ERRMSGS(I).MSG4 || ' ' ||
							 P_ERRMSGS(I).MSG5
							,P_JOBID
							,P_PGNAME);
			END LOOP;
		END IF;
	END OUTPUT_ERRMSGS;

	---------------------------------------------------------------------------
	-- エラーメッセージ配列のステータス最大値取得関数 3.8.9.5 (2007/09/29)
	---------------------------------------------------------------------------
	FUNCTION GET_MAX_KEKKA
		(P_ERRMSGS	IN	ERR_MSG_ARRAY,
		 P_ROWNO	IN	NUMBER := 1
		) RETURN NUMBER -- 4.3.1.1 (2008/10/08) 検索開始行番号を指定できるように修正
	IS
		L_COUNT NUMBER(5) := 0;
		L_KEKKA NUMBER(1) := 0;
	BEGIN
		IF P_ERRMSGS IS NOT NULL THEN
			FOR L_COUNT IN P_ROWNO..P_ERRMSGS.COUNT LOOP
				IF L_KEKKA < P_ERRMSGS(L_COUNT).KEKKA THEN
					L_KEKKA := P_ERRMSGS(L_COUNT).KEKKA;
				END IF;
			END LOOP;
		END IF;
		RETURN L_KEKKA;
	END GET_MAX_KEKKA;

END HYBS;
;
