<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
左のチャートをクリックする事で、右のチャートのデータをajax経由で持ってきて更新します。

	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query>
		SELECT DEPTNO
			,DNAME LABELS
			,(select sum(SAL) from emp where emp.deptno = dept.deptno) SAL
		FROM DEPT
		order by 1
	</og:query>
<div style="float:left;">	
	<og:jsChart
		chartType			= "pie"
		height				= "{@height}"
		width				= "{@width}"
		max					= "{@max}"
		min					= "{@min}"
		labelColumn			= "LABELS"
		title				= "{@title}"
		titlePosition		= "{@titlePosition}"
		legendDisplay		= "{@legendDisplay}"
		legendPosition		= "{@legendPosition}"
		xscaleType			= "{@xscaleType}"
		yscaleType			= "{@yscaleType}"
		ycategoryList		= "{@ycategoryList}"
		optionAttributes	= ""
		onClick				= "updatechart(obj[0])"
		debug				= "{@debug}"
	>
	<og:jsChartData
			chartColumn			= "SAL"
			borderColor			= "{@borderColor}"
			borderWidth			= "{@borderWidth}"
			backgroundColor		= "{@backgroundColor}"
			optionAttributes	= ""
			 />
	</og:jsChart>
</div>
	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query scope="request" tableId="tbl2">
		SELECT JOB LABELS
			,sum(SAL) as SAL
		FROM emp
		group by job
		order by 1
	</og:query>
<div>
	<og:jsChart
		chartType			= "bar"
		height				= "{@height}"
		width				= "{@width}"
		max					= "10000"
		min					= "{@min}"
		labelColumn			= "LABELS"
		legendDisplay		= "false"
		optionAttributes	= ""
		onClick				= "alert(obj[0]._model.label + ' ' + selDeptno);"
		scope="request"
		tableId="tbl2"
		debug				= "{@debug}"
	>
	<og:jsChartData
			chartColumn			= "SAL"
			borderColor			= "{@borderColor}"
			borderWidth			= "{@borderWidth}"
			backgroundColor		= "{@backgroundColor}"
			optionAttributes	= ""
			 />
	</og:jsChart>
</div>


<script>
var selDeptno = "";
var updatechart = function(chartobj){
	// ここがやや強引。元のJSONからindexでDEPTNOを引っ張ってくる
	selDeptno = qd_hybscanvash_tblmdl.DATA[chartobj._index].DEPTNO;
	$.ajax({
			url:'sample5_ajax.jsp?DEPTNO='+selDeptno,
			async:true, // 非同期通信
			type: 'GET',
			dataType: 'json',
			success: function(jsn){
				var _datadata = [];
				var _datalabels = [];
				for(var i=0; i&lt; jsn.DATA.length; i++){
					_datadata[i] = jsn.DATA[i].SAL;
					_datalabels[i] = jsn.DATA[i].LABELS;
				}
				// ラベル変更は難しいが、データセットの変更だけなら簡単
				// 新たなラベルが増えるような場合が面倒になる？
				chart_hybscanvastbl2.data.datasets[0].data = _datadata;
				chart_hybscanvastbl2.update();
				qd_hybscanvastbl2 = jsn; // 一応書き換えて二次利用可能にする
			}
		});
}

</script>
	
</jsp:root>