/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.common;

import org.opengion.fukurou.system.OgRuntimeException ;		// 6.4.2.0 (2016/01/29)

// import static org.opengion.fukurou.system.HybsConst.CR ;		// 6.1.0.0 (2014/12/26)
// import org.opengion.fukurou.util.StringUtil ;			// 6.0.2.5 (2014/10/31)

/**
 * 共通的に使用されるエクセプションクラスです。
 *
 * RuntimeException を継承しているため、try{} catch() {} は不要です。
 * 本システムでは、すべてこのエクセプションクラスを継承させたクラスを作成し、用途によって、
 * 使い分けるようにします。つまり、他のどのような、Throwable が発生したとしても、一旦、
 * try{} catch() {} で受けて、このクラスのサブクラスを、再度 throw させます。
 * そして、必要であれば、try{} catch() {} を用いて捕まえて、それぞれの対応処理を行います。
 *
 * このクラスには、元々の発生したエクセプション( Throwable )を引数にとり、
 * その printStackTrace()情報を、自分自身のトレース情報に含めます。
 * また、引数にオブジェクトを渡すことができますので、object.toString() で、オブジェクトの
 * 状態を表示できるようにしておけば、手軽にデバッグに使うことが可能になります。
 *
 * @og.group エラー処理
 * @og.rev 5.6.7.1 (2013/08/09) エラーに、エンジンのバージョン等のシステム関係の情報を付与します。
 * @og.rev 6.0.2.5 (2014/10/31) エラーに、エラー箇所の情報も与えます。
 * @og.rev 6.4.2.0 (2016/01/29) 継承元を、RuntimeException ではなく、OgRuntimeException に変更。
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
// public class HybsSystemException extends RuntimeException {
public class HybsSystemException extends OgRuntimeException {
	private static final long serialVersionUID = 642020160129L ;

//	/** ４タブの代わりのスペース */
//	private static final String TAB = "    " ;

//	/** 終わりが判るように罫線を打つ */
//	private static final String ENDLINE = "==================================================" ;	// 6.3.8.0 (2015/09/11)

//	/** エラーメッセージに付与するシステム関係の情報 5.6.7.3 (2013/08/23) */
//
//	// 6.0.2.5 (2014/10/31) 表示内容を変更します。
//	private static final String ERR_INFO =
//							TAB + "at ["
//								+ HybsSystem.sys( "SYSTEM_ID"    )	+ "] "
//								+ HybsSystem.sys( "ENGINE_INFO"  )	+ CR			// 5.6.6.0 Release5 Builds (2013182)
//								+ TAB + "→ " + HybsSystem.sys( "REAL_PATH" ) ;		// C:/opengionV6/uap/webapps/gf/

	// 6.4.2.0 (2016/01/29) 表示内容を変更します。
	/** エラーメッセージに付与するシステム関係の情報 5.6.7.3 (2013/08/23) */
	private static final String ERR_INFO =
								  "SYSTEM_ID=["
								+ HybsSystem.sys( "SYSTEM_ID" )	+ "] : "
								+ HybsSystem.sys( "REAL_PATH" );					// C:/opengionV6/uap/webapps/gf/

	/**
	 *  詳細メッセージを指定しないで HybsSystemException を構築します。
	 *
	 * @og.rev 5.6.7.1 (2013/08/09) エラーに、エンジンのバージョン等の情報を付与します。
	 * @og.rev 6.4.2.0 (2016/01/29) 継承元が、OgRuntimeException なので、エンジンバージョンは、組み込まれます。
	 *
	 * @see		org.opengion.fukurou.system.OgRuntimeException#OgRuntimeException()
	 */
	public HybsSystemException() {
		super();								// 6.0.2.5 (2014/10/31)

		addMessage( ERR_INFO );					// 6.4.2.0 (2016/01/29)

//		printStack();							// 6.0.2.5 (2014/10/31)
	}

	/**
	 *  指定された詳細メッセージを持つ HybsSystemException を構築します。
	 *
	 * @og.rev 5.6.7.1 (2013/08/09) エラーに、エンジンのバージョン等の情報を付与します。
	 * @og.rev 6.4.2.0 (2016/01/29) 継承元が、OgRuntimeException なので、エンジンバージョンは、組み込まれます。
	 *
	 * @param	msg	詳細メッセージ
	 * @see		org.opengion.fukurou.system.OgRuntimeException#OgRuntimeException(String)
	 */
	public HybsSystemException( final String msg ) {
		super( msg );

		addMessage( ERR_INFO );					// 6.4.2.0 (2016/01/29)

//		printStack();							// 6.0.2.5 (2014/10/31)
	}

	/**
	 *  指定された詳細メッセージを持つ HybsSystemException を構築します。
	 *
	 * @og.rev 5.6.7.1 (2013/08/09) エラーに、エンジンのバージョン等の情報を付与します。
	 * @og.rev 6.4.2.0 (2016/01/29) 継承元が、OgRuntimeException なので、エンジンバージョンは、組み込まれます。
	 *
	 * @param	th	例外Throwableオブジェクト
	 * @see		org.opengion.fukurou.system.OgRuntimeException#OgRuntimeException(Throwable)
	 */
	public HybsSystemException( final Throwable th ) {
		super( th );

		addMessage( ERR_INFO );					// 6.4.2.0 (2016/01/29)

//		printStack();							// 6.0.2.5 (2014/10/31)
	}

	/**
	 *  指定されたオブジェクトを受け取る HybsSystemException を構築します。
	 *
	 * @og.rev 3.5.5.4 (2004/04/15) 引数を、RuntimeException(String , Throwable )にあわせます。
	 * @og.rev 5.6.7.1 (2013/08/09) エラーに、エンジンのバージョン等の情報を付与します。
	 *
	 * @param	msg	詳細メッセージ
	 * @param	th	例外Throwableオブジェクト
	 * @see		org.opengion.fukurou.system.OgRuntimeException#OgRuntimeException(String,Throwable)
	 */
	public HybsSystemException( final String msg,final Throwable th ) {
		super( msg,th );

		addMessage( ERR_INFO );					// 6.4.2.0 (2016/01/29)

//		printStack();							// 6.0.2.5 (2014/10/31)
	}

//	/**
//	 *  エラー時の情報を、標準エラーメッセージに出力します。
//	 *
//	 * @og.rev 6.0.2.5 (2014/10/31) エラー時の情報を増やします。
//	 * @og.rev 6.3.8.0 (2015/09/11) エラーメッセージが２重になっていたので、バージョン情報のみにする。
//	 *
//	 */
//	private void printStack() {
//		System.err.println( ERR_INFO );
//		System.err.println( ENDLINE );			// 6.3.8.0 (2015/09/11)
////		System.err.print( TAB );
////		System.err.println( getMessage() );
////		System.err.println( StringUtil.ogStackTrace( this ) );
//	}
}
