/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

/**
 * DBLABEL レンデラーは、値をラベルリソースの表示ラベルに変換するクラスです。
 *
 * DBMENU で同様の処理を記述できますが、ラベルリソース に限定した使い方を
 * 想定してます。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 4.0.0.0 (2006/11/16) 新規作成
 * @og.group データ表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_DBLABEL extends AbstractRenderer {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0.0 (2006/11/16)" ;

	private static final CellRenderer DB_CELL = new Renderer_DBLABEL() ;

	private final ResourceManager resource ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Renderer_DBLABEL() {
		super();		// 6.4.1.1 (2016/01/16) PMD refactoring. It is a good practice to call super() in a constructor
		resource = ResourceFactory.newInstance( "ja" );		// 日本語だけ特別
	}

	/**
	 * デフォルトコンストラクター。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Renderer_DBLABEL( final DBColumn clm ) {
		super();		// 6.4.1.1 (2016/01/16) PMD refactoring. It is a good practice to call super() in a constructor
		final String lang = clm.getLang();
		resource = ResourceFactory.newInstance( lang );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 * @og.rtnNotNull
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		// 6.4.1.1 (2016/01/16) PMD refactoring. A method should have only one exit point, and that should be the last statement in the method
		return "ja".equalsIgnoreCase( clm.getLang() ) ? DB_CELL : new Renderer_DBLABEL( clm );

//		if( "ja".equalsIgnoreCase( clm.getLang() ) ) {
//			return DB_CELL ;
//		}
//
//		return new Renderer_DBLABEL( clm );
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param   value 入力値
	 *
	 * @return  データの表示用文字列
	 */
	@Override
	public String getValue( final String value ) {
		// 6.4.1.1 (2016/01/16) PMD refactoring. A method should have only one exit point, and that should be the last statement in the method
		return value == null || value.isEmpty() ? "" : resource.getLabel( value );

//		if( value == null || value.isEmpty() ) { return ""; }
//
//		return resource.getLabel( value );
	}
}
