<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" adjustEvent="Task" />	<!-- 積上げ(内部)処理 -->

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7218"
	title	= "積上げガント（内部積上)"
	date	= "2012/11/17"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>
<!--製番未入力の場合 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT	 NOORDER				NOORDER
			,DYORDER				DYJYU
			,DYNOKI					DYNOKI
			,ROWNUM*0.4+0.6			COSTCLM
			,0.4					CAPACITY
	FROM GF45
	<og:where>
		<og:and value="NOORDER = '{@NOORDER}'" />
		<og:and value="DYORDER IS NOT NULL" />
	</og:where>
	ORDER BY NOORDER,PN
</og:query>

<og:view
	viewFormType = "HTMLStackedGanttTable"
	command		 = "{@command}"
	writable	 = "false"
	useScrollBar = "false"
	useParam	 = "true"
	numberType = "none"
>
	<!-- stackParamでstackColumnsを指定しなかった場合はcustomTableとほぼ同じ処理となる -->
	<og:stackParam
		stackColumns	= "NOORDER"
		innerStack		= "true"
		costColumns		= "COSTCLM,DYJYU,DYNOKI"
		stackHoliday	= "{@stackHoliday}"
		capacityColumn	= "CAPACITY"
	/>
	<og:thead rowspan="2">
		<tr>
			<td>[NOORDER]</td>
			<td rowspan="2" class="gantt zoom{@SZOOM}" style="text-align:left;background-image: url('../image/stackBG{@SZOOM}.gif');" >
				<div style="position:relative;left:0px;z-index:101; " height="100%" width="100%" >
					<og:ganttHeader
						startDate	= "{@startDate}"
						endDate		= "{@endDate}"
						zoom		= "{@SZOOM}"
						calDB		= "GF13"
						arg1		= "A"
					/>
				</div>
			</td>
		</tr>
	</og:thead>
	<og:tbody rowspan="2">
		<tr>
			<td>[NOORDER]</td>
		</tr>
	</og:tbody>
</og:view>

	<!-- 負荷表示 -->
	<og:iTask
		fixedCols="4"
	/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
