<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7201"
	title	= "横棒／縦棒グラフ"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="0" stopZero="true">
			SELECT 	 DEPTNO							<!-- 営業担当者 -->
					,ENAME
					,JOB
					,SAL
		--			,COUNT(SAL)  AS CNT
		--			,SUM(SAL)    AS SUM
		--			,AVG(SAL)    AS AVG
		--			,STDDEV(SAL) AS STDDEV
					,MGR
					,COMM
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
		--	group by DEPTNO
			order by DEPTNO
</og:query>

<og:tableFilter classId="STDDEV" selectedAll="true" caseKey="{@command}" caseVal="NEW|RENEW"
	keys="GROUP_KEY,VAL_KEY"
	vals="DEPTNO,SAL"
/>

	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
