<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<!-- 画面遷移なしモードを有効にします -->
<og:head headType="result" noTransition="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9430"
	title	= "特殊(遷移なし)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select CASE KBSAKU WHEN '3' THEN '0' ELSE KBSAKU END AS WRITABLE,
				CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ
		from GF41
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"  />
		<og:and value = "LANG        = '{@LANG}'"           />
		<og:and value = "CLM         like '{@CLM}'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor column="SYSTEM_ID" must="true" />
<og:columnEditor column="LANG"      must="true" />
<og:columnEditor column="CLM"       must="true" />

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9000" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,[SYSTEM_ID],[LANG],[CLM],[KBSAKU],true" />
</og:viewLink>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" >
		<span style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- 画面遷移なしモードで登録を行うため、formのidを"noTransition"とします。-->
<!-- idが指定されていない場合は、1番目のformに対して動的入力モードが適用されます。 -->
<form method="POST" action="forward.jsp" target="RESULT" id="noTransition">

<!-- 画面遷移なしモードでは、登録ボタンも合わせて表示します -->
<og:writeCheck>
	<fieldset style="display:inline; padding: 5px; margin-left: 10px;">
		<legend><strong><og:message lbl="DATA_REGISTRATION" /></strong></legend>
		<og:submit  action="ENTRY" />
	</fieldset>
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType	= "HTMLTable"
	command			= "{@command}"
	noDisplay		= "FGJ"
	noWritable		= "LANG,CLM"
	writable		= "true"
	checked			= "true"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
