/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.report;

// import java.util.Map;

import org.opengion.hayabusa.db.DBTableModel;

/**
 * CSV発行用インターフェースです。
 *
 * @og.group 帳票システム
 *
 * @version  4.0
 * @author   Hiroki Nakamura
 * @since    JDK5.0,
 */
public interface CSVPrintPointService {

	/**
	 * 帳票起動された要求番号をセットします。
	 *
	 * @param   ykno 要求NO
	 */
	void setYkno( String ykno ) ;

	/**
	 * システムIDをセットします。
	 *
	 * @param   systemId システムID
	 */
	void setSystemId( String systemId ) ;

	/**
	 * 実行方法をセットします。
	 *
	 * @param   fgrun 実行方法
	 */
	void setFgrun( String fgrun ) ;

	/**
	 * 帳票デーモンが実行されているホスト名をセットします。
	 *
	 * @param   hostName ホスト名
	 */
	void setHostName( String hostName ) ;

	/**
	 * プリンター名をセットします。
	 *
	 * @param   printerName プリンタ名
	 */
	void setPrinterName( String printerName ) ;

	/**
	 * DBTableModel をセットします。
	 *
	 * @param	table	DBTableModelオブジェクト
	 */
	void setTable( DBTableModel table ) ;

	/**
	 * DBTableModel をセットします。(ヘッダー）
	 *
	 * @param	table	DBTableModelオブジェクト
	 */
	void setTableH( DBTableModel table ) ;

	/**
	 * DBTableModel をセットします（フッター）。
	 *
	 * @param	table	DBTableModelオブジェクト
	 */
	void setTableF( DBTableModel table ) ;

	/**
	 * 起動するプログラムのディレクトリをセットします。
	 *
	 * @param	dir	PG起動ディレクトリ
	 */
	void setPrgDir( String dir );

	/**
	 * 起動するプログラムをセットします。
	 *
	 * @param	file	PGファイル名
	 */
	void setPrgFile( String file );

	/**
	 * ファイル出力時のディレクトリを指定します。
	 *
	 * @param	dir	出力ディレクトリ
	 */
	void setOutDir( String dir );

	/**
	 * プリンタIDをセットします。
	 *
	 * @param	id	プリンタID
	 */
	void setPrtId( String id );

	/**
	 * プリンターポート名をセットします。
	 *
	 * @param	port	ポート名
	 */
	void setPortnm( String port ) ;

	/**
	 * 帳票IDをセットします。
	 *
	 * @param	id	帳票ID
	 */
	void setListId( String id ) ;

	/**
	 * 帳票名をセットします。
	 *
	 * @param	name	帳票名
	 */
	void setModelname( String name ) ;

	/**
	 * レイアウトファイルをセットします。
	 *
	 * @param	file	レイアウトファイル
	 */
//	void setLayoutFile( String file );

	/**
	 * グループIDをセットします。
	 * 
	 * @og.rev 5.9.2.2 (2015/11/20)
	 * 
	 * @param	id	グループID
	 */
	void setGrpId( String id ) ;

	/**
	 * デーモングループをセットします。
	 * 
	 * @og.rev 5.9.2.2 (2015/11/20)
	 * 
	 * @param	name	デーモングループ
	 */
	void setDmnGrp( String name ) ;

	/**
	 * オプション文字列をセットします。
	 * 
	 * @og.rev 5.9.3.0 (2015/12/04)
	 * 
	 * @param   option オプション文字列
	 */
	void setOption( String option ) ;

	/**
	 * ページエンドカットフラグをセットします。
	 * 
	 * @og.rev 5.9.3.0 (2015/12/04)
	 * 
	 * @param	flg	ページエンドカットフラグ
	 */
	void setFgcut( String flg ) ;

	/**
	 * 現在の印刷状況を返します。
	 *
	 *
	 * @return	完成フラグ
	 */
	String getFgkan();

	/**
	 * エラーメッセージを返します。
	 *
	 *
	 * @return	エラーメッセージ
	 */
	String getErrMsg();

	/**
	 * CSV発行処理を実行します。
	 *
	 *
	 * @return	実行結果[true:正常/false:異常]
	 */
	boolean execute() ;
}
