/********************************************************************************************/
/* VIEWのカラムマニュアル表示 5.5.4.0 (2012/07/02) 											*/
/*																							*/
/* VIEWテーブルの情報より、カラムのマニュアルを表示します。							       	*/
/* 利用変数はクロージャーで隠蔽します。														*/
/* img#viewHelpIconがヘルプのアイコンとなります												*/
/*																							*/
/* Modified: 2012/07/18 Field登録／表示の場合も項目説明が作成されるように対応				*/
/*				Scroll対応																	*/
/* Modified: 6.2.5.0 (2015/06/05) resultScript.js から分離。(query.jspでも使う)				*/
/* Modified: 6.2.6.0 (2015/06/19) 画面の概要説明も表示できるように修正						*/
/* Revision: $Id$																			*/
/*******************************************************************************************/
var showViewManual = (function(){
	var fgClicked = false;
	// 画面上の座標の取得
	// Modified: 2012/07/18 スクロール対応
	function getElementScreenPosition( inObj )
	{
		var html = document.documentElement;
		var rect = inObj.getBoundingClientRect();
		var scrollLeft = document.documentElement.scrollLeft || document.body.scrollLeft;
		var left =  scrollLeft > 0 ? rect.left - html.clientLeft + scrollLeft : rect.left - html.clientLeft ;
		var top  = rect.top  - html.clientTop;
		
		left = left < 0 ? 0 : left;
		top = top < 0 ? 0 :top;
		
		return { left:left, top:top };
	}
	//
	function closeDivs( inObj1 ,inObj2 ){
		inObj1.parentNode.removeChild( inObj1 );
		inObj2.parentNode.removeChild( inObj2 );
		fgClicked = false;
	}
	// ヘッダーかどうかの判定
 	function isHeader( inObj ){
 		if( inObj.parentNode.tagName == "TH" ){
 			return true;
 		}
 		else if( inObj.parentNode.tagName == "BODY" ){
 			return false;
 		}
 		else{
 			return isHeader( inObj.parentNode );
 		}
 	}
	// ラベル（<td class="label">）の判定 2012/07/18 mod
 	function isLabel( inObj ){
 		if( inObj.parentNode.tagName == "TD" && inObj.parentNode.className == "label" ){
 			return true;
 		}
 		else if( inObj.parentNode.tagName == "BODY" ){
 			return false;
 		}
 		else{
 			return isLabel( inObj.parentNode );
 		}
 	}
	// 6.2.6.0 (2015/06/19) 画面の概要説明の判定。id="design-header-title" があれば画面概要と判定
 	function isGuiDesc( inObj ){
		if( inObj != null && inObj.parentNode != null ) {
	 		if( inObj.parentNode.id == "design-header-title" ){
	 			return true;
	 		}
	 		else{
	 			return isGuiDesc( inObj.parentNode );
	 		}
		}
		else {
			return false;
		}
 	}
	// マニュアルの表示
	// クロージャーとして利用
	// _mode:1なら単純にヘッダがある(1)かない(0)かだけ返す。それ以外は通常実行
	return function(_mode){
		if( fgClicked == true ){ return true; }
		var objSpan   = $("span");
		var objBody   = $("body");

		var countSpan = objSpan.length;

		var spanTable = $("<table/>"); 
		spanTable.css({
					 border			:"solid black 1px"
					,borderCollapse	:"collapse"
					,cellSpacing 	:"0px"
					,cellPadding 	:"0px"
					});
		spanTable.attr("cellPadding" ,"3");
		spanTable.attr("border" ,"1");

		var spanTitle = "";
		var spanKey   = "";
		var keyList = new Object();
		var conList = new Object();
		var fgShow  = 0;
		// 項目の概要説明がない時、または概要説明と項目名称が同内容となっている時は非表示する
		for( i = 0 ;i < countSpan ;i++ ){
//			if( !isHeader( objSpan[i] )) continue;
			// Field型の表示にも、作成するように対応 2012/07/18 mod
			// 6.2.6.0 (2015/06/19) 画面の概要説明も表示できるように修正。
//			if( !isHeader( objSpan[i] ) && !isLabel( objSpan[i] )) continue;
			if( !isHeader( objSpan[i] ) && !isLabel( objSpan[i] ) && !isGuiDesc( objSpan[i] )) continue;
			spanTitle = objSpan[i].title;
			spanKey   = $(objSpan[i]).text();
			if( spanTitle.length > 0 && spanTitle != spanKey ){
				keyList[spanKey] = spanKey;
				conList[spanKey] = spanTitle;
				fgShow = 1;
			}
		}
		
		// 判定モードの場合
		if( _mode == '1'){
			return fgShow;
		}
		
		if( fgShow == 0 ){ return true; }
		fgClicked = true;
		// 内容
		// 6.2.6.0 (2015/06/19) title属性の設定に、レイアウトされるように、preタグで囲う。
		for( var keyString in keyList ){
//			spanTable.append("<tr><td bgcolor='black'><font color='white'>" + keyList[keyString] + "</font></td><td>" + conList[keyString] + "</td></tr>");
			spanTable.append("<tr><td bgcolor='black'><font color='white'>" + keyList[keyString] + "</font></td>"
							+ "<td><pre>" + conList[keyString] + "</pre></td></tr>");
		} 
		//
		var objThead     = $("#header").get(0);
		var headerLeft  ;
		var headerTop   ;
		var headerHeight;
		//
		if( objThead ){
			headerLeft   = getElementScreenPosition( objThead ).left;
			headerTop    = getElementScreenPosition( objThead ).top;
			headerHeight = objThead.offsetHeight;
		}
		else{
			headerLeft   = 0;
			headerTop    = 0;
			headerHeight = 0;
		}

		var popDiv 		 = $("<div></div>"); 

		popDiv.append( spanTable );
		popDiv.css({
					 position		:"absolute"
					,backgroundColor:"white"
					,top			:headerTop  + 2 + headerHeight
					,left 			:headerLeft + 2
					,zIndex 		:2
					});

		objBody.append( popDiv );

		// 影の作成
		var shadowDiv = $("<div></div>"); 
		shadowDiv.css({
					 position		:"absolute"
					,backgroundColor:"gray"
					,top			:headerTop  + 10 + headerHeight
					,left 			:headerLeft + 10
					,width			:popDiv.width()
					,height			:popDiv.height()
					,zIndex 		:1
					});
		objBody.append( shadowDiv );

		// 閉じるボタン
		var divClose   = $("<div></div>");
		var imgClose   = $("<img/>");
		imgClose.attr("src"     ,"../image/status_Close.png");
		imgClose.bind("click" ,function(){ closeDivs( popDiv.get(0) ,shadowDiv.get(0) ); });

		imgClose.css({
					 width  :"15px"
					,height :"15px"
					});

		divClose.append( imgClose );
		divClose.css({
					 position		:"absolute"
					,border			:"solid black 1px"
					,top			:0
					,left 			:parseInt( popDiv.offset().left ,10 ) + parseInt( popDiv.width() , 10 )
					,zIndex 		:3
					});

		popDiv.append( divClose );

		// Closeボタンの追加によるサイズ調整 2012/07/18 mod
		spanTable.width( spanTable.width() + 21 );
		shadowDiv.width( popDiv.width());

		// ポップアップのドラッグ処理
		popDiv.attr("id" ,"dragDiv");
		// uiが読み込まれてdrag可能な場合のみ実行
		if(typeof $("#dragDiv").draggable == "function"){
			$("#dragDiv").draggable({
				 opacity  : 0.5
			    ,cursor   : 'move'
				,start	 : function( event ,ui ){
					shadowDiv.css("display" ,"none");
				 }
				,stop	 : function( event ,ui ){
					shadowDiv.css({
								 left 	: parseInt( popDiv.offset().left , 10 ) + 8
								,top  	: parseInt( popDiv.offset().top  , 10 ) + 8
								,display:"block"
								})
				 }
			});
		}
	};
})();

// helpで表示する内容がなければviewHelpIconを消す。
$(function(){
	if(showViewManual('1') == '0'){
		$('img#viewHelpIcon').css('display','none');
	}
});

