/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.fileexec.DBUtil;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public final class CommandLine {
    private static final XLogger LOGGER = XLogger.getLogger(CommandLine.class.getName());
    private static final Map<String, String> IN2OUT = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("1", "3");
        }
    });
    private static final String[] UPD_KEYS = new String[]{"FGYKAN", "DYUPD", "PGUPD"};
    private static final String UPD_WHERE = "SYSTEM_ID=? and RSRV_NO=?";
    private static final String UPD_QUER = DBUtil.getUpdateSQL("GE70", UPD_KEYS, null, null, "SYSTEM_ID=? and RSRV_NO=?");
    private final String[] cmndData;
    private final String cmndStr;
    private final ConcurrentMap<String, String> kvMap = new ConcurrentHashMap<String, String>();

    private CommandLine(String[] stringArray) {
        this.cmndData = Arrays.copyOf(stringArray, stringArray.length);
        this.cmndStr = Arrays.toString(this.cmndData);
        LOGGER.debug(() -> this.cmndStr);
        if (this.cmndData[GE70.RSRV_NO.NO] == null || this.cmndData[GE70.EXECID.NO] == null) {
            throw MsgUtil.throwException("MSG2001", this.cmndStr);
        }
        String string = this.cmndData[GE70.FILE_FILTER.NO];
        if (string != null && !string.trim().isEmpty() && string.indexOf(61) >= 0) {
            for (String string2 : string.split(" ")) {
                int n = string2.indexOf(61);
                if (n <= 0) continue;
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if (string3.isEmpty()) continue;
                this.kvMap.put(string3, string4);
            }
        }
    }

    public String getValue(GE70 gE70) {
        return this.cmndData[gE70.NO];
    }

    public ConcurrentMap<String, String> getKeyValMap() {
        return this.kvMap;
    }

    public static List<CommandLine> dbCommand() {
        ArrayList<CommandLine> arrayList = new ArrayList<CommandLine>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        String string = StringUtil.getTimeFormat();
        List<String[]> list = DBUtil.dbQuery(GE70.SELECT, new String[0]);
        for (String[] stringArray : list) {
            arrayList.add(new CommandLine(stringArray));
            String string2 = IN2OUT.get(stringArray[GE70.FGYKAN.NO]);
            if (string2 == null) continue;
            String[] stringArray2 = new String[]{string2, string, "CMNDLine", stringArray[GE70.SYSTEM_ID.NO], stringArray[GE70.RSRV_NO.NO]};
            arrayList2.add(stringArray2);
        }
        DBUtil.execute(UPD_QUER, arrayList2);
        return arrayList;
    }

    public String toString() {
        return this.cmndStr;
    }

    public static enum GE70 {
        SYSTEM_ID,
        RSRV_NO,
        NAME_JA,
        EXECID,
        FGYKAN,
        DIR_BASE,
        DIR_SUB,
        DIR_WORK,
        DIR_BKUP_OK,
        DIR_BKUP_NG,
        FILE_FILTER;

        private static final String FROM_WHERE = " from GE70 where FGYKAN in ('1','4') order by SYSTEM_ID,RSRV_NO";
        public static final String SELECT;
        public final int NO = this.ordinal();

        static {
            StringJoiner stringJoiner = new StringJoiner(",", "select ", FROM_WHERE);
            Arrays.stream(GE70.values()).forEachOrdered(gE70 -> stringJoiner.add(gE70.name()));
            SELECT = stringJoiner.toString();
        }
    }
}

