<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE7004"
	title    = "処理定義ﾏｽﾀ"
	date     = "2017/06/27"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<og:dataCheck
	command 	= "{@command}"
	from		= "GE74"
	where		= "SYSTEM_ID=[SYSTEM_ID] AND EXECID=[EXECID] AND FGJ in ('0','1')"
/>

<og:transaction>
	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			sqlType			= "{@sqlType}"
			table			= "GE74"
			where			= "SYSTEM_ID=[SYSTEM_ID] AND UNIQ=[UNIQ]"
		/>
	</og:tableUpdate>

	<!-- SEQNOの再セット -->
	<og:query
		command		= "NEW"
		scope		= "request"
		maxRowCount	= "0" >
			SELECT SYSTEM_ID,SEQNO,UNIQ
			FROM   GE74
			WHERE  FGJ IN ( '0','1' )
			ORDER  BY SYSTEM_ID,SEQNO,EXECID
	</og:query>
	<og:tableFilter classId="SEQRESET" keys="SEQ_CLM,CLEAR_CLM" vals="SEQNO,SYSTEM_ID" selectedAll="true" scope="request" />
	<og:tableUpdate
		command		= "ENTRY"
		scope		= "request"
		selectedAll = "true"
		queryType	= "JDBCTableUpdate" >
			UPDATE GE74 SET
				SEQNO  = [SEQNO]
			WHERE SYSTEM_ID=[SYSTEM_ID] AND UNIQ=[UNIQ]
			AND SEQNO != [SEQNO]
	</og:tableUpdate>
</og:transaction>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
